/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingUp;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004ServerProvider
implements IUT2004ServerProvider {
    private static Map<String, UT2004Server> servers = new HashMap<String, UT2004Server>();
    private static Map<String, AtomicInteger> counts = new LazyMap<String, AtomicInteger>(){

        protected AtomicInteger create(String key) {
            return new AtomicInteger(0);
        }
    };
    protected Logger log;
    protected UT2004Server server;

    public UT2004ServerProvider() {
        this(null);
    }

    public UT2004ServerProvider(Logger log) {
        this.log = log;
        if (this.log == null) {
            this.log = new LogCategory("UT2004ServerProvider");
        }
    }

    @Override
    public UT2004Server getServer() {
        if (this.server == null) {
            this.init();
        }
        return this.server;
    }

    protected UT2004AgentParameters getDefaultServerParams() {
        UT2004AgentParameters result = new UT2004AgentParameters();
        return result;
    }

    public boolean isInited() {
        return this.server != null && this.server.inState(new Class[]{IAgentStateRunning.class});
    }

    public void init() {
        if (this.server != null && this.server.inState(new Class[]{IAgentStateRunning.class})) {
            return;
        }
        this.init(this.getDefaultServerParams());
    }

    public void init(UT2004AgentParameters params) {
        if (this.server != null && this.server.inState(new Class[]{IAgentStateRunning.class})) {
            return;
        }
        this.initForced(params);
    }

    public void initForced() {
        this.initForced(this.getDefaultServerParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initForced(UT2004AgentParameters params) {
        Map<String, UT2004Server> map = servers;
        synchronized (map) {
            ISocketConnectionAddress socketAddress = (ISocketConnectionAddress)params.getWorldAddress();
            String address = socketAddress == null ? this.getDefaultAddress() : String.valueOf(socketAddress.getHost().toLowerCase()) + ":" + socketAddress.getPort();
            UT2004Server server = servers.get(address);
            if (server != null) {
                UT2004Server uT2004Server = server;
                synchronized (uT2004Server) {
                    AtomicInteger count = counts.get(address);
                    count.incrementAndGet();
                    if (server.inState(new Class[]{IAgentStateUp.class})) {
                        this.server = server;
                        this.log.warning("UT2004Server count rised: " + address + " => " + count.get());
                        return;
                    }
                    if (server.inState(new Class[]{IAgentStateGoingUp.class})) {
                        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag)server.getState(), IAgentStateRunning.class).await(60000L, TimeUnit.MILLISECONDS);
                        if (state instanceof IAgentStateRunning) {
                            this.server = server;
                            this.log.warning("UT2004Server count rised: " + address + " => " + count.get());
                            return;
                        }
                        count.decrementAndGet();
                    }
                }
            }
            this.log.warning("Initializing. Creating UT2004Server...");
            this.killServer();
            UT2004ServerModule module = new UT2004ServerModule();
            UT2004ServerFactory factory = new UT2004ServerFactory(module);
            UT2004ServerRunner runner = new UT2004ServerRunner(factory);
            runner.setLogLevel(Level.SEVERE);
            server = (UT2004Server)runner.startAgents(new UT2004AgentParameters[]{params}).get(0);
            this.log.warning("Initialized. New UT2004Server instance created for: " + address);
            servers.put(address, server);
            counts.get(address).incrementAndGet();
            this.server = server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killServer() {
        if (this.server == null) {
            return;
        }
        ISocketConnectionAddress socketAddress = (ISocketConnectionAddress)this.server.getParams().getWorldAddress();
        String address = socketAddress == null ? this.getDefaultAddress() : String.valueOf(socketAddress.getHost().toLowerCase()) + ":" + socketAddress.getPort();
        Map<String, UT2004Server> map = servers;
        synchronized (map) {
            AtomicInteger count = counts.get(address);
            if (count.get() != 1) {
                this.log.warning("Decrementing UT2004Server instance: " + address + " -> " + count.decrementAndGet());
                this.server = null;
                return;
            }
            this.log.warning("Killing old UT2004Server instance...");
            count.decrementAndGet();
            servers.remove(address);
        }
        try {
            this.server.kill();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
    }

    protected String getDefaultAddress() {
        return (Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_HOST.getKey()) == null ? "localhost" : Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_HOST.getKey())) + ":" + (Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_PORT.getKey()) == 0 ? "3001" : "" + Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_SERVER_PORT.getKey()));
    }
}

