/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import com.google.common.collect.Lists;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RawLevelGeometryFile;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import math.geom3d.Point3D;
import math.geom3d.polygon.SimplePlanarPolygon3D;

public class Triangle
implements Serializable {
    private static final long serialVersionUID = 3L;
    public final Point3D[] vertices = new Point3D[3];
    public final transient Location[] verticesAsLoc = new Location[3];
    public final transient SimplePlanarPolygon3D planarPolygon;
    public final transient double signedAreaIn2dProjection;

    public Triangle(RawLevelGeometryFile.RawTriangle rawTriangle) {
        this(rawTriangle.vertices[0], rawTriangle.vertices[1], rawTriangle.vertices[2]);
    }

    public Triangle(Point3D vertexA, Point3D vertexB, Point3D vertexC) {
        if (Triangle.areVerticesOrderedClockwiseIn2dProjection(vertexA, vertexB, vertexC)) {
            Point3D tmp = vertexB;
            vertexB = vertexC;
            vertexC = tmp;
        }
        this.vertices[0] = vertexA;
        this.vertices[1] = vertexB;
        this.vertices[2] = vertexC;
        this.verticesAsLoc[0] = new Location(vertexA);
        this.verticesAsLoc[1] = new Location(vertexB);
        this.verticesAsLoc[2] = new Location(vertexC);
        this.planarPolygon = new SimplePlanarPolygon3D((Collection)Lists.newArrayList((Object[])new Point3D[]{this.vertices[0], this.vertices[1], this.vertices[2]}));
        this.signedAreaIn2dProjection = this.planarPolygon.getPolygonIn2d().getSignedArea();
    }

    public void draw(UT2004Server server, Location color) {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        String lines = this.toDebugString();
        d.setVectors(lines);
        d.setColor(color);
        d.setClearAll(false);
        server.getAct().act((CommandMessage)d);
    }

    protected String toDebugString() {
        StringBuilder debugString = new StringBuilder("");
        int i = 0;
        while (i < this.vertices.length) {
            if (debugString.length() > 0) {
                debugString.append(";");
            }
            Point3D v1 = this.vertices[i];
            Point3D v2 = this.vertices[(i + 1) % this.vertices.length];
            debugString.append(String.valueOf(v1.getX()) + "," + v1.getY() + "," + v1.getZ() + ";" + v2.getX() + "," + v2.getY() + "," + v2.getZ());
            ++i;
        }
        return debugString.toString();
    }

    protected static boolean areVerticesOrderedClockwiseIn2dProjection(Point3D vertexA, Point3D vertexB, Point3D vertexC) {
        SimplePlanarPolygon3D polygon = new SimplePlanarPolygon3D((Collection)Lists.newArrayList((Object[])new Point3D[]{vertexA, vertexB, vertexC}));
        return polygon.getPolygonIn2d().getSignedArea() < 0.0;
    }

    private Object readResolve() throws ObjectStreamException {
        return new Triangle(this.vertices[0], this.vertices[1], this.vertices[2]);
    }
}

