/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.bsp;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import math.bsp.BspOccupation;
import math.bsp.IBspStrategy;
import math.bsp.node.IConstBspLeafNode;
import math.bsp.strat.BspListDataStrategy;
import math.geom2d.line.StraightLine2D;

public abstract class XyProjectionTPolygonPartitioningStrategy<TPolygon>
extends BspListDataStrategy<TPolygon, StraightLine2D>
implements IBspStrategy<ArrayList<TPolygon>, StraightLine2D> {
    public static int STOP_SPLITTING_NUMBER_OF_POLYGONS = 1;

    public boolean shouldSplit(IConstBspLeafNode<ArrayList<TPolygon>, StraightLine2D> leafNode) {
        return ((ArrayList)leafNode.getData()).size() > STOP_SPLITTING_NUMBER_OF_POLYGONS;
    }

    public StraightLine2D findBoundary(IConstBspLeafNode<ArrayList<TPolygon>, StraightLine2D> leafNode) {
        StraightLine2D bestBoundary = null;
        double bestBoundaryMetric = 0.0;
        for (Object splittingPolygon : (ArrayList)leafNode.getData()) {
            List<Location> vertexLocations = this.getPolygonVertexLocations(splittingPolygon);
            for (int i = 0; i < vertexLocations.size(); ++i) {
                Location a = vertexLocations.get(i);
                Location b = vertexLocations.get((i + 1) % vertexLocations.size());
                StraightLine2D candidateBoundary = new StraightLine2D((Point2D)this.projectToXyPlane(a), (Point2D)this.projectToXyPlane(b));
                double totalPolygonCount = ((ArrayList)leafNode.getData()).size();
                double negativeSidePolygonCount = 0.0;
                double positiveSidePolygonCount = 0.0;
                for (Object polygon : (ArrayList)leafNode.getData()) {
                    BspOccupation occupation = this.determineElementOccupation(candidateBoundary, polygon);
                    if (occupation.intersectsNegative()) {
                        negativeSidePolygonCount += 1.0;
                    }
                    if (!occupation.intersectsPositive()) continue;
                    positiveSidePolygonCount += 1.0;
                }
                double candidateBoundaryMetric = Math.min(totalPolygonCount - negativeSidePolygonCount, totalPolygonCount - positiveSidePolygonCount);
                if (!(bestBoundaryMetric < candidateBoundaryMetric)) continue;
                bestBoundary = candidateBoundary;
                bestBoundaryMetric = candidateBoundaryMetric;
            }
        }
        return bestBoundary;
    }

    public BspOccupation determineElementOccupation(StraightLine2D boundary, TPolygon element) {
        boolean intersectsPositive = false;
        boolean intersectsNegative = false;
        for (Location vertexLocation : this.getPolygonVertexLocations(element)) {
            BspOccupation vertexOccupation = this.determinePointOccupation(boundary, vertexLocation);
            intersectsPositive = intersectsPositive || vertexOccupation.intersectsPositive();
            intersectsNegative = intersectsNegative || vertexOccupation.intersectsNegative();
        }
        return BspOccupation.get((boolean)intersectsNegative, (boolean)intersectsPositive);
    }

    public BspOccupation determinePointOccupation(StraightLine2D boundary, Location point) {
        if (boundary.getSignedDistance((Point2D)this.projectToXyPlane(point)) >= 0.0) {
            return BspOccupation.POSITIVE;
        }
        return BspOccupation.NEGATIVE;
    }

    protected math.geom2d.Point2D projectToXyPlane(Location point) {
        return new math.geom2d.Point2D(point.getX(), point.getY());
    }

    protected abstract List<Location> getPolygonVertexLocations(TPolygon var1);
}

