/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WallCollision;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Tuple3d;

public class KefikRunner
implements IUT2004PathRunner {
    private int runnerStep = 0;
    private int jumpStep = 0;
    private int collisionNum = 0;
    private Location collisionSpot = null;
    private double distance;
    private double distance2D;
    private double distanceZ;
    private double velocity;
    private double velocityZ;
    private boolean jumpRequired;
    private double fallDistance;
    private Location runningFrom;
    private Location firstLocation;
    private Location secondLocation;
    private ILocated focus;
    private NavPointNeighbourLink link;
    private boolean reachable;
    private boolean forceNoJump;
    protected WallCollision lastCollidingEvent = null;
    private static final double WALL_COLLISION_THRESHOLD = 1.0;
    IWorldEventListener<WallCollision> myCollisionsListener = new IWorldEventListener<WallCollision>(){

        public void notify(WallCollision event) {
            KefikRunner.this.lastCollidingEvent = event;
        }
    };
    protected UT2004Bot bot;
    protected AgentInfo memory;
    protected AdvancedLocomotion body;
    protected Logger log;

    public NavPointNeighbourLink getLink() {
        return this.link;
    }

    @Override
    public void reset() {
        this.runnerStep = 0;
        this.jumpStep = 0;
        this.collisionNum = 0;
        this.collisionSpot = null;
        this.lastCollidingEvent = null;
        this.distance = 0.0;
        this.distance2D = 0.0;
        this.distanceZ = 0.0;
        this.velocity = 0.0;
        this.velocityZ = 0.0;
        this.jumpRequired = false;
        this.forceNoJump = false;
    }

    private void debug(String message) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Runner: " + message);
        }
    }

    private double getFallDistance(double distanceZ) {
        if ((distanceZ = Math.abs(distanceZ)) == 60.0) {
            return 160.0;
        }
        if (distanceZ < 60.0) {
            return 2.66667 * distanceZ;
        }
        return 1.3714 * distanceZ + 35.527;
    }

    private double getMaxJumpDistance(boolean doubleJump, double jumpDelay, double jumpForce, double distanceZ, double velocity) {
        jumpForce = doubleJump ? Math.min(755.0, jumpForce) : Math.min(340.0, jumpForce);
        jumpDelay = Math.min(0.75, jumpDelay);
        if (distanceZ >= -5.0) {
            if (doubleJump) {
                return velocity * jumpDelay + jumpForce / 755.0 * 400.0 * (1.0 + jumpDelay);
            }
            return velocity * jumpForce;
        }
        return this.getFallDistance(distanceZ) + this.getMaxJumpDistance(doubleJump, jumpDelay, jumpForce, 0.0, velocity);
    }

    private double getJumpUpDistance(boolean doubleJump, double jumpDelay, double jumpForce, double distanceZ, double velocity) {
        double result;
        if (doubleJump) {
            jumpDelay = Math.min(0.75, jumpDelay);
            jumpForce = Math.min(755.0, jumpForce);
            double jumpForceHeight = jumpForce / 755.0 * 125.0;
            double totalTimeOfTheJump = jumpForce / 755.0 + jumpDelay;
            result = jumpForceHeight > distanceZ ? velocity * jumpDelay + 439.5 * ((totalTimeOfTheJump - jumpDelay) / 2.0) + 439.5 * ((totalTimeOfTheJump - jumpDelay) / 2.0 * (1.0 - distanceZ / jumpForceHeight)) : velocity * jumpDelay + (totalTimeOfTheJump - jumpDelay) / 2.0 * 439.5;
        } else {
            jumpForce = Math.min(340.0, jumpForce);
            double jumpForceHeight = jumpForce / 340.0 * 55.0;
            double totalTimeOfTheJump = jumpForce / 340.0;
            result = jumpForceHeight > distanceZ ? velocity * (totalTimeOfTheJump / 2.0) + velocity * (totalTimeOfTheJump / 2.0 * (1.0 - distanceZ / jumpForceHeight)) : velocity * (totalTimeOfTheJump / 2.0);
        }
        return result;
    }

    @Override
    public boolean runToLocation(Location runningFrom, Location firstLocation, Location secondLocation, ILocated focus, NavPointNeighbourLink navPointsLink, boolean reachable, boolean forceNoJump) {
        ++this.runnerStep;
        this.runningFrom = runningFrom;
        this.firstLocation = firstLocation;
        this.secondLocation = secondLocation;
        this.focus = focus;
        this.link = navPointsLink;
        this.reachable = reachable;
        this.forceNoJump = forceNoJump;
        this.distance = this.memory.getLocation().getDistance(firstLocation);
        this.distance2D = this.memory.getLocation().getDistance2D(firstLocation);
        this.distanceZ = firstLocation.getDistanceZ(this.memory.getLocation());
        this.fallDistance = this.distanceZ >= 0.0 ? 0.0 : this.getFallDistance(this.distanceZ);
        this.velocity = this.memory.getVelocity().size();
        this.velocityZ = this.memory.getVelocity().z;
        boolean bl = this.jumpRequired = !reachable || this.link != null && ((this.link.getFlags() & LinkFlag.JUMP.get()) != 0 || this.link.isForceDoubleJump() || this.link.getNeededJump() != null);
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.debug("KefikRunner!");
            this.debug("running to    = " + firstLocation + " and than to " + secondLocation + " and focusing to " + focus);
            this.debug("bot position  = " + this.memory.getLocation());
            this.debug("distance      = " + this.distance);
            this.debug("distance2D    = " + this.distance2D);
            this.debug("distanceZ     = " + this.distanceZ);
            this.debug("fallDistance  = " + this.fallDistance);
            this.debug("velocity      = " + this.velocity);
            this.debug("velocityZ     = " + this.velocityZ);
            this.debug("jumpRequired  = " + this.jumpRequired + (!reachable ? " NOT_REACHABLE" : "") + (this.link == null ? "" : ((this.link.getFlags() & LinkFlag.JUMP.get()) != 0 ? " JUMP_FLAG" : "") + (this.link.isForceDoubleJump() ? " DOUBLE_JUMP_FORCED" : "") + (this.link.getNeededJump() != null ? " AT[" + this.link.getNeededJump() + "]" : "")));
            this.debug("reachable     = " + reachable);
            if (this.link != null) {
                this.debug("link          = " + (Object)((Object)this.link));
            } else {
                this.debug("LINK NOT PRESENT");
            }
            this.debug("collisionNum  = " + this.collisionNum);
            this.debug("collisionSpot = " + this.collisionSpot);
            this.debug("jumpStep      = " + this.jumpStep);
            this.debug("runnerStep    = " + this.runnerStep);
        }
        if (this.runnerStep <= 1) {
            this.debug("FIRST STEP - start running towards new location");
            this.move((ILocated)firstLocation, (ILocated)secondLocation, focus);
        }
        if (this.jumpStep > 0) {
            this.debug("we're already jumping");
            return this.iterateJumpSequence();
        }
        if (this.isColliding()) {
            this.debug("sensing collision");
            return this.resolveCollision();
        }
        if (this.collisionSpot != null || this.collisionNum != 0) {
            this.debug("no collision, clearing collision data");
            this.collisionNum = 0;
            this.collisionSpot = null;
        }
        if (this.velocity < 5.0 && this.runnerStep > 1) {
            this.debug("velocity is zero and we're in the middle of running");
            if (this.link != null && (this.link.getFromNavPoint().isLiftCenter() || this.link.getFromNavPoint().isLiftExit())) {
                if (this.link.getFromNavPoint().isLiftCenter()) {
                    this.debug("we're standing on the lift center, ok");
                } else {
                    this.debug("we're standing on the lift exit, ok");
                }
            } else {
                this.debug("and we're not standing on the lift center");
                return this.initJump(true);
            }
        }
        if (this.jumpRequired) {
            this.debug("jump is required");
            return this.resolveJump();
        }
        this.debug("keeping running to the target");
        this.move((ILocated)firstLocation, (ILocated)secondLocation, focus);
        return true;
    }

    private boolean resolveJump() {
        this.debug("resolveJump(): called");
        int jumpDistance2D = (int)this.distance2D % 1000;
        this.debug("resolveJump(): jumpDistance2D = " + jumpDistance2D);
        boolean jumpIndicated = false;
        boolean mustJumpIfIndicated = false;
        boolean goingToJump = false;
        if (this.link != null && ((this.link.getFlags() & LinkFlag.JUMP.get()) != 0 || this.link.isForceDoubleJump() || this.link.getNeededJump() != null)) {
            this.debug("resolveJump(): deliberation - jumping condition present");
            boolean bl = jumpIndicated = !this.forceNoJump;
        }
        if (jumpDistance2D < 250) {
            this.debug("resolveJump(): we've missed all jumping opportunities (jumpDistance2D < 250)");
            if (this.runnerStep > 1) {
                this.debug("resolveJump(): and runnerStep > 1, if indicated we will be forced to jump right now");
                mustJumpIfIndicated = true;
            } else {
                this.debug("resolveJump(): but runnerStep <= 1, can't force jump yet");
            }
        }
        this.debug("resolveJump(): jumpIndicated       = " + jumpIndicated);
        this.debug("resolveJump(): mustJumpIfIndicated = " + mustJumpIfIndicated);
        if (jumpIndicated && mustJumpIfIndicated) {
            if (this.distanceZ > 0.0) {
                this.debug("resolveJump(): we MUST jump!");
                return this.prepareJump(true);
            }
            this.debug("resolveJump(): we MUST fall down with a jump!");
            return this.prepareJump(true);
        }
        if (jumpIndicated) {
            this.debug("resolveJump(): we should jump");
            return this.prepareJump(false);
        }
        this.debug("resolveJump(): we do not need to jump, waiting to reach the right spot to jump from");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    private boolean prepareJump(boolean jumpForced) {
        this.debug("prepareJump(): called");
        Location direction = Location.sub((Location)this.firstLocation, (Location)this.memory.getLocation()).setZ(0.0);
        direction = direction.getNormalized();
        Location velocityDir = new Location((Tuple3d)this.memory.getVelocity().asVector3d()).setZ(0.0);
        velocityDir = velocityDir.getNormalized();
        Double jumpAngleDeviation = Math.acos(direction.dot(velocityDir));
        boolean angleSuitable = !jumpAngleDeviation.isNaN() && jumpAngleDeviation < 0.3490658503988659;
        this.debug("prepareJump(): jumpAngleDeviation = " + jumpAngleDeviation);
        this.debug("prepareJump(): angleSuitable      = " + angleSuitable);
        if (jumpForced) {
            this.debug("prepareJump(): jump is forced, bypassing jump checks!");
        } else {
            this.debug("prepareJump(): jump is not forced, checking jump conditions");
            if (this.velocity < 200.0 && this.distance2D > this.getMaxJumpDistance(true, 0.39, 755.0, this.distanceZ, this.velocity)) {
                this.debug("prepareJump(): velocity is too low for jump (velocity < 200) and target is too far away to jump there with double jump");
                this.debug("prepareJump(): proceeding with the straight movement to gain speed");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
            if (!angleSuitable) {
                this.debug("prepareJump(): angle is not suitable for jumping (angle > 20 degrees)");
                this.debug("prepareJump(): proceeding with the straight movement to gain speed");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
            this.debug("prepareJump(): velocity & angle is OK!");
        }
        if (this.distanceZ >= 0.0) {
            this.debug("prepareJump(): JUMP (distanceZ >= 0)");
            return this.initJump(jumpForced);
        }
        this.debug("prepareFall(): FALL (distanceZ < 0)");
        return this.initFall(jumpForced);
    }

    private double adjustJumpForce(double distanceSafeZone, boolean doubleJump, double jumpForce, double jumpDelay) {
        double distanceJumped = this.getJumpUpDistance(doubleJump, jumpDelay, jumpForce, this.distanceZ, this.velocity);
        this.debug("initJump(): adjusting jumpForce...");
        while (distanceJumped - distanceSafeZone < this.distance2D && (doubleJump && jumpForce < 755.0 || !doubleJump && jumpForce < 340.0)) {
            distanceJumped = this.getJumpUpDistance(doubleJump, jumpDelay, jumpForce += 10.0, this.distanceZ, this.velocity);
        }
        jumpForce = doubleJump ? Math.min(jumpForce, 755.0) : Math.min(jumpForce, 340.0);
        this.debug("initJump(): jumpForce = " + jumpForce);
        return jumpForce;
    }

    private boolean initJump(boolean jumpForced) {
        this.debug("initJump(): called");
        boolean shouldJump = true;
        boolean doubleJump = true;
        double jumpForce = 755.0;
        double jumpDelay = 0.39;
        if (this.distanceZ > 130.0) {
            this.debug("initJump(): jump could not be made (distanceZ = " + this.distanceZ + " > 130)");
            if (jumpForced) {
                this.debug("initJump(): but jump is being forced!");
            } else {
                this.debug("initJump(): jump is not forced ... we will wait till the bot reach the right jumping spot");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                this.jumpStep = 0;
                return true;
            }
        }
        if (this.collisionNum == 0 && this.distanceZ < 55.0 && this.distance2D < this.velocity * 0.85 && (this.link == null || this.link.getNeededJump() == null || this.link.getNeededJump().getZ() <= 340.0)) {
            this.debug("initJump(): single jump suffices (distanceZ < 55 && distance2D = " + this.distance2D + " < " + this.velocity * 0.85 + " = velocity * 0.85) && (link.getNeededJump == null ||  link.getNeededJump().getZ() <= UnrealUtils.FULL_JUMP_FORCE ))");
            doubleJump = false;
            jumpForce = 340.0;
        }
        double jumpUp_force = 0.0;
        if (doubleJump) {
            jumpUp_force = this.collisionNum != 0 ? 755.0 : 755.0 * ((this.distanceZ + 5.0) / 110.0);
            jumpUp_force = Math.min(jumpUp_force, 755.0);
        } else {
            jumpUp_force = 340.0 * ((this.distanceZ + 5.0) / 55.0);
            jumpUp_force = Math.min(jumpUp_force, 340.0);
        }
        this.debug("initJump(): minimum force to jump to height " + this.distanceZ + " with " + (doubleJump ? "double" : "single") + " is " + jumpUp_force);
        double distanceSafeZone = 0.0;
        this.debug("initJump(): adjusting force to match jumping distance = " + this.distance2D + " = distance2D (safe zone = " + distanceSafeZone + ")");
        jumpForce = this.adjustJumpForce(distanceSafeZone, doubleJump, jumpUp_force, jumpDelay);
        double distanceJumped = this.getJumpUpDistance(doubleJump, jumpDelay, jumpForce, this.distanceZ, this.velocity);
        if (distanceJumped - distanceSafeZone < this.distance2D) {
            this.debug("initJump(): too short! (distanceJumped-" + distanceSafeZone + " = " + (distanceJumped - distanceSafeZone) + " < " + this.distance2D + " = distance2D)");
            if (!doubleJump) {
                this.debug("initJump(): trying double jump");
                doubleJump = true;
                jumpUp_force = 755.0 * ((this.distanceZ + 5.0) / 125.0);
                jumpUp_force = Math.min(jumpUp_force, 755.0);
                this.debug("initJump(): minimum force to jump to height " + this.distanceZ + " with double jump is " + jumpUp_force);
                this.debug("initJump(): adjusting force to match jumping distance = " + this.distance2D + " = distance2D (safe zone = " + distanceSafeZone + ")");
                jumpForce = this.adjustJumpForce(distanceSafeZone, doubleJump, jumpUp_force, jumpDelay);
                distanceJumped = this.getMaxJumpDistance(doubleJump, jumpDelay, jumpForce, this.distanceZ, this.velocity);
                if (distanceJumped - distanceSafeZone < this.distance2D) {
                    this.debug("initJump(): still too short! (distanceJumped-" + distanceSafeZone + " = " + (distanceJumped - distanceSafeZone) + " < " + this.distance2D + " = distance2D)");
                    shouldJump = false;
                } else {
                    this.debug("initJump(): distance ok (distanceJumped-" + distanceSafeZone + " = " + (distanceJumped - distanceSafeZone) + " >= " + this.distance2D + " = distance2D)");
                    shouldJump = true;
                }
            } else {
                shouldJump = false;
            }
        } else {
            this.debug("initJump(): distance ok (distanceJumped-" + distanceSafeZone + " = " + (distanceJumped - distanceSafeZone) + " >= " + this.distance2D + " = distance2D)");
            shouldJump = true;
        }
        if (shouldJump || jumpForced) {
            if (jumpForced && !shouldJump) {
                this.debug("initJump(): we should not be jumping, but jump is FORCED!");
            }
            this.jumpStep = 1;
            return this.jump(true, jumpDelay, jumpForce);
        }
        this.debug("initJump(): jump is not forced ... we will wait till the bot reach the right jumping spot");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        this.jumpStep = 0;
        return true;
    }

    private boolean initFall(boolean jumpForced) {
        this.debug("initFall(): called");
        this.jumpStep = 1;
        this.log.finer("Runner.initDoubleJumpSequence(): FALLING DOWN! Adjusting parameters of the jump for falling...");
        double remainingDistance2D = this.distance2D - this.fallDistance;
        this.debug("initFall(): distance2D          = " + this.distance2D);
        this.debug("initFall(): falling will get us = " + this.fallDistance + " further");
        this.debug("initFall(): remainingDistance2D = " + remainingDistance2D);
        boolean doubleJump = true;
        double jumpZ = 705.0;
        if (remainingDistance2D < this.velocity) {
            this.debug("initFall(): single jump suffices (remainingDistance2D < velocity)");
            doubleJump = false;
            jumpZ = 340.0 * remainingDistance2D / 300.0;
        } else if (remainingDistance2D < 450.0) {
            this.log.finer("initFall(): smaller double jump is needed (remainingDistance2D < 450)");
            doubleJump = true;
            jumpZ = 340.0 + 365.0 * (remainingDistance2D - 220.0) * 150.0;
        } else {
            this.log.finer("Runner.initDoubleJumpSequence(): full double jump is needed (remainingDistance2D > 450)");
            doubleJump = true;
            jumpZ = 705.0;
        }
        return this.jump(doubleJump, 0.39, jumpZ);
    }

    private boolean jump(boolean doubleJump, double delay, double force) {
        if (doubleJump) {
            this.debug("DOUBLE JUMPING (delay = " + delay + ", force = " + force + ")");
        } else {
            this.debug("JUMPING (delay = " + delay + ", force = " + force + ")");
        }
        this.body.jump(doubleJump, delay, force);
        return true;
    }

    private void move(ILocated firstLocation, ILocated secondLocation, ILocated focus) {
        Move move = new Move();
        if (firstLocation != null) {
            Location currentLocation = this.memory.getLocation();
            move.setFirstLocation(firstLocation.getLocation());
            if (secondLocation == null || secondLocation.equals(firstLocation)) {
                move.setSecondLocation(firstLocation.getLocation());
            } else {
                double dist = firstLocation.getLocation().getDistance(secondLocation.getLocation());
                double quantifier = 1.0 + 200.0 / dist;
                Location extendedSecondLocation = firstLocation.getLocation().interpolate(secondLocation.getLocation(), quantifier);
                move.setSecondLocation(extendedSecondLocation);
            }
        } else if (secondLocation != null) {
            move.setSecondLocation(secondLocation.getLocation());
        }
        if (focus != null) {
            if (focus instanceof Player) {
                move.setFocusTarget((UnrealId)((IWorldObject)focus).getId());
            } else {
                move.setFocusLocation(focus.getLocation());
            }
        }
        this.log.finer("MOVING: " + (Object)((Object)move));
        this.bot.getAct().act((CommandMessage)move);
    }

    private boolean resolveCollision() {
        if (this.collisionSpot == null || this.memory.getLocation().getDistance2D(this.collisionSpot) > 120.0) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Runner.resolveCollision(): collision");
            }
            this.collisionSpot = this.memory.getLocation();
            this.collisionNum = 1;
            this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
            return true;
        }
        return this.initJump(true);
    }

    private boolean iterateJumpSequence() {
        this.debug("iterateJumpSequence(): called");
        switch (this.jumpStep) {
            case 1: {
                if (this.velocityZ > 100.0) {
                    this.debug("iterateJumpSequence(): jumping in progress (velocityZ > 100), increasing jumpStep");
                    ++this.jumpStep;
                }
                this.debug("iterateJumpSequence(): issuing move command to the target (just to be sure)");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
        }
        if (this.velocityZ <= 0.01) {
            this.debug("iterateJumpSequence(): jump ascension has ended (velocityZ < 0.01)");
            this.jumpStep = 0;
        }
        this.debug("iterateJumpSequence(): continuing movement to the target");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    protected boolean isColliding() {
        if (this.lastCollidingEvent == null) {
            return false;
        }
        this.debug("isColliding():(memory.getTime():" + this.memory.getTime() + " - (lastCollidingEvent.getSimTime() / 1000):" + this.lastCollidingEvent.getSimTime() / 1000L + " <= WALL_COLLISION_THRESHOLD:" + 1.0 + " )");
        if (this.memory.getTime() - (double)(this.lastCollidingEvent.getSimTime() / 1000L) <= 1.0) {
            this.debug("isColliding():return true;");
            return true;
        }
        return false;
    }

    public KefikRunner(UT2004Bot bot, AgentInfo agentInfo, AdvancedLocomotion locomotion, Logger log) {
        NullCheck.check((Object)bot, (String)"bot");
        this.bot = bot;
        NullCheck.check((Object)((Object)agentInfo), (String)"agentInfo");
        this.memory = agentInfo;
        NullCheck.check((Object)((Object)locomotion), (String)"locomotion");
        this.body = locomotion;
        bot.getWorldView().addEventListener(WallCollision.class, this.myCollisionsListener);
        this.log = log;
        if (this.log == null) {
            log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
    }
}

