/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathBuilder {
    private AgentInfo info;
    private IPathPlanner<ILocated> planner;
    private ILocated start;
    private List<ILocated> path = new ArrayList<ILocated>();
    private List<ItemOnPath> itemsOnPathSequence = new ArrayList<ItemOnPath>();
    private Set<Item> itemsOnPath = new HashSet<Item>();
    private TabooSet<Item> itemsOnPathTaboo;
    private ILocated end;
    private double pathLength;
    private LogCategory log;

    public PathBuilder(UT2004Bot bot, AgentInfo info, IPathPlanner<ILocated> pathPlanner) {
        this.info = info;
        this.log = bot.getLogger().getCategory("PathBuilder");
        this.planner = pathPlanner;
        this.itemsOnPathTaboo = new TabooSet(bot);
    }

    public LogCategory getLog() {
        return this.log;
    }

    public void newPath() {
        this.start = this.info.getLocation();
        if (this.info.getNearestNavPoint().getLocation().getDistance(this.start.getLocation()) < 50.0) {
            this.start = this.info.getNearestNavPoint();
        }
        this.end = null;
        this.pathLength = 0.0;
        this.path.clear();
        this.itemsOnPath.clear();
        this.itemsOnPathSequence.clear();
        this.itemsOnPathTaboo.clear();
        this.appendPoint(this.start);
        this.end = this.start;
    }

    public ILocated getStart() {
        return this.start;
    }

    public ILocated getEnd() {
        return this.end;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendPoint(ILocated point) {
        if (point == null) {
            return;
        }
        if (this.end != null && this.end.getLocation().getDistance(point.getLocation()) < 30.0) {
            return;
        }
        this.path.add(point);
        this.end = point;
        if (this.path.size() > 1) {
            this.pathLength += this.path.get(this.path.size() - 2).getLocation().getDistance(this.path.get(this.path.size() - 1).getLocation());
        }
        if (point instanceof NavPoint) {
            Item item;
            NavPoint np = (NavPoint)point;
            if (np.isInvSpot() && (item = np.getItemInstance()) == null) return;
        }
        if (!(point instanceof Item)) return;
        Item item = (Item)point;
        this.itemAddedIntoPath(item);
    }

    private void itemAddedIntoPath(Item item) {
        this.itemsOnPath.add(item);
        this.itemsOnPathTaboo.add(item);
        ItemOnPath curr = new ItemOnPath(item, this.path.size() - 1);
        if (this.itemsOnPathSequence.size() == 0) {
            this.itemsOnPathSequence.add(curr);
            curr.totalDistanceFromStart = this.getPathLength();
            return;
        }
        ItemOnPath previous = this.itemsOnPathSequence.get(this.itemsOnPathSequence.size() - 1);
        this.itemsOnPathSequence.add(curr);
        curr.previous = previous;
        previous.next = curr;
        double distance = 0.0;
        ILocated from = this.path.get(previous.pathIndex);
        for (int i = previous.pathIndex + 1; i <= curr.pathIndex; ++i) {
            ILocated next = this.path.get(i);
            distance += from.getLocation().getDistance(next.getLocation());
            from = next;
        }
        curr.previousDistance = distance;
        previous.nextDistance = distance;
        curr.totalDistanceFromStart = previous.totalDistanceFromStart + distance;
    }

    public List<ILocated> getPath() {
        return this.path;
    }

    public IPathFuture<ILocated> getPathFuture() {
        return new PrecomputedPathFuture((Object)this.start, (Object)this.end, this.getPath());
    }

    public double getPathLength() {
        return this.pathLength;
    }

    public Set<Item> getItemsOnPath() {
        return this.itemsOnPath;
    }

    public List<ItemOnPath> getItemsOnPathSequence() {
        return this.itemsOnPathSequence;
    }

    public TabooSet<Item> getItemsOnPathTaboo() {
        return this.itemsOnPathTaboo;
    }

    public boolean isItemOnPath(Item item) {
        return this.itemsOnPath.contains(item);
    }

    public boolean planTo(ILocated target) {
        IPathFuture path = this.planner.computePath((Object)this.end, (Object)target);
        if (path == null) {
            this.log.warning("NON-EXISTANT PATH: " + this.end + " -> " + target);
            return false;
        }
        return this.appendPath(path);
    }

    public boolean appendPath(IPathFuture pathFuture) {
        if (pathFuture == null) {
            this.log.warning("COULD NOT APPEND PATH ... pathFuture is NULL!");
            return false;
        }
        if (!pathFuture.isDone()) {
            this.log.warning("COULD NOT APPEND PATH ... pathFuture is not computed!");
            return false;
        }
        List path = pathFuture.get();
        return this.appendPath(path);
    }

    public boolean appendPath(List path) {
        if (path == null) {
            this.log.warning("COULD NOT APPEND PATH ... path is NULL!");
            return false;
        }
        for (Object o : path) {
            if (o == null) continue;
            if (o instanceof ILocated) {
                this.appendPoint((ILocated)o);
                continue;
            }
            if (o instanceof Location) {
                this.appendPoint((ILocated)((Location)o));
                continue;
            }
            this.log.warning("COULD NOT APPEND PATH ... there is incompatible point on the path: " + o);
        }
        return true;
    }

    public static class ItemOnPath {
        public final Item item;
        public final int pathIndex;
        public ItemOnPath previous = null;
        public double previousDistance = 0.0;
        public ItemOnPath next = null;
        public double nextDistance = 0.0;
        public double totalDistanceFromStart = 0.0;

        public ItemOnPath(Item item, int pathIndex) {
            this.item = item;
            this.pathIndex = pathIndex;
        }
    }
}

