/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.CollisionDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.JumpBoundaries;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.JumpModule;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WallCollision;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Tuple3d;

public class NavMeshRunner
implements IUT2004PathRunner {
    private UT2004Bot bot;
    private AgentInfo memory;
    private AdvancedLocomotion body;
    private Logger log;
    private JumpBoundaries jumpBoundaries;
    IWorldEventListener<WallCollision> myCollisionsListener = new IWorldEventListener<WallCollision>(){

        public void notify(WallCollision event) {
            NavMeshRunner.this.lastCollidingEvent = event;
        }
    };
    private JumpModule jumpModule;
    private CollisionDetector collisionDetector;
    private boolean inCollision = false;
    private String collisionReason = null;
    private int runnerStep = 0;
    private int jumpStep = 0;
    private int collisionNum = 0;
    private Location collisionSpot = null;
    private double distance;
    private double distance2D;
    private double distanceZ;
    private double velocity;
    private double velocityZ;
    private boolean jumpRequired;
    private String jumpReason;
    private Location runningFrom;
    private Location firstLocation;
    private Location secondLocation;
    private ILocated focus;
    private NavPointNeighbourLink link;
    private boolean forceNoJump;
    private double runDeviation2DDot;
    private double runAngle;
    private boolean accelerating = false;
    protected WallCollision lastCollidingEvent = null;
    private static final int WALL_COLLISION_THRESHOLD_MILLIS = 500;
    private static final int IDEAL_JUMP_RESERVE = 80;
    private double lastVelocityZ = 0.02;

    public NavMeshRunner(UT2004Bot bot, AgentInfo agentInfo, AdvancedLocomotion locomotion, Logger log, NavMesh navMesh) {
        NullCheck.check((Object)bot, (String)"bot");
        this.bot = bot;
        NullCheck.check((Object)((Object)agentInfo), (String)"agentInfo");
        this.memory = agentInfo;
        NullCheck.check((Object)((Object)locomotion), (String)"locomotion");
        this.body = locomotion;
        bot.getWorldView().addEventListener(WallCollision.class, this.myCollisionsListener);
        this.log = log;
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.jumpModule = new JumpModule(navMesh, this.log);
        this.collisionDetector = new CollisionDetector();
        this.reset();
    }

    @Override
    public void reset() {
        this.log.finer("RUNNER RESET");
        this.runnerStep = 0;
        this.jumpRequired = false;
        this.jumpBoundaries = null;
        this.jumpReason = null;
        this.jumpStep = 0;
        this.forceNoJump = false;
        this.collisionNum = 0;
        this.collisionSpot = null;
        this.lastCollidingEvent = null;
        this.inCollision = false;
        this.collisionReason = null;
        this.distance = 0.0;
        this.distance2D = 0.0;
        this.distanceZ = 0.0;
        this.velocity = 0.0;
        this.velocityZ = 0.0;
        this.runDeviation2DDot = 0.0;
        this.accelerating = false;
        this.lastVelocityZ = 0.0;
    }

    @Override
    public boolean runToLocation(Location runningFrom, Location firstLocation, Location secondLocation, ILocated focus, NavPointNeighbourLink navPointsLink, boolean reachable, boolean forceNoJump) {
        ++this.runnerStep;
        this.runningFrom = runningFrom;
        this.firstLocation = firstLocation;
        this.secondLocation = secondLocation;
        this.focus = focus;
        this.link = navPointsLink;
        this.forceNoJump = forceNoJump;
        this.distance = this.memory.getLocation().getDistance(firstLocation);
        this.distance2D = this.memory.getLocation().getDistance2D(firstLocation);
        this.distanceZ = firstLocation.getDistanceZ(this.memory.getLocation());
        double newVelocity = this.memory.getVelocity().size();
        this.accelerating = this.isAccelerating(newVelocity, this.velocity);
        this.velocity = newVelocity;
        this.velocityZ = this.memory.getVelocity().z;
        Location direction = Location.sub((Location)firstLocation, (Location)this.memory.getLocation()).setZ(0.0);
        direction = direction.getNormalized();
        Location velocityDir = new Location((Tuple3d)this.memory.getVelocity().asVector3d()).setZ(0.0);
        velocityDir = velocityDir.getNormalized();
        this.runDeviation2DDot = direction.dot(velocityDir);
        this.runAngle = Math.atan2(this.distanceZ, this.distance2D);
        if (this.jumpBoundaries == null || this.jumpBoundaries.getLink() != this.link) {
            this.jumpBoundaries = this.jumpModule.computeJumpBoundaries(this.link);
        }
        this.checkJump();
        this.checkCollision();
        this.logIteration();
        if (this.runnerStep <= 1) {
            this.debug("FIRST STEP - Start running towards new location");
            this.move((ILocated)firstLocation, (ILocated)secondLocation, focus);
            return true;
        }
        if (this.jumpStep > 0) {
            this.debug("We're already jumping" + (this.collisionSpot != null ? " [COLLISION]" : ""));
            return this.iterateJumpSequence();
        }
        if (this.inCollision) {
            if (!forceNoJump) {
                return this.resolveCollision();
            }
        } else if (this.collisionSpot != null || this.collisionNum != 0) {
            this.debug("Collision waned...");
            this.collisionNum = 0;
            this.collisionSpot = null;
        }
        if (this.velocity < 5.0 && this.runnerStep > 5) {
            this.debug("Velocity is (almost) zero and we're in the middle of running...");
            if (forceNoJump) {
                this.debug("But we will not jump as forceNoJump == true ...");
            } else {
                this.debug("So we're going to jump...");
                return this.initJump(true, true);
            }
        }
        if (this.jumpRequired && !forceNoJump) {
            return this.decideJump();
        }
        this.debug("Keeping running to the target");
        this.move((ILocated)firstLocation, (ILocated)secondLocation, focus);
        return true;
    }

    private boolean checkJump() {
        if (this.jumpStep > 0) {
            return true;
        }
        if (this.jumpModule.needsJump(this.link)) {
            this.jumpRequired = true;
            this.jumpReason = "LINK[";
            boolean first = true;
            if ((this.link.getFlags() & LinkFlag.JUMP.get()) != 0) {
                first = false;
                this.jumpReason = String.valueOf(this.jumpReason) + "JUMP-FLAG";
            }
            if (this.link.isForceDoubleJump()) {
                if (!first) {
                    this.jumpReason = String.valueOf(this.jumpReason) + "|";
                }
                this.jumpReason = String.valueOf(this.jumpReason) + "DOUBLE-JUMP";
            }
            if (this.link.getNeededJump() != null) {
                if (!first) {
                    this.jumpReason = String.valueOf(this.jumpReason) + "|";
                }
                int jumpDistance = (int)this.memory.getLocation().getDistance(new Location((Tuple3d)this.link.getNeededJump()));
                this.jumpReason = String.valueOf(this.jumpReason) + "DIST:" + jumpDistance;
            }
            this.jumpReason = String.valueOf(this.jumpReason) + "]";
        } else {
            this.jumpRequired = false;
            this.jumpReason = null;
        }
        return this.jumpRequired;
    }

    private boolean checkCollision() {
        if (this.collisionDetector.isColliding(this.memory.getLocation(), this.velocity, this.distance)) {
            this.inCollision = true;
            this.collisionReason = "COLLISION DETECTED";
            return true;
        }
        if (this.lastCollidingEvent == null) {
            this.inCollision = false;
            this.collisionReason = null;
            return false;
        }
        int collisionTimeMillis = (int)(this.memory.getTime() * 1000.0 - (double)this.lastCollidingEvent.getSimTime());
        if (collisionTimeMillis <= 500) {
            this.inCollision = true;
            this.collisionReason = "WALL-EVENT[before " + collisionTimeMillis + "ms]";
            return true;
        }
        this.inCollision = false;
        this.collisionReason = null;
        return false;
    }

    private void logIteration() {
        double d2;
        Location curr = this.memory.getLocation();
        double d1 = this.firstLocation == null ? -1.0 : curr.getDistance(this.firstLocation);
        double d = d2 = this.firstLocation != null && this.secondLocation == null ? 0.0 : this.firstLocation.getDistance(this.secondLocation);
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.debug("RUNNER STEP " + this.runnerStep);
            this.debug("running     " + this.memory.getLocation() + " --(D3D:" + (int)d1 + "|D2D:" + (int)this.distance2D + "|DZ:" + (int)this.distanceZ + ")--> " + this.firstLocation + (this.secondLocation == null ? "" : " --(D3D:" + (int)d2 + ")--> " + this.secondLocation) + (this.focus == null ? "" : ", focusing to " + this.focus));
            this.debug("velocity    " + (int)this.velocity + " (z:" + (int)this.velocityZ + ")");
            this.debug("deviation2D " + (int)(Math.acos(this.runDeviation2DDot) * 180.0 / Math.PI));
            this.debug("runAngle    " + (int)(this.runAngle / Math.PI * 180.0) + " degrees");
            if (this.jumpRequired) {
                this.debug("jump        " + this.jumpReason);
            }
            if (this.inCollision) {
                this.debug("collision   " + this.collisionReason);
            }
            if (this.jumpBoundaries.getLink() != null) {
                this.debug("jump-bounds " + (this.jumpBoundaries.isJumpable() ? "POSSIBLE" : "IMPOSSIBLE") + " X-" + this.jumpBoundaries.getTakeOffMin() + "<--(" + (this.jumpBoundaries.getTakeOffMin() != null && this.jumpBoundaries.getTakeOffMax() != null ? Integer.valueOf((int)this.jumpBoundaries.getTakeOffMin().getDistance(this.jumpBoundaries.getTakeOffMax())) : "???") + ")-->" + this.jumpBoundaries.getTakeOffMax() + "-X--->" + this.jumpBoundaries.getLandingTarget());
            }
            if ((this.jumpRequired || this.inCollision) && this.forceNoJump) {
                this.debug("jump forbidden [force-no-jump]");
            }
        }
    }

    private void move(ILocated firstLocation, ILocated secondLocation, ILocated focus) {
        Move move = new Move();
        if (firstLocation != null) {
            move.setFirstLocation(firstLocation.getLocation());
            if (secondLocation == null || secondLocation.equals(firstLocation)) {
                move.setSecondLocation(firstLocation.getLocation());
            } else {
                double dist = firstLocation.getLocation().getDistance(secondLocation.getLocation());
                if (dist < 50.0) {
                    double quantifier = 1.0 + 200.0 / dist;
                    Location extendedSecondLocation = firstLocation.getLocation().interpolate(secondLocation.getLocation(), quantifier);
                    move.setSecondLocation(extendedSecondLocation);
                } else {
                    move.setSecondLocation(secondLocation.getLocation());
                }
            }
        } else if (secondLocation != null) {
            move.setSecondLocation(secondLocation.getLocation());
        }
        if (focus != null) {
            if (focus instanceof Player) {
                move.setFocusTarget((UnrealId)((IWorldObject)focus).getId());
            } else {
                move.setFocusLocation(focus.getLocation());
            }
        }
        this.debug(move.toString());
        this.bot.getAct().act((CommandMessage)move);
    }

    private boolean resolveCollision() {
        if (this.collisionSpot == null || this.memory.getLocation().getDistance2D(this.collisionSpot) > 120.0) {
            this.collisionSpot = this.memory.getLocation();
            this.collisionNum = 1;
            this.debug("COLLISION[" + this.collisionNum + "] => just moving...");
            this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
            return true;
        }
        if (this.collisionNum > 8) {
            this.debug("COLLISION[" + this.collisionNum + "] => JUMPING");
            return this.initJump(true, true);
        }
        ++this.collisionNum;
        this.debug("COLLISION[" + this.collisionNum + "] => just moving...");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    private boolean decideJump() {
        this.debug("decideJump(): called");
        int jumpDistance2D = (int)this.distance2D;
        this.debug("  ", "jumpDistance2D = " + jumpDistance2D);
        boolean jumpIndicated = false;
        boolean jumpForced = this.inCollision;
        boolean doubleJumpRequired = false;
        if (this.jumpModule.needsJump(this.link)) {
            this.debug("  ", "JumpModule is indicating jump");
            jumpIndicated = true;
        } else {
            this.debug("  ", "JumpModule is silent");
        }
        if (!this.jumpBoundaries.isJumpable()) {
            if (this.runnerStep > 1 && this.velocity > 389.5 && this.runDeviation2DDot < 20.0 && jumpDistance2D < 500 || jumpDistance2D < 250) {
                this.debug("  ", "jump-bounds impossible and we're heuristically in good position for jump => forcing double jump");
                jumpForced = true;
                doubleJumpRequired = true;
            } else {
                this.debug("  ", "jump-bounds indicating impossible jump => requiring double jump");
                doubleJumpRequired = true;
            }
        }
        if (!doubleJumpRequired && this.runnerStep > 1 && this.runAngle < -0.5235987755982988) {
            this.debug("  ", "we have to JUMP DOWN - indicating jump");
            jumpIndicated = true;
        }
        if (jumpIndicated || jumpForced) {
            return this.prepareJump(jumpForced, doubleJumpRequired);
        }
        this.debug("  ", "we do not need to jump right now, waiting to reach the right spot to jump from");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    private boolean prepareJump(boolean jumpForced, boolean doubleJumpRequired) {
        this.debug("prepareJump(): called");
        double jumpVelocity = this.jumpModule.getCorrectedVelocity(this.velocity, this.accelerating);
        Double jumpAngleDeviation = Math.acos(this.jumpModule.getCorrectedAngle(this.runDeviation2DDot, this.runnerStep <= 1));
        boolean angleSuitable = !jumpAngleDeviation.isNaN() && jumpAngleDeviation < 0.3490658503988659;
        this.debug("  ", "jumpVelocity       " + (int)jumpVelocity);
        this.debug("  ", "jumpAngleDeviation " + (int)(jumpAngleDeviation * 180.0 / Math.PI) + " degress");
        this.debug("  ", "angleSuitable      " + angleSuitable);
        if (!jumpForced && this.runnerStep > 1 && this.jumpBoundaries.isPastBoundaries(this.memory.getLocation())) {
            this.debug("  ", "past jump-bounds => forcing the jump");
            jumpForced = true;
        }
        if (!jumpForced && jumpAngleDeviation > 1.0471975511965976) {
            this.debug("  ", "impossible jump angle, postponing the jump...");
            this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
            return true;
        }
        if (jumpForced) {
            this.debug("  ", "jump is forced, bypassing jump checks");
        } else {
            this.debug("  ", "jump is not forced and we are within jump-bounds, checking jump conditions");
            if (!this.jumpModule.isJumpable(this.memory.getLocation(), this.jumpBoundaries.getLandingTarget(), jumpVelocity)) {
                this.debug("  ", "not jumpable! Start: " + this.memory.getLocation() + " Target: " + this.jumpBoundaries.getLandingTarget() + " Velocity: " + this.velocity + " Jump Velocity: " + jumpVelocity);
                this.debug("  ", "proceeding with the straight movement to gain speed");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
            if (!angleSuitable) {
                this.debug("  ", "angle is not suitable for jumping (angle > 20 degrees)");
                this.debug("  ", "proceeding with the straight movement to gain speed");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
            if (this.jumpBoundaries.isJumpable() && this.jumpBoundaries.getTakeOffMax().getDistance2D(this.memory.getLocation()) > 80.0) {
                boolean angleIdeal;
                boolean bl = angleIdeal = !jumpAngleDeviation.isNaN() && jumpAngleDeviation < Math.PI / 90;
                if (!angleIdeal) {
                    this.debug("  ", "proceeding with the straight movement - waiting for IDEAL JUMP ANGLE");
                    this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                    return true;
                }
                if (this.velocity < 389.5) {
                    this.debug("  ", "proceeding with the straight movement - waiting for IDEAL SPEED");
                    this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                    return true;
                }
            }
            this.debug("  ", "passed ideal reserve spot, forcing the jump");
            jumpForced = true;
        }
        return this.initJump(jumpForced, doubleJumpRequired);
    }

    private boolean initJump(boolean jumpForced, boolean maxJumpRequired) {
        this.debug("initJump(): called");
        Boolean doubleJump = null;
        Double jumpForce = Double.NaN;
        Double jumpVelocity = this.jumpModule.getCorrectedVelocity(this.velocity, this.accelerating);
        Double jumpAngleCos = this.jumpModule.getCorrectedAngle(this.runDeviation2DDot, this.runnerStep <= 1);
        if (jumpForced) {
            this.debug("  ", "Jump is forced!");
            if (this.inCollision) {
                this.debug("  ", "In collision, forcing MAX DOUBLE jump!");
                this.inCollision = false;
                this.jumpStep = 1;
                return this.jump(true, 0.39, 755.0);
            }
            if (maxJumpRequired) {
                this.debug("  ", "Forced MAX DOUBLE jump!");
                this.jumpStep = 1;
                return this.jump(true, 0.39, 755.0);
            }
            if (this.runAngle < 0.0 && this.distanceZ < -50.0) {
                this.debug("  ", "We are going to fall down, runAngle = " + (int)(this.runAngle / Math.PI * 180.0) + " < 0, distaceZ = " + (int)this.distanceZ + " < -50");
                try {
                    jumpForce = Math.abs(this.jumpModule.computeFall(this.memory.getLocation(), this.jumpBoundaries, jumpVelocity, jumpAngleCos));
                    if (jumpForce < 110.0) {
                        jumpForce = 110.0;
                    }
                }
                catch (Exception e) {
                    this.debug("  ", "Failed to compute fall-jump force, setting 110.");
                    jumpForce = 110.0;
                }
            } else {
                this.debug("  ", "We have to jump normally, computing ideal jump force.");
                try {
                    jumpForce = Math.abs(this.jumpModule.computeJump(this.memory.getLocation(), this.jumpBoundaries, jumpVelocity, jumpAngleCos));
                }
                catch (Exception e) {
                    jumpForce = Double.NaN;
                }
            }
            if (jumpForce == Double.NaN) {
                this.debug("  ", "Could not compute jump force (NaN) => forcing MAX DOUBLE jump!");
                jumpForce = 755.0;
            }
            doubleJump = jumpForce > 340.0;
            this.jumpStep = 1;
            return this.jump(doubleJump, 0.39, jumpForce);
        }
        if (!this.jumpBoundaries.isJumpable()) {
            this.debug("  ", "Jump boundaries not present! We shouldn't be trying to JUMP!");
            jumpForce = Double.NaN;
        } else if (!this.jumpBoundaries.isInBoundaries(this.memory.getLocation())) {
            if (this.runnerStep > 1 && this.jumpBoundaries.isPastBoundaries(this.memory.getLocation())) {
                this.debug("  ", "Already passed max take-off point, forcing jump!");
                jumpForced = true;
                jumpForce = this.jumpModule.computeJump(this.memory.getLocation(), this.jumpBoundaries, jumpVelocity, jumpAngleCos);
            } else {
                this.debug("  ", "Not within jump boundaries! We shouldn't JUMP");
                jumpForce = Double.NaN;
            }
        } else {
            jumpForce = this.jumpModule.computeJump(this.memory.getLocation(), this.jumpBoundaries, jumpVelocity, jumpAngleCos);
            if (jumpForce < 340.0) {
                doubleJump = false;
            }
        }
        if (jumpForce.isNaN()) {
            if (jumpForced) {
                if (!this.accelerating) {
                    this.debug("  ", "Forcing jump but NOT accelerating, postpone!");
                    this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                    return true;
                }
                this.jumpStep = 1;
                this.debug("  ", "Forcing jump - MAX!");
                return this.jump(true, 0.39, 755.0);
            }
            this.debug("  ", "Jump failed to compute, continuing with move! Computed force: " + jumpForce);
            this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
            return true;
        }
        if (jumpForce < 0.0) {
            this.debug("  ", "We don't need to jump, continuing with move! Computed force: " + jumpForce);
            if (this.jumpBoundaries.isJumpable() && this.jumpBoundaries.getTakeoffEdgeDirection() != null) {
                Location movementDirection = this.jumpBoundaries.getLandingTarget().sub(this.jumpBoundaries.getTakeOffMax()).setZ(0.0).getNormalized();
                Location meshDirection = this.jumpBoundaries.getTakeoffEdgeDirection();
                double fallAngleCos = meshDirection.setZ(0.0).getNormalized().dot(movementDirection);
                double takeOffDistance = this.jumpBoundaries.getLandingTarget().getDistance2D(this.jumpBoundaries.getTakeOffMax());
                if (Math.abs(fallAngleCos) > Math.cos(1.2566370614359172)) {
                    this.debug("  ", "Not direct approach to fall, we should jump a little. Angle: " + Math.acos(fallAngleCos) * 57.29577951308232);
                    this.jumpBoundaries.setLandingTarget(this.jumpBoundaries.getTakeOffMax().interpolate(this.jumpBoundaries.getLandingTarget(), 80.0 / takeOffDistance).setZ(this.jumpBoundaries.getTakeOffMax().z));
                    return true;
                }
                this.debug("  ", "Fall solved by not jumping, as angle is suitable. AngleCos: " + fallAngleCos);
                this.jumpStep = 1;
                return true;
            }
            this.debug("  ", "Fall solved by not jumping, as angle is suitable. Boundaries not jumpable.");
            this.jumpStep = 1;
            return true;
        }
        this.jumpStep = 1;
        return this.jump(doubleJump, 0.39, jumpForce);
    }

    private boolean jump(boolean doubleJump, double delay, double force) {
        if (doubleJump) {
            this.debug("DOUBLE-JUMPING[delay=" + delay + ", force=" + force + "]");
        } else {
            this.debug("JUMPING[force=" + force + "]");
        }
        this.body.jump(doubleJump, delay, force);
        return true;
    }

    private boolean iterateJumpSequence() {
        this.debug("iterateJumpSequence(): called");
        switch (this.jumpStep) {
            case 1: {
                if (this.velocityZ > 100.0) {
                    this.debug("iterateJumpSequence(): jumping in progress (velocityZ > 100), increasing jumpStep");
                    ++this.jumpStep;
                }
                this.debug("iterateJumpSequence(): issuing move command to the target (just to be sure)");
                this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
                return true;
            }
        }
        ++this.jumpStep;
        if (this.velocityZ <= 0.01) {
            if (this.velocityZ > this.lastVelocityZ) {
                this.debug("iterateJumpSequence(): jump has ended");
                this.lastVelocityZ = 0.02;
                this.jumpStep = 0;
            } else {
                this.lastVelocityZ = this.velocityZ;
            }
        }
        this.debug("iterateJumpSequence(): continuing movement to the target");
        this.move((ILocated)this.firstLocation, (ILocated)this.secondLocation, this.focus);
        return true;
    }

    private boolean isMaxVelocity(double newVelocity) {
        return Math.abs(newVelocity - 439.5) < 5.0;
    }

    private boolean isAccelerating(double newVelocity, double oldVelocity) {
        return this.velocity > 0.0 && (this.isMaxVelocity(newVelocity) || newVelocity > oldVelocity);
    }

    private void debug(String message) {
        this.debug("", message);
    }

    private void debug(String prefix, String message) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, String.valueOf(prefix) + "  +-- {0}", message);
        }
    }
}

