/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import java.awt.Color;
import java.util.logging.Logger;

public class UT2004Draw {
    protected Logger log;
    protected IUT2004ServerProvider serverProvider;
    protected Color defaultColor = Color.WHITE;
    protected Location origin = new Location(0.0, 0.0, 0.0);
    protected double scale = 1.0;

    public UT2004Draw(Logger log, IUT2004ServerProvider serverProvider) {
        this.log = log;
        if (log == null) {
            log = new LogCategory("Draw");
        }
        this.serverProvider = serverProvider;
    }

    protected UT2004Server getServer() {
        return this.serverProvider.getServer();
    }

    public void init() {
        this.serverProvider.getServer();
    }

    public Location getOrigin() {
        return this.origin;
    }

    public void setOrigin(Location location) {
        this.origin = location;
        if (this.origin == null) {
            this.origin = new Location(0.0, 0.0, 0.0);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public Color getColor() {
        return this.defaultColor;
    }

    public void setColor(Color color) {
        this.defaultColor = color;
        if (this.defaultColor == null) {
            this.defaultColor = Color.WHITE;
        }
    }

    public void drawLine(ILocated from, ILocated to) {
        if (from == null || to == null) {
            return;
        }
        this.drawLine(from.getLocation(), to.getLocation());
    }

    public void drawLine(Color color, ILocated from, ILocated to) {
        if (from == null || to == null) {
            return;
        }
        this.drawLine(color, from.getLocation(), to.getLocation());
    }

    public void drawPolyLine(ILocated ... points) {
        if (points == null) {
            return;
        }
        Location[] locations = new Location[points.length];
        int i = 0;
        while (i < points.length) {
            if (points[i] == null) {
                return;
            }
            locations[i] = points[i].getLocation();
            ++i;
        }
        this.drawPolyLine(locations);
    }

    public void drawPolyLine(Color color, ILocated ... vertices) {
        if (vertices == null) {
            return;
        }
        Location[] locations = new Location[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            if (vertices[i] == null) {
                return;
            }
            locations[i] = vertices[i].getLocation();
            ++i;
        }
        this.drawPolyLine(color, locations);
    }

    public void drawPolygon(ILocated ... vertices) {
        if (vertices == null) {
            return;
        }
        Location[] locations = new Location[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            if (vertices[i] == null) {
                return;
            }
            locations[i] = vertices[i].getLocation();
            ++i;
        }
        this.drawPolygon(locations);
    }

    public void drawPolygon(Color color, ILocated ... vertices) {
        if (vertices == null) {
            return;
        }
        Location[] locations = new Location[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            if (vertices[i] == null) {
                return;
            }
            locations[i] = vertices[i].getLocation();
            ++i;
        }
        this.drawPolygon(color, locations);
    }

    public void drawCube(Color color, ILocated location, double size) {
        this.drawCube(color, location.getLocation(), size);
    }

    public void drawLine(Location from, Location to) {
        this.drawLine(this.defaultColor, from, to);
    }

    public void drawLine(Color color, Location from, Location to) {
        if (color == null || from == null || to == null) {
            return;
        }
        this.init();
        DrawStayingDebugLines cmd = this.newDrawCommand(color);
        cmd.setVectors(this.getDrawVectors(from, to));
        this.getServer().getAct().act((CommandMessage)cmd);
    }

    public void drawPolyLine(Location ... points) {
        this.drawPolyLine(this.defaultColor, points);
    }

    public void drawPolyLine(Color color, Location ... vertices) {
        if (color == null || vertices == null || vertices.length < 2) {
            return;
        }
        int i = 1;
        while (i < vertices.length) {
            Location v1 = vertices[i - 1];
            Location v2 = vertices[i];
            this.drawLine(this.defaultColor, v1, v2);
            ++i;
        }
    }

    public void drawPolygon(Location ... vertices) {
        this.drawPolygon(this.defaultColor, vertices);
    }

    public void drawPolygon(Color color, Location ... vertices) {
        if (color == null || vertices == null || vertices.length < 3) {
            return;
        }
        this.init();
        DrawStayingDebugLines cmd = this.newDrawCommand(color);
        cmd.setVectors(this.getDrawPolygon(vertices));
        this.getServer().getAct().act((CommandMessage)cmd);
    }

    public void drawCube(Color color, Location location, double size) {
        Location v1 = null;
        Location v2 = null;
        Location v3 = null;
        Location v4 = null;
        double minX = location.x - size / 2.0;
        double maxX = location.x + size / 2.0;
        double minY = location.y - size / 2.0;
        double maxY = location.y + size / 2.0;
        double minZ = location.z - size / 2.0;
        double maxZ = location.z + size / 2.0;
        v1 = new Location(minX, minY, minZ);
        v2 = new Location(minX, maxY, minZ);
        v3 = new Location(minX, maxY, maxZ);
        v4 = new Location(minX, minY, maxZ);
        this.drawPolygon(color, v1, v2, v3, v4);
        v1 = new Location(maxX, minY, minZ);
        v2 = new Location(maxX, maxY, minZ);
        v3 = new Location(maxX, maxY, maxZ);
        v4 = new Location(maxX, minY, maxZ);
        this.drawPolygon(color, v1, v2, v3, v4);
        v1 = new Location(minX, minY, minZ);
        v2 = new Location(maxX, minY, minZ);
        this.drawLine(color, v1, v2);
        v1 = new Location(minX, maxY, minZ);
        v2 = new Location(maxX, maxY, minZ);
        this.drawLine(color, v1, v2);
        v1 = new Location(minX, maxY, maxZ);
        v2 = new Location(maxX, maxY, maxZ);
        this.drawLine(color, v1, v2);
        v1 = new Location(minX, minY, maxZ);
        v2 = new Location(maxX, minY, maxZ);
        this.drawLine(color, v1, v2);
    }

    public void drawLine(double[] from, double[] to) {
        this.drawLine(this.defaultColor, from, to);
    }

    public void drawLine(Color color, double[] from, double[] to) {
        if (color == null || from == null || to == null) {
            return;
        }
        this.init();
        DrawStayingDebugLines cmd = this.newDrawCommand(color);
        cmd.setVectors(this.getDrawVectors(from, to));
        this.getServer().getAct().act((CommandMessage)cmd);
    }

    public void drawPolyLine(double[] ... points) {
        this.drawPolyLine(this.defaultColor, points);
    }

    public void drawPolyLine(Color color, double[] ... vertices) {
        if (color == null || vertices == null || vertices.length < 2) {
            return;
        }
        int i = 1;
        while (i < vertices.length) {
            double[] v1 = vertices[i - 1];
            double[] v2 = vertices[i];
            this.drawLine(this.defaultColor, v1, v2);
            ++i;
        }
    }

    public void drawPolygon(double[] ... vertices) {
        this.drawPolygon(this.defaultColor, vertices);
    }

    public void drawPolygon(Color color, double[] ... vertices) {
        if (color == null || vertices == null || vertices.length < 3) {
            return;
        }
        this.init();
        DrawStayingDebugLines cmd = this.newDrawCommand(color);
        cmd.setVectors(this.getDrawPolygon(vertices));
        this.getServer().getAct().act((CommandMessage)cmd);
    }

    public void clearAll() {
        this.init();
        DrawStayingDebugLines cmd = new DrawStayingDebugLines();
        cmd.setClearAll(true);
        this.getServer().getAct().act((CommandMessage)cmd);
    }

    private Location adjustLocation(Location location) {
        return location.scale(this.scale).add(this.origin);
    }

    private String getDrawVector(Location point) {
        if (point == null) {
            return "";
        }
        point = this.adjustLocation(point);
        int x = (int)Math.round(point.x);
        int y = (int)Math.round(point.y);
        int z = (int)Math.round(point.z);
        return String.valueOf(x) + "," + y + "," + z;
    }

    private void writeDrawVector(StringBuffer sb, Location point) {
        if (point == null) {
            return;
        }
        point = this.adjustLocation(point);
        int x = (int)Math.round(point.x);
        int y = (int)Math.round(point.y);
        int z = (int)Math.round(point.z);
        sb.append(x);
        sb.append(",");
        sb.append(y);
        sb.append(",");
        sb.append(z);
    }

    private String getDrawVectors(Location ... points) {
        if (points == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Location[] locationArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Location point = locationArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            ++n2;
        }
        return sb.toString();
    }

    private String getDrawPolyLine(Location ... points) {
        if (points == null || points.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Location point = points[0];
        int i = 1;
        while (i < points.length) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            sb.append(";");
            this.writeDrawVector(sb, points[i]);
            point = points[i];
            ++i;
        }
        return sb.toString();
    }

    private String getDrawPolygon(Location ... points) {
        if (points == null || points.length < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Location point = points[0];
        int i = 1;
        while (i < points.length) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            sb.append(";");
            this.writeDrawVector(sb, points[i]);
            point = points[i];
            ++i;
        }
        sb.append(";");
        this.writeDrawVector(sb, points[points.length - 1]);
        sb.append(";");
        this.writeDrawVector(sb, points[0]);
        return sb.toString();
    }

    private double[] adjustLocation(double[] location) {
        double[] result = new double[]{location[0] * this.scale + this.origin.x, location[1] * this.scale + this.origin.y, location[2] * this.scale + this.origin.z};
        return result;
    }

    private String getDrawVector(double[] point) {
        if (point == null) {
            return "";
        }
        point = this.adjustLocation(point);
        int x = (int)Math.round(point[0]);
        int y = (int)Math.round(point[1]);
        int z = (int)Math.round(point[2]);
        return String.valueOf(x) + "," + y + "," + z;
    }

    private void writeDrawVector(StringBuffer sb, double[] point) {
        if (point == null) {
            return;
        }
        point = this.adjustLocation(point);
        int x = (int)Math.round(point[0]);
        int y = (int)Math.round(point[1]);
        int z = (int)Math.round(point[2]);
        sb.append(x);
        sb.append(",");
        sb.append(y);
        sb.append(",");
        sb.append(z);
    }

    private String getDrawVectors(double[] ... points) {
        if (points == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        double[][] dArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            double[] point = dArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            ++n2;
        }
        return sb.toString();
    }

    private String getDrawPolyLine(double[] ... points) {
        if (points == null || points.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        double[] point = points[0];
        int i = 1;
        while (i < points.length) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            sb.append(";");
            this.writeDrawVector(sb, points[i]);
            point = points[i];
            ++i;
        }
        return sb.toString();
    }

    private String getDrawPolygon(double[] ... points) {
        if (points == null || points.length < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        double[] point = points[0];
        int i = 1;
        while (i < points.length) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            sb.append(";");
            this.writeDrawVector(sb, points[i]);
            point = points[i];
            ++i;
        }
        sb.append(";");
        this.writeDrawVector(sb, points[points.length - 1]);
        sb.append(";");
        this.writeDrawVector(sb, points[0]);
        return sb.toString();
    }

    private DrawStayingDebugLines newDrawCommand() {
        return this.newDrawCommand(this.defaultColor);
    }

    private DrawStayingDebugLines newDrawCommand(Color color) {
        DrawStayingDebugLines cmd = new DrawStayingDebugLines();
        cmd.setColor(new Location((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue()));
        cmd.setClearAll(false);
        return cmd;
    }
}

