/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.BSPRayInfoContainer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometryBSPNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRayMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.ExceptionToString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.plane.Plane3D;

public class LevelGeometry
implements Serializable {
    private static final long serialVersionUID = -8146957816661176041L;
    private transient Logger log;
    private transient boolean loaded = false;
    public static Random random = new Random();
    public ArrayList<double[]> verts = new ArrayList();
    public ArrayList<int[]> triangles = new ArrayList();
    private LevelGeometryBSPNode bspTree;
    private LevelGeometryBSPNode biggestLeafInTree;
    public int leafCount = 0;
    public double minX = Double.POSITIVE_INFINITY;
    public double maxX = Double.NEGATIVE_INFINITY;
    public double minY = Double.POSITIVE_INFINITY;
    public double maxY = Double.NEGATIVE_INFINITY;
    public double minZ = Double.POSITIVE_INFINITY;
    public double maxZ = Double.NEGATIVE_INFINITY;

    public LevelGeometry(Logger log) {
        this.log = log;
        if (this.log == null) {
            this.log = new LogCategory("LevelGeometry");
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public LevelGeometryBSPNode getBSPRoot() {
        return this.bspTree;
    }

    public void clear() {
        this.loaded = false;
        this.verts = new ArrayList();
        this.triangles = new ArrayList();
        this.bspTree = null;
        this.biggestLeafInTree = null;
        this.leafCount = 0;
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.minZ = Double.POSITIVE_INFINITY;
        this.maxZ = Double.NEGATIVE_INFINITY;
    }

    public boolean load(String mapName) throws FileNotFoundException, IOException, Exception {
        if (this.loaded) {
            this.clear();
        }
        this.verts.add(new double[0]);
        String fileName = String.valueOf(NavMeshConstants.pureLevelGeometryReadDir) + "\\" + mapName + ".scale";
        File file = new File(fileName);
        if (!file.exists()) {
            this.log.warning("LevelGeometry .scale file does not exist at: " + file.getAbsolutePath());
            return false;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        double scale = Double.parseDouble(line);
        fileName = String.valueOf(NavMeshConstants.pureLevelGeometryReadDir) + "\\" + mapName + ".centre";
        file = new File(fileName);
        if (!file.exists()) {
            this.log.warning("LevelGeometry .centre file does not exist at: " + file.getAbsolutePath());
            return false;
        }
        br = new BufferedReader(new FileReader(file));
        line = br.readLine();
        String[] sc = line.split("[ \\t]");
        double[] centre = new double[3];
        int i = 0;
        while (i < 3) {
            centre[i] = Double.parseDouble(sc[i]);
            ++i;
        }
        fileName = String.valueOf(NavMeshConstants.pureLevelGeometryReadDir) + "\\" + mapName + ".obj";
        file = new File(fileName);
        if (!file.exists()) {
            this.log.warning("LevelGeometry .obj file does not exist at: " + file.getAbsolutePath());
            return false;
        }
        br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            String[] words = line.split("[ \\t]");
            if (words[0].equals("v")) {
                double[] v = new double[]{Double.parseDouble(words[1]) * scale + centre[0], Double.parseDouble(words[3]) * scale + centre[1], Double.parseDouble(words[2]) * scale + centre[2]};
                this.verts.add(v);
                if (v[0] < this.minX) {
                    this.minX = v[0];
                }
                if (v[0] > this.maxX) {
                    this.maxX = v[0];
                }
                if (v[1] < this.minY) {
                    this.minY = v[1];
                }
                if (v[1] > this.maxY) {
                    this.maxY = v[1];
                }
                if (v[2] < this.minZ) {
                    this.minZ = v[2];
                }
                if (v[2] > this.maxZ) {
                    this.maxZ = v[2];
                }
            }
            if (!words[0].equals("f")) continue;
            int[] t = new int[]{Integer.parseInt(words[1]), Integer.parseInt(words[2]), Integer.parseInt(words[3])};
            this.triangles.add(t);
        }
        this.resetBSPTree();
        this.loaded = true;
        return true;
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.log = new LogCategory("LevelGeometry");
        this.loaded = true;
    }

    private void resetBSPTree() throws Exception {
        this.log.info("Creating BSP tree...");
        this.bspTree = new LevelGeometryBSPNode(this, null, this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
        int i = 0;
        while (i < this.triangles.size()) {
            this.bspTree.triangles.add(i);
            ++i;
        }
        this.biggestLeafInTree = null;
        this.bspTree.build();
        this.log.info("BSP tree is done building.");
        this.log.info("Biggest leaf has " + this.biggestLeafInTree.triangles.size() + " triangles.");
        this.log.info("BSP tree has " + this.leafCount + " leaves");
        this.bspTree.cleanInnerNodes();
    }

    void setBiggestLeafInTree(LevelGeometryBSPNode node) {
        this.biggestLeafInTree = node;
    }

    int getNumberOfTrianglesInBiggestLeaf() {
        if (this.biggestLeafInTree == null) {
            return 0;
        }
        return this.biggestLeafInTree.triangles.size();
    }

    /*
     * Unable to fully structure code
     */
    private LevelGeometryBSPNode getBSPLeaf(Location location) {
        x = location.x;
        y = location.y;
        z = location.z;
        node = this.bspTree;
        if (x > node.maxX || x < node.minX) {
            return null;
        }
        if (y > node.maxY || y < node.minY) {
            return null;
        }
        if (!(z > node.maxZ) && !(z < node.minZ)) ** GOTO lbl32
        return null;
lbl-1000:
        // 1 sources

        {
            switch (node.sepDim) {
                case 0: {
                    if (x < node.sepVal) {
                        node = node.left;
                        break;
                    }
                    node = node.right;
                    break;
                }
                case 1: {
                    if (y < node.sepVal) {
                        node = node.left;
                        break;
                    }
                    node = node.right;
                    break;
                }
                case 2: {
                    if (z < node.sepVal) {
                        node = node.left;
                        break;
                    }
                    node = node.right;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This should not happen!");
                }
            }
lbl32:
            // 7 sources

            ** while (node.left != null)
        }
lbl33:
        // 1 sources

        return node;
    }

    public AutoTraceRay getAutoTraceRayMessage(Self self, BSPRayInfoContainer rayInfo) {
        Vector3d direction = rayInfo.direction;
        direction.normalize();
        double upDownAngle = Math.asin(direction.getZ() / 1.0);
        double UTFullAngle = 65536.0;
        double UTHalfAngle = UTFullAngle / 2.0;
        double UTQuarterAngle = UTHalfAngle / 2.0;
        double x = rayInfo.direction.x;
        double y = rayInfo.direction.y;
        if (x == 0.0 && y == 0.0) {
            direction = new Vector3d(0.0, 0.0, 1.0);
        } else {
            double rayYaw = NavMeshConstants.transform2DVectorToRotation(new Vector2d(x, y));
            double Yaw = rayYaw + self.getRotation().getYaw();
            Vector2d vector2d = NavMeshConstants.transformRotationTo2DVector(Yaw);
            direction.x = vector2d.x;
            direction.y = vector2d.y;
            direction.normalize();
            direction.z = Math.tan(upDownAngle);
        }
        direction.normalize();
        direction.x *= (double)rayInfo.length;
        direction.y *= (double)rayInfo.length;
        direction.z *= (double)rayInfo.length;
        Location from = self.getLocation();
        Location to = new Location(from.x + direction.x, from.y + direction.y, from.z + direction.z);
        return this.getAutoTraceRayMessage(from, to, rayInfo);
    }

    private AutoTraceRay getAutoTraceRayMessage(Location from, Location to, BSPRayInfoContainer rayInfo) {
        StraightLine3D ray = new StraightLine3D(from.asPoint3D(), to.asPoint3D());
        RaycastResult raycast = this.raycast(from, to);
        if (raycast.hit) {
            return new AutoTraceRayMessage(rayInfo.unrealId, from, to, false, rayInfo.floorCorrection, raycast.hit, raycast.hitNormal, raycast.hitLocation, false, null);
        }
        return new AutoTraceRayMessage(rayInfo.unrealId, from, to, false, rayInfo.floorCorrection, false, null, null, false, null);
    }

    public RaycastResult raycast(Location from, Location to) {
        RaycastResult result = new RaycastResult(from, to);
        try {
            this.raycastInner(from, to, result);
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process((String)("Failed to raycast: " + from + " -> " + to), (Throwable)e));
        }
        if (result.hit) {
            result.hitDistance = result.hitLocation.getDistance(from.getLocation());
        }
        return result;
    }

    private boolean isValidNumber(Double number) {
        if (number == null) {
            return false;
        }
        if (number == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (number == Double.NEGATIVE_INFINITY) {
            return false;
        }
        return number != Double.NaN;
    }

    private boolean isValidPoint(Point3D point) {
        return this.isValidNumber(point.getX()) && this.isValidNumber(point.getY()) && this.isValidNumber(point.getZ());
    }

    private void raycastInner(Location from, Location to, RaycastResult result) {
        Point3D intersection;
        Plane3D plane;
        Vector3D vector2;
        Vector3D vector1;
        Point3D p1;
        StraightLine3D ray = new StraightLine3D(from.asPoint3D(), to.asPoint3D());
        boolean collisionFound = false;
        double collisionDistance = Double.POSITIVE_INFINITY;
        Location hitLocation = null;
        Vector3d normalVector = null;
        LevelGeometryBSPNode leaf = this.getBSPLeaf(from);
        if (leaf == null) {
            return;
        }
        result.travelledNodes.add(leaf);
        int triangleHit = -1;
        for (Integer tId : leaf.triangles) {
            double distance;
            boolean collision;
            double[] v3;
            Vector3D vector22;
            double[] v2;
            Vector3D vector12;
            int[] triangle = this.triangles.get(tId);
            double[] v1 = this.verts.get(triangle[0]);
            Point3D p12 = new Point3D(v1[0], v1[1], v1[2]);
            Plane3D plane2 = new Plane3D(p12, vector12 = new Vector3D((v2 = this.verts.get(triangle[1]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector22 = new Vector3D((v3 = this.verts.get(triangle[2]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]));
            Point3D intersection2 = plane2.getLineIntersection(ray);
            boolean bl = collision = this.isValidPoint(intersection2) && this.isPointInTriangle(intersection2, tId);
            if (!collision) continue;
            double zero = intersection2.getDistance(from.asPoint3D()) + intersection2.getDistance(to.asPoint3D()) - from.getDistance(to);
            boolean bl2 = collision = Math.abs(zero) < 0.001;
            if (!collision || !((distance = intersection2.getDistance(from.asPoint3D())) < collisionDistance)) continue;
            collisionFound = true;
            collisionDistance = distance;
            hitLocation = new Location(intersection2.getX(), intersection2.getY(), intersection2.getZ());
            Vector3D normalVector3D = plane2.getNormalVector();
            normalVector = new Vector3d(normalVector3D.getX(), normalVector3D.getY(), normalVector3D.getZ());
            triangleHit = tId;
        }
        if (collisionFound) {
            result.hitLocation = hitLocation;
            result.hitNormal = normalVector;
            result.hit = true;
            result.hitTriangle = triangleHit;
            return;
        }
        boolean out = false;
        if (to.x > leaf.maxX) {
            out = true;
        }
        if (to.x < leaf.minX) {
            out = true;
        }
        if (to.y > leaf.maxY) {
            out = true;
        }
        if (to.y < leaf.minY) {
            out = true;
        }
        if (to.z > leaf.maxZ) {
            out = true;
        }
        if (to.z < leaf.minZ) {
            out = true;
        }
        if (!out) {
            return;
        }
        collisionDistance = Double.MAX_VALUE;
        Point3D collisionPoint = null;
        if (to.x > from.x) {
            double distance;
            p1 = new Point3D(leaf.maxX, 0.0, 0.0);
            vector1 = new Vector3D(0.0, 1.0, 0.0);
            vector2 = new Vector3D(0.0, 0.0, 1.0);
            plane = new Plane3D(p1, vector1, vector2);
            intersection = plane.getLineIntersection(ray);
            if (this.isValidPoint(intersection) && (distance = intersection.getDistance(from.asPoint3D())) < collisionDistance) {
                collisionPoint = intersection;
                collisionDistance = distance;
            }
        } else {
            double distance;
            p1 = new Point3D(leaf.minX, 0.0, 0.0);
            vector1 = new Vector3D(0.0, 1.0, 0.0);
            vector2 = new Vector3D(0.0, 0.0, 1.0);
            plane = new Plane3D(p1, vector1, vector2);
            intersection = plane.getLineIntersection(ray);
            if (this.isValidPoint(intersection) && (distance = intersection.getDistance(from.asPoint3D())) < collisionDistance) {
                collisionPoint = intersection;
                collisionDistance = distance;
            }
        }
        if (to.y > from.y) {
            double distance;
            p1 = new Point3D(0.0, leaf.maxY, 0.0);
            vector1 = new Vector3D(1.0, 0.0, 0.0);
            vector2 = new Vector3D(0.0, 0.0, 1.0);
            plane = new Plane3D(p1, vector1, vector2);
            intersection = plane.getLineIntersection(ray);
            if (this.isValidPoint(intersection) && (distance = intersection.getDistance(from.asPoint3D())) < collisionDistance) {
                collisionPoint = intersection;
                collisionDistance = distance;
            }
        } else {
            p1 = new Point3D(0.0, leaf.minY, 0.0);
            vector1 = new Vector3D(1.0, 0.0, 0.0);
            vector2 = new Vector3D(0.0, 0.0, 1.0);
            plane = new Plane3D(p1, vector1, vector2);
            intersection = plane.getLineIntersection(ray);
            double distance = intersection.getDistance(from.asPoint3D());
            if (distance < collisionDistance) {
                collisionPoint = intersection;
                collisionDistance = distance;
            }
        }
        if (to.z > from.z) {
            double distance;
            p1 = new Point3D(0.0, 0.0, leaf.maxZ);
            vector1 = new Vector3D(1.0, 0.0, 0.0);
            vector2 = new Vector3D(0.0, 1.0, 0.0);
            plane = new Plane3D(p1, vector1, vector2);
            intersection = plane.getLineIntersection(ray);
            if (this.isValidPoint(intersection) && (distance = intersection.getDistance(from.asPoint3D())) < collisionDistance) {
                collisionPoint = intersection;
                collisionDistance = distance;
            }
        } else {
            double distance;
            p1 = new Point3D(0.0, 0.0, leaf.minZ);
            vector1 = new Vector3D(1.0, 0.0, 0.0);
            vector2 = new Vector3D(0.0, 1.0, 0.0);
            plane = new Plane3D(p1, vector1, vector2);
            intersection = plane.getLineIntersection(ray);
            if (this.isValidPoint(intersection) && (distance = intersection.getDistance(from.asPoint3D())) < collisionDistance) {
                collisionPoint = intersection;
                collisionDistance = distance;
            }
        }
        if (collisionPoint == null) {
            return;
        }
        Vector3d direction = to.sub(from).getNormalized().asVector3d();
        Location newPoint = new Location(collisionPoint.getX() + direction.x, collisionPoint.getY() + direction.y, collisionPoint.getZ() + direction.z);
        if (from.getDistance(to) < from.getDistance(newPoint)) {
            return;
        }
        result.rayPoints.add(newPoint);
        this.raycastInner(newPoint, to, result);
    }

    public boolean isPointInTriangle(Point3D point3D, Integer tId) {
        boolean inside;
        int[] triangle = this.triangles.get(tId);
        Location p = new Location(point3D);
        Location a = new Location(this.verts.get(triangle[0]));
        Location b = new Location(this.verts.get(triangle[1]));
        Location c = new Location(this.verts.get(triangle[2]));
        Location v0 = b.sub(a);
        Location v1 = c.sub(a);
        Location v2 = p.sub(a);
        double d00 = v0.dot(v0);
        double d01 = v0.dot(v1);
        double d11 = v1.dot(v1);
        double d20 = v2.dot(v0);
        double d21 = v2.dot(v1);
        double denom = d00 * d11 - d01 * d01;
        if (Math.abs(denom) < 1.0E-7) {
            return false;
        }
        double v = (d11 * d20 - d01 * d21) / denom;
        double w = (d00 * d21 - d01 * d20) / denom;
        double u = 1.0 - v - w;
        boolean bl = inside = 0.0 < u && u < 1.0 && 0.0 < v && v < 1.0 && 0.0 < w && w < 1.0;
        return inside;
    }

    public double[][] getTriangle(int tId) {
        int[] triangle = this.triangles.get(tId);
        return new double[][]{this.verts.get(triangle[0]), this.verts.get(triangle[1]), this.verts.get(triangle[2])};
    }

    public static class RaycastResult {
        public Location from;
        public Location to;
        public Location rayVector;
        public Location hitLocation;
        public Vector3d hitNormal;
        public boolean hit;
        public double hitDistance;
        public List<LevelGeometryBSPNode> travelledNodes = new ArrayList<LevelGeometryBSPNode>();
        public List<Location> rayPoints = new ArrayList<Location>();
        public int hitTriangle;

        public RaycastResult(Location from, Location to) {
            this.from = from;
            this.to = to;
            this.hit = false;
            this.rayVector = to.sub(from);
        }
    }
}

