/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotName;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.VolumeChanged;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AgentInfo
extends SensorModule<UT2004Bot>
implements ILocated {
    public static final String NONE_WEAPON_ID = "None";
    public static final int TEAM_RED = 0;
    public static final int TEAM_BLUE = 1;
    public static final int TEAM_GREEN = 2;
    public static final int TEAM_GOLD = 3;
    public static final int TEAM_NONE = 255;
    public static final double AT_LOCATION_EPSILON = 100.0;
    public static final double IS_FACING_ANGLE = 6.0;
    public static final double CLOSE_ENOUGH_EPSILON = 50.0;
    Self self = null;
    int suicides = 0;
    int kills = 0;
    InitedMessage lastInitedMessage = null;
    VolumeChanged lastVolumeChanged = null;
    ConfigChange lastConfig = null;
    BotKilledListener botKilledListener;
    PlayerKilledListener playerKilledListener;
    private InitedMessageListener initedMessageListener;
    private VolumeChangedListener volumeChangedListener;
    private SelfListener selfListener;
    private ConfigChangeListener configChangeListener;
    public Game game;

    public UnrealId getId() {
        if (this.self == null) {
            return null;
        }
        if (this.self.getBotId() != null) {
            return this.self.getBotId();
        }
        return this.self.getId();
    }

    public String getName() {
        if (this.self == null) {
            return null;
        }
        return this.self.getName();
    }

    public UT2004BotName getBotName() {
        return ((UT2004Bot)this.agent).getBotName();
    }

    public Integer getTeam() {
        if (this.self == null) {
            return null;
        }
        return this.self.getTeam();
    }

    public boolean isEnemy(int team) {
        return team == 255 || team != this.getTeam();
    }

    public boolean isEnemy(Player player) {
        return this.isEnemy(player.getTeam());
    }

    public boolean isFriend(int team) {
        return team == this.getTeam();
    }

    public boolean isFriend(Player player) {
        return this.isFriend(player.getTeam());
    }

    public Location getLocation() {
        if (this.self == null) {
            return null;
        }
        return this.self.getLocation();
    }

    public boolean atLocation(String objectId) {
        IWorldObject obj = ((UT2004Bot)this.agent).getWorldView().get((WorldObjectId)UnrealId.get((String)objectId));
        if (obj == null) {
            GameInfo info = (GameInfo)this.worldView.getSingle(GameInfo.class);
            if (info != null) {
                obj = ((UT2004Bot)this.agent).getWorldView().get((WorldObjectId)UnrealId.get((String)(String.valueOf(info.getLevel()) + "." + objectId)));
            }
            if (info == null) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("atLocation(): Object with id '" + objectId + "' does not exist in the worldview!");
                }
                return false;
            }
        }
        if (!(obj instanceof ILocated)) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("atLocation(): Object with id '" + objectId + "' is not implementing ILocated, it is " + obj.getClass().getSimpleName() + ".");
            }
            return false;
        }
        return this.atLocation((ILocated)obj);
    }

    public boolean atLocation(String objectId, double epsilon) {
        IWorldObject obj = ((UT2004Bot)this.agent).getWorldView().get((WorldObjectId)UnrealId.get((String)objectId));
        if (obj == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("atLocation(): Object with id '" + objectId + "' does not exist in the worldview!");
            }
            return false;
        }
        if (!(obj instanceof ILocated)) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("atLocation(): Object with id '" + objectId + "' is not implementing ILocated, it is " + obj.getClass().getSimpleName() + ".");
            }
            return false;
        }
        return this.atLocation((ILocated)obj, epsilon);
    }

    public boolean isAtLocation(ILocated location) {
        return this.atLocation(location);
    }

    public boolean isAtLocation(ILocated location, double epsilon) {
        return this.atLocation(location, epsilon);
    }

    public boolean atLocation(ILocated location) {
        return this.atLocation(location, 100.0);
    }

    public boolean atLocation(ILocated location, double epsilon) {
        if (location == null || this.getLocation() == null) {
            return false;
        }
        return this.getLocation().getPoint3d().distance(location.getLocation().getPoint3d()) < epsilon;
    }

    public Double getDistance(ILocated location) {
        if (this.self == null) {
            return null;
        }
        if (location == null) {
            return null;
        }
        return this.self.getLocation().getDistance(location.getLocation());
    }

    public Rotation getRotation() {
        if (this.self == null) {
            return null;
        }
        return this.self.getRotation();
    }

    public Rotation getHorizontalRotation() {
        if (this.self == null) {
            return null;
        }
        Rotation rot = new Rotation(0.0, this.self.getRotation().getYaw(), 0.0);
        return rot;
    }

    public Velocity getVelocity() {
        if (this.self == null) {
            return null;
        }
        return this.self.getVelocity();
    }

    public Boolean isMoving() {
        if (this.getVelocity() == null) {
            return null;
        }
        return !this.getVelocity().isZero();
    }

    public Boolean isCrouched() {
        if (this.self == null) {
            return null;
        }
        return this.self.isCrouched();
    }

    public Boolean isWalking() {
        if (this.self == null) {
            return null;
        }
        return this.self.isWalking();
    }

    public Boolean isFacing(ILocated location) {
        Location agentFaceVector;
        if (location == null || this.getRotation() == null) {
            return null;
        }
        Location directionVector = location.getLocation().sub(this.getLocation()).getNormalized();
        if (Math.acos(directionVector.dot(agentFaceVector = this.getRotation().toLocation().getNormalized())) <= Math.toRadians(6.0)) {
            return true;
        }
        return false;
    }

    public Boolean isFacing(ILocated location, double angle) {
        Location agentFaceVector;
        if (location == null || this.getRotation() == null) {
            return null;
        }
        Location directionVector = location.getLocation().sub(this.getLocation()).getNormalized();
        if (Math.acos(directionVector.dot(agentFaceVector = this.getRotation().toLocation().getNormalized())) <= Math.toRadians(angle)) {
            return true;
        }
        return false;
    }

    public Location getFloorLocation() {
        if (this.self == null) {
            return null;
        }
        return this.self.getFloorLocation();
    }

    public Boolean isTouchingGround() {
        if (this.getLocation() == null || this.getFloorLocation() == null) {
            return null;
        }
        double d = this.getLocation().z - this.getFloorLocation().z;
        int n = this.isCrouched() != false ? 50 : 80;
        if (d < (double)n) {
            return true;
        }
        return false;
    }

    public Double getRemainingUDamageTime() {
        if (this.self == null) {
            return null;
        }
        return this.self.getUDamageTime() - this.getTime();
    }

    public Boolean hasUDamage() {
        if (this.getRemainingUDamageTime() == null) {
            return null;
        }
        if (this.getRemainingUDamageTime() > 0.0) {
            return true;
        }
        return false;
    }

    public Boolean hasInvisibility() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboInvis");
    }

    public Boolean hasFastFire() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboBerserk");
    }

    public Boolean hasRegeneration() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboDefensive");
    }

    public Boolean hasSpeed() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboSpeed");
    }

    public Integer getHealth() {
        if (this.self == null) {
            return null;
        }
        return this.self.getHealth();
    }

    public Boolean isHealthy() {
        if (this.getHealth() == null || this.game == null) {
            return null;
        }
        if (this.getHealth() >= this.game.getFullHealth()) {
            return true;
        }
        return false;
    }

    public Boolean isSuperHealthy() {
        if (this.getHealth() == null || this.game == null) {
            return null;
        }
        if (this.getHealth() >= this.game.getMaxHealth()) {
            return true;
        }
        return false;
    }

    public Integer getArmor() {
        if (this.self == null) {
            return null;
        }
        return this.self.getArmor();
    }

    public Boolean hasArmor() {
        if (this.getArmor() == null) {
            return null;
        }
        if (this.getArmor() >= this.game.getMaxArmor()) {
            return true;
        }
        return false;
    }

    public Integer getLowArmor() {
        if (this.self == null) {
            return null;
        }
        return this.self.getSmallArmor();
    }

    public Boolean hasLowArmor() {
        if (this.getLowArmor() == null || this.game == null) {
            return null;
        }
        if (this.getLowArmor() >= this.game.getMaxLowArmor()) {
            return true;
        }
        return false;
    }

    public Integer getHighArmor() {
        if (this.self == null) {
            return null;
        }
        return this.self.getArmor() - this.self.getSmallArmor();
    }

    public Boolean hasHighArmor() {
        if (this.getHighArmor() == null) {
            return null;
        }
        if (this.getHighArmor() >= this.game.getMaxHighArmor()) {
            return true;
        }
        return false;
    }

    public Integer getAdrenaline() {
        if (this.self == null) {
            return null;
        }
        return this.self.getAdrenaline();
    }

    public Boolean isAdrenalineSufficient() {
        if (this.getAdrenaline() == null) {
            return null;
        }
        if (this.getAdrenaline() >= this.game.getTargetAdrenaline()) {
            return true;
        }
        return false;
    }

    public Boolean isAdrenalineFull() {
        if (this.getAdrenaline() == null) {
            return null;
        }
        if (this.getAdrenaline() >= this.game.getMaxAdrenaline()) {
            return true;
        }
        return false;
    }

    public UnrealId getCurrentWeapon() {
        if (this.self == null) {
            return null;
        }
        return UnrealId.get((String)this.self.getWeapon());
    }

    public String getCurrentWeaponName() {
        if (this.getCurrentWeapon() == null) {
            return null;
        }
        return this.self.getWeapon().substring(this.self.getWeapon().indexOf(".") + 1);
    }

    public abstract ItemType getCurrentWeaponType();

    public Boolean hasWeapon() {
        if (this.self == null) {
            return null;
        }
        return !this.self.getWeapon().equalsIgnoreCase(NONE_WEAPON_ID);
    }

    public Integer getCurrentAmmo() {
        if (this.self == null) {
            return null;
        }
        return this.self.getPrimaryAmmo();
    }

    public Integer getCurrentSecondaryAmmo() {
        if (this.self == null) {
            return null;
        }
        return this.self.getSecondaryAmmo();
    }

    public Boolean isShooting() {
        if (this.self == null) {
            return null;
        }
        return this.self.isShooting();
    }

    public Boolean isPrimaryShooting() {
        if (this.self == null) {
            return null;
        }
        if (this.isShooting().booleanValue() && !this.isSecondaryShooting().booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isSecondaryShooting() {
        if (this.self == null) {
            return null;
        }
        return this.self.isAltFiring();
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        if (this.self == null) {
            return Integer.MIN_VALUE;
        }
        return this.game.getPlayerDeaths(this.getId());
    }

    public int getSuicides() {
        return this.suicides;
    }

    public int getScore() {
        if (this.self == null) {
            return Integer.MIN_VALUE;
        }
        return this.game.getPlayerScore(this.getId());
    }

    public int getTeamScore() {
        return this.game.getTeamScore(this.getTeam());
    }

    public Velocity getCurrentZoneVelocity() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getZoneVelocity();
    }

    public Velocity getCurrentZoneGravity() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getZoneGravity();
    }

    public Double getCurrentVolumeGroundFriction() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getGroundFriction();
    }

    public Double getCurrentVolumeFluidFriction() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getFluidFriction();
    }

    public Double _getCurrentVolumeTerminalVelocity() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getTerminalVelocity();
    }

    public Boolean isCurrentVolumeWater() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isWaterVolume();
    }

    public Boolean isCurrentVolumePainCausing() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isPainCausing();
    }

    public Double getCurrentVolumeDamagePerSec() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getDamagePerSec();
    }

    public Boolean isCurrentVolumeDestructive() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isDestructive();
    }

    public String getCurrentVolumeDamageType() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getDamageType();
    }

    public Boolean isCurrentVolumeBanningInventory() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isNoInventory();
    }

    public Boolean isCurrentVolumeAffectingProjectiles() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isMoveProjectiles();
    }

    public Boolean isCurrentZoneNeutral() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isNeutralZone();
    }

    public Double getDamageScaling() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getDamageScaling();
    }

    public Double getBaseSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getGroundSpeed();
    }

    public Double getAirSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getAirSpeed();
    }

    public Double getLadderSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getLadderSpeed();
    }

    public Double getWaterSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getWaterSpeed();
    }

    public Double getFallSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getMaxFallSpeed();
    }

    public Double getDodgeSpeedFactor() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getDodgeSpeedFactor();
    }

    public Double getAccelerationRate() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getAccelRate();
    }

    public Double getAirControl() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getAirControl();
    }

    public Double getJumpZBoost() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getJumpZ();
    }

    public Double getDodgeZBoost() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getDodgeSpeedZ();
    }

    public double getTime() {
        if (this.game == null) {
            return 0.0;
        }
        return this.game.getTime();
    }

    public double getTimeDelta() {
        if (this.game == null) {
            return 0.0;
        }
        return this.game.getTimeDelta();
    }

    public ConfigChange getConfig() {
        return this.lastConfig;
    }

    public NavPoint getNearestNavPoint() {
        if (this.getLocation() == null) {
            return null;
        }
        return (NavPoint)DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), (ILocated)this.getLocation());
    }

    public NavPoint getNearestNavPoint(double maxDistance) {
        if (this.getLocation() == null) {
            return null;
        }
        return (NavPoint)DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), (ILocated)this.getLocation(), (double)maxDistance);
    }

    public NavPoint getNearestNavPoint(ILocated location) {
        if (location == null) {
            return null;
        }
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        if (location instanceof Item && ((Item)location).getNavPoint() != null) {
            return ((Item)location).getNavPoint();
        }
        return (NavPoint)DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), (ILocated)location);
    }

    public NavPoint getNearestNavPoint(ILocated location, double maxDistance) {
        if (location == null) {
            return null;
        }
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        if (location instanceof Item && ((Item)location).getNavPoint() != null) {
            return ((Item)location).getNavPoint();
        }
        return (NavPoint)DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), (ILocated)location, (double)maxDistance);
    }

    public boolean isOnNavGraph() {
        if (this.getLocation() == null) {
            this.log.warning("AgentInfo.getLocation() is NULL!");
            return false;
        }
        return this.getLocation().getDistance(this.getNearestNavPoint().getLocation()) < 50.0;
    }

    public NavPoint getNearestVisibleNavPoint() {
        if (this.getLocation() == null) {
            return null;
        }
        return (NavPoint)DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), (ILocated)this.getLocation());
    }

    public Item getNearestItem() {
        if (this.getLocation() == null) {
            return null;
        }
        return (Item)DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(Item.class).values(), (ILocated)this.getLocation());
    }

    public Item getNearestVisibleItem() {
        if (this.getLocation() == null) {
            return null;
        }
        return (Item)DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(Item.class).values(), (ILocated)this.getLocation());
    }

    public Player getNearestPlayer() {
        if (this.getLocation() == null) {
            return null;
        }
        return (Player)DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(Player.class).values(), (ILocated)this.getLocation());
    }

    public Player getNearestVisiblePlayer() {
        if (this.getLocation() == null) {
            return null;
        }
        return (Player)DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(Player.class).values(), (ILocated)this.getLocation());
    }

    public Self getSelf() {
        return this.self;
    }

    public AgentInfo(UT2004Bot bot) {
        this(bot, new Game(bot), null);
    }

    public AgentInfo(UT2004Bot bot, Game game) {
        this(bot, game, null);
    }

    public AgentInfo(UT2004Bot bot, Game game, Logger log) {
        super((IObservingAgent)bot, log);
        this.game = game;
        NullCheck.check((Object)((Object)this.game), (String)"game");
        this.selfListener = new SelfListener(this.worldView);
        this.initedMessageListener = new InitedMessageListener(this.worldView);
        this.volumeChangedListener = new VolumeChangedListener(this.worldView);
        this.botKilledListener = new BotKilledListener(this.worldView);
        this.playerKilledListener = new PlayerKilledListener(this.worldView);
        this.configChangeListener = new ConfigChangeListener(this.worldView);
        this.cleanUp();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.self = null;
        this.suicides = 0;
        this.kills = 0;
        this.lastInitedMessage = null;
        this.lastVolumeChanged = null;
        this.lastConfig = null;
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, (IWorldEventListener)this);
        }

        public void notify(BotKilled event) {
            if (AgentInfo.this.self == null) {
                return;
            }
            if (event.getKiller() == null || event.getKiller().equals((Object)AgentInfo.this.getId())) {
                ++AgentInfo.this.suicides;
            }
        }
    }

    private class ConfigChangeListener
    implements IWorldObjectEventListener<ConfigChange, IWorldObjectEvent<ConfigChange>> {
        private IWorldView worldView;

        public ConfigChangeListener(IWorldView worldView) {
            worldView.addObjectListener(ConfigChange.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
            this.worldView = worldView;
        }

        public void notify(IWorldObjectEvent<ConfigChange> event) {
            AgentInfo.this.lastConfig = (ConfigChange)event.getObject();
        }
    }

    private class InitedMessageListener
    implements IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> {
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            AgentInfo.this.lastInitedMessage = (InitedMessage)event.getObject();
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }
    }

    private class PlayerKilledListener
    implements IWorldEventListener<PlayerKilled> {
        public PlayerKilledListener(IWorldView worldView) {
            worldView.addEventListener(PlayerKilled.class, (IWorldEventListener)this);
        }

        public void notify(PlayerKilled event) {
            if (AgentInfo.this.self == null) {
                return;
            }
            if (event.getKiller() != null && event.getKiller().equals((Object)AgentInfo.this.getId())) {
                ++AgentInfo.this.kills;
            }
        }
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            AgentInfo.this.self = (Self)event.getObject();
        }
    }

    private class VolumeChangedListener
    implements IWorldEventListener<VolumeChanged> {
        public void notify(VolumeChanged event) {
            AgentInfo.this.lastVolumeChanged = event;
        }

        public VolumeChangedListener(IWorldView worldView) {
            worldView.addEventListener(VolumeChanged.class, (IWorldEventListener)this);
        }
    }
}

