/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.utils.ExceptionToString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import java.util.logging.Logger;

public class LevelGeometryModule {
    private IWorldView worldView;
    private Logger log;
    private Random random;
    private boolean loaded = false;
    private GameInfo loadedForMap = null;
    private LevelGeometry levelGeometry;
    private IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> gameInfoListener = new IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>>(){

        public void notify(IWorldObjectEvent<GameInfo> event) {
            LevelGeometryModule.this.load((GameInfo)event.getObject());
        }
    };

    public LevelGeometryModule(IWorldView worldView, IAgentLogger logger) {
        this.log = logger == null ? new LogCategory("LevelGeometry") : logger.getCategory("LevelGeometry");
        this.random = new Random();
        worldView.addObjectListener(GameInfo.class, WorldObjectFirstEncounteredEvent.class, this.gameInfoListener);
        GameInfo info = (GameInfo)worldView.getSingle(GameInfo.class);
        if (info != null) {
            this.load(info);
        }
    }

    private void clear() {
        this.log.warning("LevelGeometry has been cleared...");
        this.levelGeometry = null;
        this.loaded = false;
        this.loadedForMap = null;
    }

    private boolean loadLevelGeometry(String mapName) {
        String levelGeometryFileName = NavMeshConstants.processedLevelGeometryDir + "\\" + mapName + ".processed";
        File levelGeometryFile = new File(levelGeometryFileName);
        this.log.info("Loading LevelGeometry data for '" + mapName + "'...");
        try {
            if (levelGeometryFile.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(levelGeometryFile));
                this.levelGeometry = (LevelGeometry)in.readObject();
                return true;
            }
            this.log.warning("Processed LevelGeometry does not exist at: " + levelGeometryFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process((String)"Previously saved level geometry file could not have been restored.", (Throwable)e));
        }
        try {
            this.levelGeometry = new LevelGeometry(this.log);
            if (this.levelGeometry.load(mapName)) {
                this.log.info("Level geometry read and built ok.");
                try {
                    this.log.warning("Writing level geometry to a file at: " + levelGeometryFile.getAbsolutePath());
                    levelGeometryFile.getParentFile().mkdirs();
                    ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(levelGeometryFile));
                    out.writeObject(this.levelGeometry);
                    this.log.info("Level geometry written ok.");
                }
                catch (Exception e) {
                    this.log.severe(ExceptionToString.process((String)"Exception during writing level geom to a file.", (Throwable)e));
                }
                return true;
            }
            this.log.severe("COULD NOT INITIALIZE FOR MAP: " + mapName);
            this.levelGeometry = null;
            return false;
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process((String)"Unable to load level geometry files.", (Throwable)e));
            this.levelGeometry = null;
            return false;
        }
    }

    private void load(GameInfo info) {
        if (info == null) {
            this.log.severe("Could not load for 'null' GameInfo!");
            return;
        }
        if (this.loaded) {
            if (this.loadedForMap == null) {
                this.clear();
            } else if (this.loadedForMap.getLevel().equals(info.getLevel())) {
                return;
            }
        }
        String mapName = info.getLevel();
        this.log.warning("Loading LevelGeometry for '" + mapName + "'...");
        if (this.loadLevelGeometry(mapName)) {
            this.loaded = true;
            this.loadedForMap = info;
            return;
        }
        this.loaded = false;
        this.loadedForMap = null;
    }

    public boolean isInitialized() {
        return this.levelGeometry != null;
    }

    public LevelGeometry getLevelGeometry() {
        return this.levelGeometry;
    }
}

