package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import java.awt.Color;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry.RaycastResult;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometryBSPNode;

public class LevelGeometryDraw extends UT2004Draw {
	
	private static class RaycastResultIterator {
		
		private RaycastResult result;
		
		public Location from;
		public Location to;
		public LevelGeometryBSPNode node;
		
		private int index = 0;
		
		public RaycastResultIterator(RaycastResult result) {
			this.result = result;
			node = result.travelledNodes.get(0);
			from = result.from;
			if (result.travelledNodes.size() == 1) {
				to = (result.hit ? result.hitLocation : result.to);
			} else {
				to = result.rayPoints.get(0);
			}
		}
		
		public boolean hasNext() {
			return index+1 < result.travelledNodes.size();
		}
		
		public void next() {
			if (!hasNext()) return;
			from = to;
			++index;
			node = result.travelledNodes.get(index);
			if (index+1 == result.travelledNodes.size()) {
				to = (result.hit ? result.hitLocation : result.to);
			} else {
				to = result.rayPoints.get(index);
			}
		}
		
		
	}
	
	private LevelGeometry levelGeometry;

	public LevelGeometryDraw(LevelGeometry levelGeometry, Logger log, IUT2004ServerProvider serverProvider) {
		super(log, serverProvider);
		this.levelGeometry = levelGeometry;
	}
	
	/**
     * Draws LevelGeometry within game.
     */   
    public boolean draw() {
    	if (levelGeometry == null || !levelGeometry.isLoaded()) return false;
    	
    	log.info("Drawing LevelGeomtry...");
    	
    	for (int[] triangle : levelGeometry.triangles) {
    		double[][] verts = new double[][]{ levelGeometry.verts.get(triangle[0]), levelGeometry.verts.get(triangle[1]), levelGeometry.verts.get(triangle[2]) };
    		drawPolygon(verts);
    	}
    	
    	log.info("LevelGeomtry drawn.");    	
    	
    	return true;
    }

	public void setLevelGeometry(LevelGeometry levelGeometry) {
		this.levelGeometry = levelGeometry;
	}

	public boolean drawBSP() {
		if (levelGeometry == null || !levelGeometry.isLoaded()) return false;
		
		log.info("Drawing LevelGeomtry BSP...");
		
		drawBSPRecursively(levelGeometry.getBSPRoot());
		
		return true;
	}
	
	public boolean drawRaycast(RaycastResult ray) {
		if (levelGeometry == null || !levelGeometry.isLoaded()) return false;
		
		LevelGeometry lg = levelGeometry;
		
		RaycastResultIterator iter = new RaycastResultIterator(ray);
		
		Color lineColor = ray.hit ? Color.RED : Color.BLUE;
		Color cubeColor = ray.hit ? Color.ORANGE : Color.CYAN;
		
		while (true) {
			drawBSPNodeCube(Color.YELLOW, iter.node);
			
			drawLine(lineColor, iter.from, iter.to);
			drawCube(cubeColor, iter.to, 8);
			
			if (!iter.hasNext()) break;
			
			iter.next();
		}
		
		if (ray.hit) {
			int[] triangle = lg.triangles.get(ray.hitTriangle);
			drawPolygon(cubeColor, lg.verts.get(triangle[0]), lg.verts.get(triangle[1]), lg.verts.get(triangle[2]));			
		}
		
		return true;
	}
	
	private void drawBSPNodeCube(Color color, LevelGeometryBSPNode node) {
		Location v1 = null;
		Location v2 = null;
		Location v3 = null;
		Location v4 = null;
		
		v1 = new Location(node.minX, node.minY, node.minZ);
		v2 = new Location(node.minX, node.maxY, node.minZ);
		v3 = new Location(node.minX, node.maxY, node.maxZ);
		v4 = new Location(node.minX, node.minY, node.maxZ);
		
		drawPolygon(color, v1, v2, v3, v4);
		
		v1 = new Location(node.maxX, node.minY, node.minZ);
		v2 = new Location(node.maxX, node.maxY, node.minZ);
		v3 = new Location(node.maxX, node.maxY, node.maxZ);
		v4 = new Location(node.maxX, node.minY, node.maxZ);
		
		drawPolygon(color, v1, v2, v3, v4);
		
		v1 = new Location(node.minX, node.minY, node.minZ);
		v2 = new Location(node.maxX, node.minY, node.minZ);
		drawLine(color, v1, v2);
		
		v1 = new Location(node.minX, node.maxY, node.minZ);
		v2 = new Location(node.maxX, node.maxY, node.minZ);
		drawLine(color, v1, v2);
		
		v1 = new Location(node.minX, node.maxY, node.maxZ);
		v2 = new Location(node.maxX, node.maxY, node.maxZ);
		drawLine(color, v1, v2);
		
		v1 = new Location(node.minX, node.minY, node.maxZ);
		v2 = new Location(node.maxX, node.minY, node.maxZ);
		drawLine(color, v1, v2);
	}

	private void drawBSPRecursively(LevelGeometryBSPNode node) {
		if (node.left == null) return; // no separation
		
		Location v1 = null;
		Location v2 = null;
		Location v3 = null;
		Location v4 = null;
		
		switch (node.sepDim) {
		case 0: //X
			v1 = new Location(node.sepVal, node.minY, node.minZ);
			v2 = new Location(node.sepVal, node.maxY, node.minZ);
			v3 = new Location(node.sepVal, node.maxY, node.maxZ);
			v4 = new Location(node.sepVal, node.minY, node.maxZ);
			break;
		case 1: //Y
			v1 = new Location(node.minX, node.sepVal, node.minZ);
			v2 = new Location(node.maxX, node.sepVal, node.minZ);
			v3 = new Location(node.maxX, node.sepVal, node.maxZ);
			v4 = new Location(node.minX, node.sepVal, node.maxZ);
			break;
		case 2: //Z
			v1 = new Location(node.minX, node.minY, node.sepVal);
			v2 = new Location(node.maxX, node.minY, node.sepVal);
			v3 = new Location(node.maxX, node.maxY, node.sepVal);
			v4 = new Location(node.minX, node.maxY, node.sepVal);
			break;
		}
		
		drawPolygon(Color.YELLOW, v1, v2, v3, v4);
		
		drawBSPRecursively(node.left);
		drawBSPRecursively(node.right);
	}
    
	
}
