/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.NavMeshDraw;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Logger;

public class NavMeshModule {
    private IWorldView worldView;
    private Logger log;
    private NavMeshDraw navMeshDraw;
    private boolean loaded = false;
    private GameInfo loadedForMap = null;
    private NavMesh navMesh;
    private IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> gameInfoListener = new IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>>(){

        public void notify(IWorldObjectEvent<GameInfo> event) {
            NavMeshModule.this.load((GameInfo)event.getObject());
        }
    };

    public NavMeshModule(IUT2004ServerProvider serverProvider, IWorldView worldView, IAgentLogger logger) {
        this.log = logger == null ? new LogCategory("NavMesh") : logger.getCategory("NavMesh");
        this.worldView = worldView;
        NullCheck.check((Object)this.worldView, (String)"worldView");
        this.navMesh = new NavMesh(worldView, this.log);
        worldView.addObjectListener(GameInfo.class, WorldObjectFirstEncounteredEvent.class, this.gameInfoListener);
        GameInfo info = (GameInfo)worldView.getSingle(GameInfo.class);
        if (info != null) {
            this.load(info);
        }
        this.navMeshDraw = new NavMeshDraw(this.navMesh, this.log, serverProvider);
    }

    private void clear() {
        this.log.warning("NavMesh has been cleared...");
        this.navMesh.clear();
        this.loaded = false;
        this.loadedForMap = null;
    }

    private void load(GameInfo info) {
        if (info == null) {
            this.log.severe("Could not load for 'null' GameInfo!");
            return;
        }
        if (this.loaded) {
            if (this.loadedForMap == null) {
                this.clear();
            } else if (this.loadedForMap.getLevel().equals(info.getLevel())) {
                return;
            }
        }
        if (this.navMesh.load(info)) {
            this.loaded = true;
            this.loadedForMap = info;
        } else {
            this.loaded = false;
            this.loadedForMap = null;
        }
    }

    public boolean isInitialized() {
        return this.loaded;
    }

    public NavMesh getNavMesh() {
        return this.navMesh;
    }

    public NavMeshDraw getNavMeshDraw() {
        return this.navMeshDraw;
    }
}

