/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MutatorListObtained;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Game
extends SensorModule<UT2004Bot> {
    GameInfo lastGameInfo = null;
    InitedMessage lastInitedMessage = null;
    BeginMessage lastBeginMessage = null;
    MutatorListObtained lastMutatorListObtained = null;
    Map<Integer, FlagInfo> allCTFFlags = new HashMap<Integer, FlagInfo>();
    Map<UnrealId, PlayerScore> lastPlayerScore = null;
    Map<Integer, TeamScore> lastTeamScore = null;
    Self self;
    private SelfListener selfListener;
    GameInfoListener gameInfoListener = new GameInfoListener(this.worldView);
    String mapNameLowerChar = "";
    InitedMessageListener initedMessageListener;
    BeginMessageListener beginMessageListener = new BeginMessageListener(this.worldView);
    MutatorListObtainedListener mutatorListObtainedListener;
    FlagInfoObjectListener flagInfoObjectListener;
    private PlayerScoreListener playerScoreListener;
    private TeamScoreListener teamScoreListener;

    public GameInfo getGameInfo() {
        return this.lastGameInfo;
    }

    public GameType getGameType() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return GameType.getType(this.lastGameInfo.getGametype());
    }

    public String getMapName() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getLevel();
    }

    public boolean isMapName(String name) {
        if (this.lastGameInfo == null) {
            return false;
        }
        if (name == null) {
            return false;
        }
        return this.lastGameInfo.getLevel().toLowerCase().equals(name.toLowerCase());
    }

    public String getPrefixed(String objectId) {
        if (this.getMapName() == null) {
            throw new PogamutException("GameInfo was not received yet, can't prefix '" + objectId + "'.", (Object)this);
        }
        if (objectId.toLowerCase().startsWith(this.mapNameLowerChar + ".")) {
            if (!objectId.startsWith(this.getMapName())) {
                objectId = this.getMapName() + objectId.substring(this.mapNameLowerChar.length());
            }
            return objectId;
        }
        if (objectId.contains(".")) {
            throw new PogamutException("id '" + objectId + "' is already prefixed with '" + objectId.substring(0, objectId.indexOf(".")) + "' which is different from current map name '" + this.getMapName() + "', map name validation fails!", (Object)this);
        }
        return this.getMapName() + "." + objectId;
    }

    public UnrealId getPrefixedId(String objectId) {
        if (this.getMapName() == null) {
            throw new PogamutException("GameInfo was not received yet, can't prefix '" + objectId + "'.", (Object)this);
        }
        if (objectId.toLowerCase().startsWith(this.mapNameLowerChar + ".")) {
            if (!objectId.startsWith(this.getMapName())) {
                objectId = this.getMapName() + objectId.substring(this.mapNameLowerChar.length());
            }
            return UnrealId.get((String)objectId);
        }
        if (objectId.contains(".")) {
            throw new PogamutException("id '" + objectId + "' is already prefixed with '" + objectId.substring(0, objectId.indexOf(".")) + "' which is different from current map name '" + this.getMapName() + "', map name validation fails!", (Object)this);
        }
        return UnrealId.get((String)(this.getMapName() + "." + objectId));
    }

    public double getTime() {
        if (this.lastBeginMessage == null) {
            return 0.0;
        }
        return this.lastBeginMessage.getTime();
    }

    public Double getTimeLimit() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getTimeLimit();
    }

    public Double getRemainingTime() {
        if (this.getTimeLimit() == null) {
            return null;
        }
        return this.getTimeLimit() - this.getTime();
    }

    public Integer getFragLimit() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getFragLimit();
    }

    public Integer getTeamScoreLimit() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return (int)this.lastGameInfo.getGoalTeamScore();
    }

    public FlagInfo getCTFFlag(int team) {
        Collection flags = this.worldView.getAll(FlagInfo.class).values();
        for (FlagInfo flag : flags) {
            if (flag.getTeam() != team) continue;
            return flag;
        }
        return null;
    }

    public Collection<FlagInfo> getCTFFlags() {
        return this.worldView.getAll(FlagInfo.class).values();
    }

    public Collection<NavPoint> getDominationPoints() {
        ArrayList<NavPoint> domPoints = new ArrayList<NavPoint>();
        Collection navPoints = this.worldView.getAll(NavPoint.class).values();
        for (NavPoint nav : navPoints) {
            if (!nav.isDomPoint()) continue;
            domPoints.add(nav);
        }
        return domPoints;
    }

    public Map<Integer, TeamScore> getTeamScores() {
        return Collections.unmodifiableMap(this.lastTeamScore);
    }

    public int getTeamScore(int team) {
        TeamScore teamScore = this.lastTeamScore.get(team);
        if (teamScore == null) {
            return Integer.MIN_VALUE;
        }
        return teamScore.getScore();
    }

    public boolean isTeamScoreKnown(int team) {
        return this.lastTeamScore.containsKey(team);
    }

    public Map<UnrealId, PlayerScore> getPlayerScores() {
        return Collections.unmodifiableMap(this.lastPlayerScore);
    }

    public int getPlayerScore(UnrealId id) {
        PlayerScore score = this.lastPlayerScore.get(id);
        if (score != null) {
            return score.getScore();
        }
        return Integer.MIN_VALUE;
    }

    public boolean isPlayerScoreKnown(UnrealId player) {
        return this.lastPlayerScore.containsKey(player);
    }

    public int getPlayerDeaths(UnrealId id) {
        PlayerScore score = this.lastPlayerScore.get(id);
        if (score == null) {
            return Integer.MIN_VALUE;
        }
        return score.getDeaths();
    }

    public boolean isPlayerDeathsKnown(UnrealId player) {
        return this.lastPlayerScore.containsKey(player);
    }

    public Integer getMaxTeams() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getMaxTeams();
    }

    public Integer getMaxTeamSize() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getMaxTeamSize();
    }

    public Integer getStartHealth() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getHealthStart();
    }

    public Integer getFullHealth() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getHealthFull();
    }

    public Integer getMaxHealth() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getHealthMax();
    }

    public Integer getMaxArmor() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getShieldStrengthMax();
    }

    public int getMaxLowArmor() {
        return 50;
    }

    public int getMaxHighArmor() {
        return 100;
    }

    public Integer getStartAdrenaline() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return (int)this.lastInitedMessage.getAdrenalineStart();
    }

    public Integer getTargetAdrenaline() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public Integer getMaxAdrenaline() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public Boolean getWeaponsStay() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.isWeaponStay();
    }

    public Integer getMaxMultiJump() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getMaxMultiJump();
    }

    public List<Mutator> getMutators() {
        if (this.lastMutatorListObtained == null) {
            return null;
        }
        return this.lastMutatorListObtained.getMutators();
    }

    public Boolean isPaused() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.isGamePaused();
    }

    public Boolean isBotsPaused() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.isBotsPaused();
    }

    public Map<Integer, FlagInfo> getAllCTFFlags() {
        return this.allCTFFlags;
    }

    public Collection<FlagInfo> getAllCTFFlagsCollection() {
        return this.allCTFFlags.values();
    }

    public FlagInfo getFlag(int team) {
        return this.allCTFFlags.get(team);
    }

    public FlagInfo getMyFlag() {
        if (this.self == null) {
            return null;
        }
        return this.allCTFFlags.get(this.self.getTeam());
    }

    public FlagInfo getEnemyFlag() {
        if (this.self == null) {
            return null;
        }
        return this.getFlag(this.self.getTeam() == 0 ? 1 : 0);
    }

    public Location getFlagBase(int team) {
        if (this.lastGameInfo == null) {
            return null;
        }
        if (team == 0) {
            return this.lastGameInfo.getRedBaseLocation();
        }
        return this.lastGameInfo.getBlueBaseLocation();
    }

    public Location getMyFlagBase() {
        if (this.self == null) {
            return null;
        }
        return this.getFlagBase(this.self.getTeam());
    }

    public Location getEnemyFlagBase() {
        if (this.self == null) {
            return null;
        }
        return this.getFlagBase(this.self.getTeam() == 0 ? 1 : 0);
    }

    public Game(UT2004Bot bot) {
        this(bot, null);
    }

    public Game(UT2004Bot bot, Logger log) {
        super((IObservingAgent)bot, log);
        this.initedMessageListener = new InitedMessageListener(this.worldView);
        this.mutatorListObtainedListener = new MutatorListObtainedListener(this.worldView);
        this.flagInfoObjectListener = new FlagInfoObjectListener(this.worldView);
        this.playerScoreListener = new PlayerScoreListener(this.worldView);
        this.teamScoreListener = new TeamScoreListener(this.worldView);
        this.lastPlayerScore = new HashMap<UnrealId, PlayerScore>();
        this.lastTeamScore = new HashMap<Integer, TeamScore>();
        this.selfListener = new SelfListener(this.worldView);
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        super.cleanUp();
        this.lastGameInfo = null;
        this.lastInitedMessage = null;
        this.lastBeginMessage = null;
        this.lastMutatorListObtained = null;
        Map<Object, InfoMessage> map = this.lastPlayerScore;
        synchronized (map) {
            this.lastPlayerScore.clear();
        }
        map = this.lastTeamScore;
        synchronized (map) {
            this.lastTeamScore.clear();
        }
    }

    private class TeamScoreListener
    implements IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>> {
        public TeamScoreListener(IWorldView worldView) {
            worldView.addObjectListener(TeamScore.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(WorldObjectUpdatedEvent<TeamScore> event) {
            Map<Integer, TeamScore> map = Game.this.lastTeamScore;
            synchronized (map) {
                Game.this.lastTeamScore.put(((TeamScore)event.getObject()).getTeam(), (TeamScore)event.getObject());
            }
        }
    }

    private class PlayerScoreListener
    implements IWorldEventListener<PlayerScore> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(PlayerScore event) {
            Map<UnrealId, PlayerScore> map = Game.this.lastPlayerScore;
            synchronized (map) {
                Game.this.lastPlayerScore.put(event.getId(), event);
            }
        }

        public PlayerScoreListener(IWorldView worldView) {
            worldView.addEventListener(PlayerScore.class, (IWorldEventListener)this);
        }
    }

    private class FlagInfoObjectListener
    implements IWorldObjectEventListener<FlagInfo, WorldObjectUpdatedEvent<FlagInfo>> {
        public void notify(WorldObjectUpdatedEvent<FlagInfo> event) {
            Game.this.allCTFFlags.put(((FlagInfo)event.getObject()).getTeam(), (FlagInfo)event.getObject());
        }

        public FlagInfoObjectListener(IWorldView worldView) {
            worldView.addObjectListener(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }
    }

    private class MutatorListObtainedListener
    implements IWorldEventListener<MutatorListObtained> {
        public void notify(MutatorListObtained event) {
            Game.this.lastMutatorListObtained = event;
        }

        public MutatorListObtainedListener(IWorldView worldView) {
            worldView.addEventListener(MutatorListObtained.class, (IWorldEventListener)this);
        }
    }

    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        public void notify(BeginMessage event) {
            Game.this.lastBeginMessage = event;
        }

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
        }
    }

    private class InitedMessageListener
    implements IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> {
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            Game.this.lastInitedMessage = (InitedMessage)event.getObject();
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }
    }

    private class GameInfoListener
    implements IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> {
        public void notify(IWorldObjectEvent<GameInfo> event) {
            Game.this.lastGameInfo = (GameInfo)event.getObject();
            Game.this.mapNameLowerChar = Game.this.lastGameInfo.getLevel().toLowerCase();
        }

        public GameInfoListener(IWorldView worldView) {
            worldView.addObjectListener(GameInfo.class, (IWorldObjectEventListener)this);
        }
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            Game.this.self = (Self)event.getObject();
        }
    }

    public static enum GameType {
        BotDeathMatch,
        BotTeamGame,
        BotCTFGame,
        BotBombingRun,
        BotDoubleDomination,
        Unknown;


        public static GameType getType(String type) {
            if (type.equalsIgnoreCase("BotDeathMatch")) {
                return BotDeathMatch;
            }
            if (type.equalsIgnoreCase("BotTeamGame")) {
                return BotTeamGame;
            }
            if (type.equalsIgnoreCase("BotCTFGame")) {
                return BotCTFGame;
            }
            if (type.equalsIgnoreCase("BotBombingRun")) {
                return BotBombingRun;
            }
            if (type.equalsIgnoreCase("BotDoubleDomination")) {
                return BotDoubleDomination;
            }
            return Unknown;
        }
    }
}

