/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.NavigationState;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004Navigation
implements IUT2004Navigation {
    public static double EXTEND_PATH_THRESHOLD = 500.0;
    protected LogCategory log;
    protected IUT2004PathExecutor<ILocated> pathExecutor;
    protected IPathPlanner<NavPoint> pathPlanner;
    protected UT2004Bot bot;
    protected IUT2004GetBackToNavGraph getBackToNavGraph;
    protected IUT2004RunStraight runStraight;
    protected double extendPathThreshold;
    protected static final int NEW_PATH_DISTANCE_THRESHOLD = 40;
    protected static final int ARRIVED_AT_LOCATION_XY_THRESHOLD = 50;
    protected static final int ARRIVED_AT_LOCATION_Z_THRESHOLD = 100;
    protected static final double PLAYER_DISTANCE_TRASHOLD = 600.0;
    public static final double AT_PLAYER = 100.0;
    protected Flag<NavigationState> state = new Flag((Object)NavigationState.STOPPED);
    FlagListener<IPathExecutorState> myUT2004PathExecutorStateListener = new FlagListener<IPathExecutorState>(){

        public void flagChanged(IPathExecutorState changedValue) {
            switch (changedValue.getState()) {
                case TARGET_REACHED: {
                    UT2004Navigation.this.targetReached();
                    break;
                }
                case PATH_COMPUTATION_FAILED: {
                    UT2004Navigation.this.noPath();
                    break;
                }
                case STUCK: {
                    if (UT2004Navigation.this.log != null && UT2004Navigation.this.log.isLoggable(Level.WARNING)) {
                        UT2004Navigation.this.log.warning("UT2004Navigation:stuck(). Path executor reported stuck!");
                    }
                    UT2004Navigation.this.stuck();
                }
            }
        }
    };
    protected IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004Navigation.this.navigate();
        }
    };
    protected IWorldEventListener<BotKilled> botKilledMessageListener = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            UT2004Navigation.this.reset(true, NavigationState.STOPPED);
        }
    };
    protected ILocated lastTarget = null;
    protected Player lastTargetPlayer = null;
    protected ILocated currentTarget = null;
    protected Player currentTargetPlayer = null;
    protected NavPoint fromNavPoint;
    protected NavPoint toNavPoint;
    protected IPathFuture currentPathFuture;
    protected boolean navigating = false;
    protected boolean runningStraightToPlayer = false;
    protected Location runningStraightToPlayerFailedAt = null;
    protected boolean usingGetBackToNavGraph = false;
    protected ILocated continueTo;
    protected IPathFuture<NavPoint> continueToPath;

    public UT2004Navigation(UT2004Bot bot, IUT2004PathExecutor ut2004PathExecutor, IPathPlanner<NavPoint> pathPlanner, IUT2004GetBackToNavGraph getBackOnPath, IUT2004RunStraight runStraight) {
        this(bot, ut2004PathExecutor, pathPlanner, getBackOnPath, runStraight, EXTEND_PATH_THRESHOLD);
    }

    public UT2004Navigation(UT2004Bot bot, IUT2004PathExecutor ut2004PathExecutor, IPathPlanner<NavPoint> pathPlanner, IUT2004GetBackToNavGraph getBackOnPath, IUT2004RunStraight runStraight, double extendPathThreshold) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.pathPlanner = pathPlanner;
        this.pathExecutor = ut2004PathExecutor;
        this.getBackToNavGraph = getBackOnPath;
        this.runStraight = runStraight;
        this.extendPathThreshold = extendPathThreshold;
        this.initListeners();
    }

    public UT2004Navigation(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.pathPlanner = new FloydWarshallMap((IGhostAgent)bot);
        this.pathExecutor = new UT2004PathExecutor<ILocated>(bot, new LoqueNavigator(bot, (Logger)bot.getLog()));
        this.pathExecutor.addStuckDetector(new UT2004TimeStuckDetector(bot, 3000.0, 100000.0));
        this.pathExecutor.addStuckDetector(new UT2004PositionStuckDetector(bot));
        this.pathExecutor.addStuckDetector(new UT2004DistanceStuckDetector(bot));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph(bot, info, move);
        this.runStraight = new UT2004RunStraight(bot, info, move);
        this.initListeners();
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    private void initListeners() {
        this.pathExecutor.getState().addListener(this.myUT2004PathExecutorStateListener);
        this.bot.getWorldView().addEventListener(EndMessage.class, this.endMessageListener);
        this.bot.getWorldView().addEventListener(BotKilled.class, this.botKilledMessageListener);
    }

    @Override
    public void addStrongNavigationListener(FlagListener<NavigationState> listener) {
        this.state.addStrongListener(listener);
    }

    @Override
    public void removeStrongNavigationListener(FlagListener<NavigationState> listener) {
        this.state.removeListener(listener);
    }

    @Override
    public IUT2004PathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    @Override
    public IUT2004GetBackToNavGraph getBackToNavGraph() {
        return this.getBackToNavGraph;
    }

    @Override
    public IUT2004RunStraight getRunStraight() {
        return this.runStraight;
    }

    @Override
    public boolean isNavigating() {
        return this.navigating;
    }

    @Override
    public boolean isNavigatingToNavPoint() {
        return this.isNavigating() && this.getCurrentTarget() instanceof NavPoint;
    }

    @Override
    public boolean isNavigatingToItem() {
        return this.isNavigating() && this.getCurrentTarget() instanceof Item;
    }

    @Override
    public boolean isNavigatingToPlayer() {
        return this.isNavigating() && this.getCurrentTarget() instanceof Player;
    }

    @Override
    public boolean isTryingToGetBackToNav() {
        return this.getBackToNavGraph.isExecuting();
    }

    @Override
    public boolean isPathExecuting() {
        return this.pathExecutor.isExecuting();
    }

    @Override
    public boolean isRunningStraight() {
        return this.runStraight.isExecuting();
    }

    @Override
    public void setFocus(ILocated located) {
        this.pathExecutor.setFocus(located);
        this.getBackToNavGraph.setFocus(located);
        this.runStraight.setFocus(located);
    }

    @Override
    public void stopNavigation() {
        this.reset(true, NavigationState.STOPPED);
        this.bot.getAct().act((CommandMessage)new Stop());
    }

    @Override
    public void navigate(ILocated target) {
        if (target == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Cannot navigate to NULL target!");
            }
            this.reset(true, NavigationState.STOPPED);
            return;
        }
        if (target instanceof Player) {
            this.navigate((Player)target);
            return;
        }
        if (this.navigating) {
            if (this.currentTarget == target || this.currentTarget.getLocation().equals((Object)target.getLocation())) {
                return;
            }
            this.reset(false, null);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Start navigating to: " + target);
        }
        this.navigating = true;
        this.switchState(NavigationState.NAVIGATING);
        this.currentTarget = target;
        this.navigate();
    }

    @Override
    public void navigate(Player player) {
        if (player == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Cannot navigate to NULL player!");
            }
            return;
        }
        if (this.navigating) {
            if (this.currentTarget == player) {
                return;
            }
            this.reset(false, null);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Start pursuing: " + player);
        }
        this.navigating = true;
        this.switchState(NavigationState.NAVIGATING);
        this.currentTarget = player.getLocation();
        this.currentTargetPlayer = player;
        this.navigate();
    }

    @Override
    public void navigate(IPathFuture<ILocated> pathHandle) {
        if (pathHandle == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Cannot navigate to NULL pathHandle!");
            }
            return;
        }
        if (this.navigating) {
            if (this.currentPathFuture == pathHandle) {
                return;
            }
            this.reset(false, null);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Start running along the path to target: " + pathHandle.getPathTo());
        }
        this.navigating = true;
        this.switchState(NavigationState.NAVIGATING);
        this.currentTarget = (ILocated)pathHandle.getPathTo();
        this.currentPathFuture = pathHandle;
        this.navigate();
    }

    @Override
    public NavPoint getNearestNavPoint(ILocated location) {
        if (location == null) {
            return null;
        }
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        if (location instanceof Item && ((Item)location).getNavPoint() != null) {
            return ((Item)location).getNavPoint();
        }
        return (NavPoint)DistanceUtils.getNearest(this.bot.getWorldView().getAll(NavPoint.class).values(), (ILocated)location);
    }

    @Override
    public ILocated getContinueTo() {
        return this.continueTo;
    }

    @Override
    public void setContinueTo(ILocated continueTo) {
        if (!this.isNavigating()) {
            this.log.warning("Cannot continueTo(" + continueTo + ") as navigation is not navigating!");
            return;
        }
        if (this.isNavigatingToPlayer()) {
            this.log.warning("Cannot continueTo(" + continueTo + ") as we're navigating to player!");
            return;
        }
        this.continueTo = continueTo;
        NavPoint from = this.getNearestNavPoint(this.currentTarget);
        NavPoint to = this.getNearestNavPoint(continueTo);
        this.continueToPath = this.pathPlanner.computePath((Object)from, (Object)to);
        this.checkExtendPath();
    }

    @Override
    public List<ILocated> getCurrentPathCopy() {
        ArrayList<ILocated> result = new ArrayList<ILocated>();
        if (this.currentPathFuture != null) {
            result.addAll(this.currentPathFuture.get());
        }
        return result;
    }

    @Override
    public List<ILocated> getCurrentPathDirect() {
        if (this.currentPathFuture != null) {
            return this.currentPathFuture.get();
        }
        return null;
    }

    @Override
    public ILocated getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public Player getCurrentTargetPlayer() {
        return this.currentTargetPlayer;
    }

    @Override
    public Item getCurrentTargetItem() {
        if (this.currentTarget instanceof Item) {
            return (Item)this.currentTarget;
        }
        return null;
    }

    @Override
    public NavPoint getCurrentTargetNavPoint() {
        if (this.currentTarget instanceof NavPoint) {
            return (NavPoint)this.currentTarget;
        }
        return null;
    }

    @Override
    public ILocated getLastTarget() {
        return this.lastTarget;
    }

    @Override
    public Player getLastTargetPlayer() {
        return this.lastTargetPlayer;
    }

    @Override
    public Item getLastTargetItem() {
        if (this.lastTarget instanceof Item) {
            return (Item)this.lastTarget;
        }
        return null;
    }

    @Override
    public double getRemainingDistance() {
        NavPoint to;
        if (!this.isNavigating()) {
            return 0.0;
        }
        if (this.isNavigatingToPlayer()) {
            NavPoint to2;
            if (this.isPathExecuting()) {
                return this.pathExecutor.getRemainingDistance() + ((ILocated)this.pathExecutor.getPathTo()).getLocation().getDistance(this.currentTargetPlayer.getLocation());
            }
            NavPoint from = this.getNearestNavPoint((ILocated)this.bot.getLocation());
            IPathFuture pathFuture = this.pathPlanner.computePath((Object)from, (Object)(to2 = this.getNearestNavPoint((ILocated)this.currentTargetPlayer.getLocation())));
            if (pathFuture.isDone()) {
                return this.bot.getLocation().getDistance(from.getLocation()) + this.getPathDistance(pathFuture.get()) + to2.getLocation().getDistance(this.currentTargetPlayer.getLocation());
            }
            return -1.0;
        }
        if (this.isPathExecuting()) {
            return this.pathExecutor.getRemainingDistance();
        }
        NavPoint from = this.getNearestNavPoint((ILocated)this.bot.getLocation());
        IPathFuture pathFuture = this.pathPlanner.computePath((Object)from, (Object)(to = this.getNearestNavPoint((ILocated)this.currentTarget.getLocation())));
        if (pathFuture.isDone()) {
            return this.bot.getLocation().getDistance(from.getLocation()) + this.getPathDistance(pathFuture.get()) + to.getLocation().getDistance(this.currentTarget.getLocation());
        }
        return -1.0;
    }

    private double getPathDistance(List<NavPoint> list) {
        if (list == null || list.size() <= 0) {
            return 0.0;
        }
        double distance = 0.0;
        NavPoint curr = list.get(0);
        int i = 1;
        while (i < list.size()) {
            NavPoint next = list.get(i);
            distance += curr.getLocation().getDistance(next.getLocation());
            curr = next;
            ++i;
        }
        return distance;
    }

    protected void navigate() {
        if (!this.navigating) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("NAVIGATING");
        }
        if (this.currentTargetPlayer != null) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Pursuing " + this.currentTargetPlayer);
            }
            this.navigatePlayer();
        } else {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigating to " + this.currentTarget);
            }
            this.navigateLocation();
        }
    }

    private void navigateLocation() {
        if (this.isPathExecuting()) {
            this.checkExtendPath();
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Path executor running");
            }
            return;
        }
        if (!this.getBackToNavGraph.isOnNavGraph()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Getting back to navigation graph");
            }
            if (this.getBackToNavGraph.isExecuting()) {
                return;
            }
            if (this.usingGetBackToNavGraph) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("UT2004Navigation:stuck(). GetBackToNavGraph was already called && stopped && we're still not on nav graph.");
                }
                this.stuck();
                return;
            }
            this.getBackToNavGraph.backToNavGraph();
            this.usingGetBackToNavGraph = true;
            return;
        }
        this.usingGetBackToNavGraph = false;
        if (this.currentPathFuture == null) {
            this.fromNavPoint = this.getNearestNavPoint((ILocated)this.bot.getLocation());
            this.toNavPoint = this.getNearestNavPoint(this.currentTarget);
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Computing path from " + this.fromNavPoint.getId().getStringId() + " to " + this.toNavPoint.getId().getStringId());
            }
            this.currentPathFuture = this.pathPlanner.computePath((Object)this.fromNavPoint, (Object)this.toNavPoint);
        }
        switch (this.currentPathFuture.getStatus()) {
            case FUTURE_IS_READY: {
                break;
            }
            case FUTURE_IS_BEING_COMPUTED: {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Waiting for the path to be computed...");
                }
                return;
            }
            case CANCELED: {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Path computation has been canceled.");
                }
                this.noPath();
                return;
            }
            case COMPUTATION_EXCEPTION: {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Path computation has failed with an exception.");
                }
                this.noPath();
                return;
            }
        }
        if (!this.processPathFuture(this.currentPathFuture, this.currentTarget)) {
            this.noPath();
            return;
        }
        this.pathExecutor.followPath(this.currentPathFuture);
    }

    private void checkExtendPath() {
        double remainingDistance;
        if (this.continueTo == null) {
            return;
        }
        if (this.continueToPath == null) {
            this.log.severe("continueTo specified, but continueToPath is NULL!");
            return;
        }
        if (this.isNavigatingToPlayer()) {
            this.log.warning("continueTo specified, but navigating to Player, INVALID!");
            return;
        }
        if (this.isPathExecuting() && (remainingDistance = this.getRemainingDistance()) < this.extendPathThreshold) {
            if (!this.continueToPath.isDone()) {
                this.log.warning("Should extend path, remainingDistance = " + remainingDistance + " < " + this.extendPathThreshold + " = extendPathThreshold, but continueToPath.isDone() == false, cannot extend path!");
                return;
            }
            this.log.info("Extending path to continue to " + this.continueTo);
            this.pathExecutor.extendPath(this.continueToPath.get());
            this.currentPathFuture = this.pathExecutor.getPathFuture();
            this.lastTarget = this.currentTarget;
            this.currentTarget = this.continueTo;
            this.fromNavPoint = this.getNearestNavPoint((ILocated)((ILocated)this.currentPathFuture.get().get(0)).getLocation());
            this.toNavPoint = this.getNearestNavPoint((ILocated)((ILocated)this.currentPathFuture.get().get(this.currentPathFuture.get().size() - 1)).getLocation());
            this.continueTo = null;
            this.continueToPath = null;
        }
    }

    private void navigatePlayer() {
        double vDistance = this.bot.getLocation().getDistanceZ(this.currentTargetPlayer.getLocation());
        double hDistance = this.bot.getLocation().getDistance2D(this.currentTargetPlayer.getLocation());
        if (hDistance < 100.0 && vDistance < 50.0) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Player reached");
            }
            if (this.pathExecutor.isExecuting()) {
                this.pathExecutor.getPath().set(this.pathExecutor.getPath().size() - 1, this.bot.getLocation());
            } else {
                this.targetReached();
            }
            return;
        }
        if (hDistance < 400.0 && Math.abs(vDistance) < 50.0) {
            if (this.runningStraightToPlayer) {
                if (this.runStraight.isFailed()) {
                    this.runningStraightToPlayer = false;
                    this.runningStraightToPlayerFailedAt = this.bot.getLocation();
                }
            } else if (this.runningStraightToPlayerFailedAt == null || this.bot.getLocation().getDistance(this.runningStraightToPlayerFailedAt) > 500.0) {
                if (this.getBackToNavGraph.isExecuting()) {
                    this.getBackToNavGraph.stop();
                    this.usingGetBackToNavGraph = false;
                }
                if (this.pathExecutor.isExecuting()) {
                    this.pathExecutor.stop();
                }
                this.runningStraightToPlayer = true;
                this.runningStraightToPlayerFailedAt = null;
                this.runStraight.runStraight(this.currentTargetPlayer);
            }
            if (this.runningStraightToPlayer) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Running straight to player");
                }
                return;
            }
        } else if (this.runningStraightToPlayer) {
            this.runningStraightToPlayer = false;
            this.runStraight.stop(false);
        }
        if (this.pathExecutor.isExecuting()) {
            NavPoint newToNavPoint;
            double distance;
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Path executor running");
            }
            if ((distance = this.currentTarget.getLocation().getDistance(this.currentTargetPlayer.getLocation())) < 600.0) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Player moved " + distance + " from its original location, checking path...");
            }
            if ((newToNavPoint = this.getNearestNavPoint(this.currentTargetPlayer)) != this.toNavPoint) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Replanning path to get to " + this.currentTargetPlayer);
                }
                this.pathExecutor.stop();
                this.currentPathFuture = null;
            } else {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Path remains the same");
                }
                return;
            }
        }
        if (!this.getBackToNavGraph.isOnNavGraph()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Getting back to navigation graph");
            }
            if (this.getBackToNavGraph.isExecuting()) {
                return;
            }
            if (this.usingGetBackToNavGraph) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("UT2004Navigation:stuck(). GetBackToNavGraph was already called && stopped && we're still not on nav graph.");
                }
                this.stuck();
                return;
            }
            this.getBackToNavGraph.backToNavGraph();
            this.usingGetBackToNavGraph = true;
            return;
        }
        this.usingGetBackToNavGraph = false;
        if (this.currentPathFuture == null) {
            this.fromNavPoint = this.getNearestNavPoint((ILocated)this.bot.getLocation());
            this.toNavPoint = this.getNearestNavPoint(this.currentTarget);
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Computing path from " + this.fromNavPoint.getId().getStringId() + " to " + this.toNavPoint.getId().getStringId());
            }
            this.currentPathFuture = this.pathPlanner.computePath((Object)this.fromNavPoint, (Object)this.toNavPoint);
        }
        switch (this.currentPathFuture.getStatus()) {
            case FUTURE_IS_READY: {
                break;
            }
            case FUTURE_IS_BEING_COMPUTED: {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Waiting for the path to be computed...");
                }
                return;
            }
            case CANCELED: {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Path computation has been canceled.");
                }
                this.noPath();
                return;
            }
            case COMPUTATION_EXCEPTION: {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Path computation has failed with an exception.");
                }
                this.noPath();
                return;
            }
        }
        if (!this.processPathFuture(this.currentPathFuture, this.currentTarget)) {
            this.noPath();
            return;
        }
        this.pathExecutor.followPath(this.currentPathFuture);
    }

    protected boolean processPathFuture(IPathFuture futurePath, ILocated currentTarget) {
        List pathList = futurePath.get();
        if (pathList == null) {
            return false;
        }
        if (currentTarget == null) {
            if (pathList.size() == 0) {
                return false;
            }
            currentTarget = (ILocated)pathList.get(pathList.size() - 1);
        } else if (pathList.size() == 0) {
            this.currentPathFuture.get().add(currentTarget);
        } else {
            ILocated lastPathElement = (ILocated)pathList.get(pathList.size() - 1);
            if (lastPathElement.getLocation().getDistance(currentTarget.getLocation()) > 40.0) {
                this.currentPathFuture.get().add(currentTarget);
            }
        }
        return true;
    }

    protected void switchState(NavigationState newState) {
        this.state.setFlag((Object)newState);
    }

    protected void noPath() {
        this.reset(true, NavigationState.PATH_COMPUTATION_FAILED);
    }

    protected void stuck() {
        this.reset(true, NavigationState.STUCK);
    }

    protected void targetReached() {
        this.reset(true, NavigationState.TARGET_REACHED);
    }

    protected void reset(boolean stopGetBackToNavGraph, NavigationState resultState) {
        if (this.currentTarget != null) {
            this.lastTarget = this.currentTarget;
            this.lastTargetPlayer = this.currentTargetPlayer;
        }
        this.navigating = false;
        this.currentTarget = null;
        this.currentTargetPlayer = null;
        this.fromNavPoint = null;
        this.toNavPoint = null;
        this.currentPathFuture = null;
        this.runningStraightToPlayer = false;
        this.runningStraightToPlayerFailedAt = null;
        this.continueTo = null;
        this.continueToPath = null;
        this.pathExecutor.stop();
        this.runStraight.stop(false);
        if (stopGetBackToNavGraph) {
            this.getBackToNavGraph.stop();
            this.usingGetBackToNavGraph = false;
        }
        if (resultState == null) {
            return;
        }
        this.switchState(resultState);
    }

    @Override
    public Flag<NavigationState> getState() {
        return this.state.getImmutable();
    }
}

