/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.impl.PathFuture;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathTimeoutException;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetPath;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.Path;
import cz.cuni.amis.utils.future.FutureStatus;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UT2004AStarPathFuture
extends PathFuture<ILocated> {
    private static final int PATH_TIMEOUT = 10;
    private static Object idMutex = new Object();
    private static long lastId = 0L;
    private String pathId;
    private EventReactOnce<Path> pathReaction;
    private EventReact<EndMessage> endReaction;
    private IVisionWorldView worldView;
    private Logger log;
    private Double startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UT2004AStarPathFuture(UT2004Bot bot, ILocated pathFrom, ILocated pathTo) {
        super((Object)pathFrom, (Object)pathTo, bot.getEventBus(), new IComponent[]{bot.getWorldView()});
        this.log = bot.getLogger().getCategory(((Object)((Object)this)).getClass().getSimpleName());
        Object object = idMutex;
        synchronized (object) {
            this.pathId = "UT2004AStarPathFuture_" + ++lastId;
        }
        this.pathReaction = new EventReactOnce<Path>(Path.class, bot.getWorldView()){

            protected void react(Path event) {
                if (UT2004AStarPathFuture.this.pathId.equals(event.getPathId())) {
                    UT2004AStarPathFuture.this.eventPath(event);
                }
            }
        };
        this.endReaction = new EventReact<EndMessage>(EndMessage.class, bot.getWorldView()){

            protected void react(EndMessage event) {
                UT2004AStarPathFuture.this.eventEndMessage(event);
            }
        };
        this.log.finer("Requesting path from '" + pathFrom + "' to '" + pathTo + "' under id '" + this.pathId + "'.");
        bot.getAct().act((CommandMessage)new GetPath().setLocation(pathTo.getLocation()).setId(this.pathId));
        this.log.fine("Path requested, listening for the result (timeout 10s)");
        this.worldView = bot.getWorldView();
    }

    protected boolean cancelComputation(boolean mayInterruptIfRunning) {
        this.pathReaction.disable();
        this.endReaction.disable();
        return this.getStatus() == FutureStatus.FUTURE_IS_BEING_COMPUTED;
    }

    protected void eventEndMessage(EndMessage event) {
        if (this.startTime == null) {
            this.startTime = event.getTime();
        }
        if (event.getTime() - this.startTime > 10.0) {
            this.pathReaction.disable();
            this.endReaction.disable();
            if (this.getStatus() == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                this.computationException((Exception)((Object)new UT2004AStarPathTimeoutException("Path did not came from GB2004 in 10s.", this.log, (Object)this)));
            }
        }
    }

    protected void eventPath(Path event) {
        NavPoint lastNav;
        Item pathToItem;
        NavPoint pathToNav;
        this.endReaction.disable();
        ArrayList<Object> result = new ArrayList<Object>(event.getPath().size());
        Object last = null;
        int i = 0;
        while (i < event.getPath().size()) {
            UnrealId routeId = event.getPath().get(i).getRouteId();
            NavPoint nav = (NavPoint)this.worldView.get((WorldObjectId)routeId);
            if (nav == null) {
                last = event.getPath().get(i).getLocation();
                result.add(last);
            } else {
                last = nav;
                result.add(last);
            }
            ++i;
        }
        if (last != null) {
            double distance = ((ILocated)this.getPathTo()).getLocation().getDistance(last.getLocation());
            if (distance < 40.0) {
                this.setResult(result);
                return;
            }
        } else {
            last = ((Self)this.worldView.getSingle(Self.class)).getLocation();
            double distance = ((ILocated)this.getPathTo()).getLocation().getDistance(last.getLocation());
        }
        double distance2D = ((ILocated)this.getPathTo()).getLocation().getDistance2D(last.getLocation());
        double distanceZ = ((ILocated)this.getPathTo()).getLocation().getDistanceZ(last.getLocation());
        ILocated pathTo = (ILocated)this.getPathTo();
        NavPoint navPoint = pathToNav = pathTo instanceof NavPoint ? (NavPoint)this.getPathTo() : (NavPoint)DistanceUtils.getNearest(this.worldView.getAll(NavPoint.class).values(), (ILocated)pathTo, (double)20.0);
        if (pathToNav == null && (pathToItem = (Item)DistanceUtils.getNearest(this.worldView.getAll(Item.class).values(), (ILocated)pathTo, (double)20.0)) != null) {
            pathToNav = pathToItem.getNavPoint();
        }
        NavPoint navPoint2 = lastNav = last instanceof NavPoint ? (NavPoint)last : (NavPoint)DistanceUtils.getNearest(this.worldView.getAll(NavPoint.class).values(), (ILocated)last, (double)20.0);
        if (pathToNav != null && lastNav != null) {
            NavPointNeighbourLink link = lastNav.getOutgoingEdges().get(pathToNav.getId());
            if (link != null) {
                if (FloydWarshallMap.isWalkable(link.getFlags())) {
                    result.add(pathTo);
                    this.setResult(result);
                    return;
                }
                this.setResult(result);
                return;
            }
            this.setResult(result);
            return;
        }
        if (distance2D < 100.0 && distanceZ < 200.0) {
            result.add(pathTo);
            this.setResult(result);
            return;
        }
        this.setResult(result);
    }
}

