/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model.BitMatrix;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model.VisibilityLocation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.IFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VisibilityMatrix
implements Serializable {
    private static final long serialVersionUID = -5542380797228986422L;
    private Map<Integer, VisibilityLocation> locations = new HashMap<Integer, VisibilityLocation>();
    private BitMatrix matrix;
    private String mapName;
    private transient Object mutex = new Object();
    private transient Map<Integer, Set<VisibilityLocation>> coverPoints = new HashMap<Integer, Set<VisibilityLocation>>();
    private transient Map<Integer, Set<VisibilityLocation>> visiblePoints = new HashMap<Integer, Set<VisibilityLocation>>();
    private transient Map<Integer, Set<NavPoint>> coverNavPoints = new HashMap<Integer, Set<NavPoint>>();
    private transient Map<Integer, Set<NavPoint>> visibleNavPoints = new HashMap<Integer, Set<NavPoint>>();

    protected VisibilityMatrix() {
    }

    public VisibilityMatrix(String mapName, int size) {
        this.mapName = mapName;
        this.matrix = new BitMatrix(size, size);
    }

    public String getMapName() {
        return this.mapName;
    }

    public Map<Integer, VisibilityLocation> getLocations() {
        return this.locations;
    }

    public VisibilityLocation getLocation(int index) {
        return this.locations.get(index);
    }

    public BitMatrix getMatrix() {
        return this.matrix;
    }

    public static String getFileName_All(String mapName) {
        return "VisibilityMatrix-" + mapName + "-All.bin";
    }

    public static File getFile_All(File directory, String mapName) {
        return new File(directory, VisibilityMatrix.getFileName_All(mapName));
    }

    public void save(File directory) {
        try {
            File file1 = VisibilityMatrix.getFile_All(directory, this.mapName);
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(file1));
            try {
                output.writeObject(this);
            }
            finally {
                output.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save VisibilityMatrix.", e);
        }
    }

    public static VisibilityMatrix load(File directory, String mapName) {
        try {
            File file1 = VisibilityMatrix.getFile_All(directory, mapName);
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(file1));
            VisibilityMatrix result = null;
            try {
                result = (VisibilityMatrix)input.readObject();
            }
            finally {
                input.close();
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load VisibilityMatrix.", e);
        }
    }

    public int getPairCount() {
        return this.locations.size() * (this.locations.size() - 1) / 2;
    }

    public int getVisiblePairCount() {
        int count = 0;
        int i = 0;
        while (i < this.locations.size()) {
            int j = i + 1;
            while (j < this.locations.size()) {
                if (this.matrix.get(i, j)) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    private Object readResolve() throws ObjectStreamException {
        this.mutex = new Object();
        this.coverPoints = new HashMap<Integer, Set<VisibilityLocation>>();
        this.visiblePoints = new HashMap<Integer, Set<VisibilityLocation>>();
        this.coverNavPoints = new HashMap<Integer, Set<NavPoint>>();
        this.visibleNavPoints = new HashMap<Integer, Set<NavPoint>>();
        return this;
    }

    public Set<VisibilityLocation> getVisiblePoints(BitSet column) {
        if (column == null) {
            return null;
        }
        HashSet<VisibilityLocation> result = new HashSet<VisibilityLocation>();
        int i = 0;
        while (i < column.length() && i < this.matrix.rows()) {
            if (column.get(i)) {
                result.add(this.locations.get(i));
            }
            ++i;
        }
        return result;
    }

    public Set<NavPoint> getVisibleNavPoints(BitSet column) {
        if (column == null) {
            return null;
        }
        HashSet<NavPoint> result = new HashSet<NavPoint>();
        int i = 0;
        while (i < column.length() && i < this.matrix.rows()) {
            if (column.get(i)) {
                VisibilityLocation vLoc = this.locations.get(i);
                if (vLoc.navPoint != null) {
                    result.add(vLoc.navPoint);
                }
            }
            ++i;
        }
        return result;
    }

    public Set<NavPoint> getNavPoints(Collection<VisibilityLocation> visibilityLocations) {
        HashSet<NavPoint> result = new HashSet<NavPoint>();
        for (VisibilityLocation vLoc : visibilityLocations) {
            if (vLoc.navPoint == null) continue;
            result.add(vLoc.navPoint);
        }
        return result;
    }

    public Set<VisibilityLocation> getCoverPoints(BitSet column) {
        HashSet<VisibilityLocation> result = new HashSet<VisibilityLocation>();
        int i = 0;
        while (i < column.length() && i < this.matrix.rows()) {
            if (!column.get(i)) {
                result.add(this.locations.get(i));
            }
            ++i;
        }
        return result;
    }

    public Set<NavPoint> getCoverNavPoints(BitSet column) {
        HashSet<NavPoint> result = new HashSet<NavPoint>();
        int i = 0;
        while (i < column.length() && i < this.matrix.rows()) {
            if (!column.get(i)) {
                VisibilityLocation vLoc = this.locations.get(i);
                if (vLoc.navPoint != null) {
                    result.add(vLoc.navPoint);
                }
            }
            ++i;
        }
        return result;
    }

    public Map.Entry<Integer, VisibilityLocation> getNearestEntry(ILocated located) {
        if (located == null) {
            return null;
        }
        Location location = located.getLocation();
        double minDistance = Double.MAX_VALUE;
        Map.Entry<Integer, VisibilityLocation> nearest = null;
        for (Map.Entry<Integer, VisibilityLocation> entry : this.locations.entrySet()) {
            double distance = location.getDistance(entry.getValue().getLocation());
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearest = entry;
        }
        return nearest;
    }

    public VisibilityLocation getNearest(ILocated located) {
        if (located == null) {
            return null;
        }
        Map.Entry<Integer, VisibilityLocation> nearest = this.getNearestEntry(located);
        if (nearest == null) {
            return null;
        }
        return nearest.getValue();
    }

    public NavPoint getNearestNavPoint(ILocated located) {
        if (located == null) {
            return null;
        }
        VisibilityLocation nearest = (VisibilityLocation)DistanceUtils.getNearestFiltered(this.locations.values(), (ILocated)located, (IFilter)new IFilter<VisibilityLocation>(){

            public boolean isAccepted(VisibilityLocation object) {
                return object.navPoint != null;
            }
        });
        if (nearest == null) {
            return null;
        }
        return nearest.navPoint;
    }

    public Integer getNearestIndex(ILocated located) {
        if (located == null) {
            return null;
        }
        Map.Entry<Integer, VisibilityLocation> nearest = this.getNearestEntry(located);
        if (nearest == null) {
            return null;
        }
        return nearest.getKey();
    }

    public boolean isVisible(ILocated loc1, ILocated loc2) {
        if (loc1 == null) {
            return false;
        }
        if (loc2 == null) {
            return false;
        }
        Integer index1 = this.getNearestIndex(loc1);
        if (index1 == null) {
            return false;
        }
        Integer index2 = this.getNearestIndex(loc2);
        if (index2 == null) {
            return false;
        }
        return this.matrix.get(index1, index2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VisibilityLocation> getCoverPoints(ILocated loc) {
        if (loc == null) {
            return new HashSet<VisibilityLocation>();
        }
        Map.Entry<Integer, VisibilityLocation> vLocEntry = this.getNearestEntry(loc);
        if (vLocEntry == null) {
            return null;
        }
        int key = vLocEntry.getKey();
        VisibilityLocation vLoc = vLocEntry.getValue();
        Set<VisibilityLocation> result = this.coverPoints.get(key);
        if (result != null) {
            return result;
        }
        Object object = this.mutex;
        synchronized (object) {
            result = this.coverPoints.get(key);
            if (result != null) {
                return result;
            }
            BitSet visibility = this.matrix.getColumn(key);
            result = this.getCoverPoints(visibility);
            this.coverPoints.put(key, result);
            return result;
        }
    }

    public VisibilityLocation getNearestCoverPoint(ILocated loc) {
        return (VisibilityLocation)DistanceUtils.getNearest(this.getCoverPoints(loc), (ILocated)loc);
    }

    public VisibilityLocation getNearestCoverPoint(ILocated target, ILocated from) {
        return (VisibilityLocation)DistanceUtils.getNearest(this.getCoverPoints(from), (ILocated)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VisibilityLocation> getVisiblePoints(ILocated loc) {
        if (loc == null) {
            return new HashSet<VisibilityLocation>();
        }
        Map.Entry<Integer, VisibilityLocation> vLocEntry = this.getNearestEntry(loc);
        if (vLocEntry == null) {
            return null;
        }
        int key = vLocEntry.getKey();
        VisibilityLocation vLoc = vLocEntry.getValue();
        Set<VisibilityLocation> result = this.visiblePoints.get(key);
        if (result != null) {
            return result;
        }
        Object object = this.mutex;
        synchronized (object) {
            result = this.coverPoints.get(key);
            if (result != null) {
                return result;
            }
            BitSet visibility = this.matrix.getColumn(key);
            result = this.getVisiblePoints(visibility);
            this.visiblePoints.put(key, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NavPoint> getCoverNavPoints(ILocated loc) {
        if (loc == null) {
            return new HashSet<NavPoint>();
        }
        Map.Entry<Integer, VisibilityLocation> vLocEntry = this.getNearestEntry(loc);
        if (vLocEntry == null) {
            return null;
        }
        int key = vLocEntry.getKey();
        VisibilityLocation vLoc = vLocEntry.getValue();
        Set<NavPoint> result = this.coverNavPoints.get(key);
        if (result != null) {
            return result;
        }
        Object object = this.mutex;
        synchronized (object) {
            result = this.coverNavPoints.get(key);
            if (result != null) {
                return result;
            }
            BitSet visibility = this.matrix.getColumn(key);
            result = this.getCoverNavPoints(visibility);
            this.coverNavPoints.put(key, result);
            return result;
        }
    }

    public NavPoint getNearestCoverNavPoint(ILocated loc) {
        return (NavPoint)DistanceUtils.getNearest(this.getCoverNavPoints(loc), (ILocated)loc);
    }

    public NavPoint getNearestCoverNavPoint(ILocated target, ILocated loc) {
        return (NavPoint)DistanceUtils.getNearest(this.getCoverNavPoints(loc), (ILocated)loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NavPoint> getVisibleNavPoints(ILocated loc) {
        if (loc == null) {
            return new HashSet<NavPoint>();
        }
        Map.Entry<Integer, VisibilityLocation> vLocEntry = this.getNearestEntry(loc);
        if (vLocEntry == null) {
            return null;
        }
        int key = vLocEntry.getKey();
        VisibilityLocation vLoc = vLocEntry.getValue();
        Set<NavPoint> result = this.visibleNavPoints.get(key);
        if (result != null) {
            return result;
        }
        Object object = this.mutex;
        synchronized (object) {
            result = this.coverNavPoints.get(key);
            if (result != null) {
                return result;
            }
            BitSet visibility = this.matrix.getColumn(key);
            result = this.getVisibleNavPoints(visibility);
            this.visibleNavPoints.put(key, result);
            return result;
        }
    }

    public Set<Integer> getNearestIndices(ILocated ... locs) {
        if (locs == null) {
            return null;
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        ILocated[] iLocatedArray = locs;
        int n = locs.length;
        int n2 = 0;
        while (n2 < n) {
            ILocated loc = iLocatedArray[n2];
            if (loc != null) {
                Integer key = this.getNearestIndex(loc);
                keys.add(key);
            }
            ++n2;
        }
        return keys;
    }

    public Set<VisibilityLocation> getCoverPointsN(ILocated ... locs) {
        if (locs == null) {
            return null;
        }
        Set<Integer> keys = this.getNearestIndices(locs);
        BitSet covers = this.matrix.or(keys);
        return this.getCoverPoints(covers);
    }

    public VisibilityLocation getNearestCoverPointN(ILocated target, ILocated ... coveredFrom) {
        if (target == null) {
            return null;
        }
        if (coveredFrom == null) {
            return this.getNearest(target);
        }
        return (VisibilityLocation)DistanceUtils.getNearest(this.getCoverPointsN(coveredFrom), (ILocated)target);
    }

    public Set<NavPoint> getCoverNavPointsN(ILocated ... locs) {
        if (locs == null) {
            return null;
        }
        return this.getNavPoints(this.getCoverPointsN(locs));
    }

    public NavPoint getNearestCoverNavPointN(ILocated target, ILocated ... coveredFrom) {
        if (target == null) {
            return null;
        }
        if (coveredFrom == null) {
            return this.getNearestNavPoint(target);
        }
        return (NavPoint)DistanceUtils.getNearest(this.getCoverNavPointsN(coveredFrom), (ILocated)target);
    }
}

