package cz.cuni.amis.pogamut.ut2004.agent.navigation.astar;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

public class UT2004AStarGoalNavPoint extends UT2004AStarGoal {

	private NavPoint goalNavPoint;

	public UT2004AStarGoalNavPoint(NavPoint goalNavPoint) {
		this.goalNavPoint = goalNavPoint;
	}
	
	public NavPoint getGoalNavPoint() {
		return goalNavPoint;
	}

	/**
	 * Using Euclidian distance via {@link Location#getDistance(Location)}. 
	 */
	@Override
	public int getEstimatedDistanceToGoal(NavPoint node) {
		return (int) goalNavPoint.getLocation().getDistance(node.getLocation());
	}

	@Override
	public boolean isGoalReached(NavPoint actualNode) {
		return actualNode.getId().equals(goalNavPoint.getId());
	}

}
