/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.command;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.command.SimpleLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ContinuousMove;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Dodge;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.logging.Logger;

public class AdvancedLocomotion
extends SimpleLocomotion {
    Self self = null;
    private SelfListener selfListener = null;
    private static final double FOCUS_DISTANCE = 3000.0;

    public void moveAlong(ILocated firstLocation, ILocated secondLocation) {
        Move moveAlong = new Move();
        moveAlong.setFirstLocation(firstLocation.getLocation());
        moveAlong.setSecondLocation(secondLocation.getLocation());
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)moveAlong);
    }

    public void moveContinuos() {
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)new ContinuousMove());
    }

    public void strafeRight(double distance, UnrealId focusId) {
        if (this.self == null) {
            this.self = (Self)((UT2004Bot)this.agent).getWorldView().getSingle(Self.class);
        }
        if (this.self != null) {
            Location startLoc = this.self.getLocation();
            Location directionVector = this.self.getRotation().toLocation();
            Location targetVec = directionVector.cross(new Location(0.0, 0.0, 1.0)).getNormalized().scale(-distance);
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Move().setFirstLocation(startLoc.add(targetVec)).setFocusTarget(focusId));
        }
    }

    public void strafeRight(double distance, ILocated focusLocation) {
        if (this.self == null) {
            this.self = (Self)((UT2004Bot)this.agent).getWorldView().getSingle(Self.class);
        }
        if (this.self != null) {
            Location startLoc = this.self.getLocation();
            Location directionVector = this.self.getRotation().toLocation();
            Location targetVec = directionVector.cross(new Location(0.0, 0.0, 1.0)).getNormalized().scale(-distance);
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Move().setFirstLocation(startLoc.add(targetVec)).setFocusLocation(focusLocation.getLocation()));
        }
    }

    public void strafeRight(double distance) {
        if (this.self == null) {
            this.self = (Self)((UT2004Bot)this.agent).getWorldView().getSingle(Self.class);
        }
        if (this.self != null) {
            Location startLoc = this.self.getLocation();
            Location directionVector = this.self.getRotation().toLocation();
            Location targetVec = directionVector.cross(new Location(0.0, 0.0, 1.0)).getNormalized().scale(-distance);
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Move().setFirstLocation(startLoc.add(targetVec)).setFocusLocation(startLoc.add(directionVector.getNormalized().scale(3000.0))));
        }
    }

    public void strafeLeft(double distance, UnrealId focusId) {
        if (this.self == null) {
            this.self = (Self)((UT2004Bot)this.agent).getWorldView().getSingle(Self.class);
        }
        if (this.self != null) {
            Location startLoc = this.self.getLocation();
            Location directionVector = this.self.getRotation().toLocation();
            Location targetVec = directionVector.cross(new Location(0.0, 0.0, 1.0)).getNormalized().scale(distance);
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Move().setFirstLocation(startLoc.add(targetVec)).setFocusTarget(focusId));
        }
    }

    public void strafeLeft(double distance, ILocated focusLocation) {
        if (this.self == null) {
            this.self = (Self)((UT2004Bot)this.agent).getWorldView().getSingle(Self.class);
        }
        if (this.self != null) {
            Location startLoc = this.self.getLocation();
            Location directionVector = this.self.getRotation().toLocation();
            Location targetVec = directionVector.cross(new Location(0.0, 0.0, 1.0)).getNormalized().scale(distance);
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Move().setFirstLocation(startLoc.add(targetVec)).setFocusLocation(focusLocation.getLocation()));
        }
    }

    public void strafeLeft(double distance) {
        if (this.self == null) {
            this.self = (Self)((UT2004Bot)this.agent).getWorldView().getSingle(Self.class);
        }
        if (this.self != null) {
            Location startLoc = this.self.getLocation();
            Location directionVector = this.self.getRotation().toLocation();
            Location targetVec = directionVector.cross(new Location(0.0, 0.0, 1.0)).getNormalized().scale(distance);
            ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Move().setFirstLocation(startLoc.add(targetVec)).setFocusLocation(startLoc.add(directionVector.getNormalized().scale(3000.0))));
        }
    }

    public void strafeTo(ILocated location, ILocated focusLocation) {
        Move move = new Move().setFirstLocation(location.getLocation()).setFocusLocation(focusLocation.getLocation());
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)move);
    }

    public void strafeTo(ILocated location, UnrealId focus) {
        Move move = new Move().setFirstLocation(location.getLocation()).setFocusTarget(focus);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)move);
    }

    public void doubleJump() {
        Jump jump = new Jump();
        jump.setDoubleJump(true);
        jump.setForce(680.0);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)jump);
    }

    public void generalJump(boolean doubleJump, double secondJumpDelay, double jumpZ) {
        Jump jump = new Jump();
        jump.setDoubleJump(doubleJump);
        if (doubleJump) {
            jump.setDelay(secondJumpDelay);
        }
        jump.setForce(jumpZ);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)jump);
    }

    public void doubleJump(double secondJumpDelay, double jumpZ) {
        Jump jump = new Jump();
        jump.setDoubleJump(true);
        jump.setDelay(secondJumpDelay);
        jump.setForce(jumpZ);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)jump);
    }

    public void dodge(Location direction, boolean bDouble) {
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)new Dodge().setDirection(direction).setDouble(bDouble));
    }

    public void dodgeRight(ILocated botPosition, ILocated inFrontOfTheBot) {
        double y;
        if (botPosition == null || inFrontOfTheBot == null) {
            return;
        }
        Location inFront = inFrontOfTheBot.getLocation();
        ILocated bot = botPosition;
        Location direction = new Location(inFront.getLocation().x - bot.getLocation().x, inFront.getLocation().y - bot.getLocation().y, 0.0);
        direction = direction.getNormalized();
        double x = direction.getX();
        direction.x = y = direction.getY();
        direction.y = -x;
        direction.z = 0.0;
        direction = direction.scale(100.0);
        this.dodge(direction, false);
    }

    public void dodgeRight(ILocated botPosition, ILocated inFrontOfTheBot, boolean bDouble) {
        double y;
        if (botPosition == null || inFrontOfTheBot == null) {
            return;
        }
        Location inFront = inFrontOfTheBot.getLocation();
        ILocated bot = botPosition;
        Location direction = new Location(inFront.getLocation().x - bot.getLocation().x, inFront.getLocation().y - bot.getLocation().y, 0.0);
        direction = direction.getNormalized();
        double x = direction.getX();
        direction.x = y = direction.getY();
        direction.y = -x;
        direction.z = 0.0;
        direction = direction.scale(100.0);
        this.dodge(direction, bDouble);
    }

    public void dodgeLeft(ILocated botPosition, ILocated inFrontOfTheBot) {
        if (botPosition == null || inFrontOfTheBot == null) {
            return;
        }
        Location inFront = inFrontOfTheBot.getLocation();
        ILocated bot = botPosition;
        Location direction = new Location(inFront.getLocation().x - bot.getLocation().x, inFront.getLocation().y - bot.getLocation().y, 0.0);
        direction = direction.getNormalized();
        double x = direction.getX();
        double y = direction.getY();
        direction.x = -y;
        direction.y = -x;
        direction.z = 0.0;
        direction = direction.scale(100.0);
        this.dodge(direction, false);
    }

    public void dodgeLeft(ILocated botPosition, ILocated inFrontOfTheBot, boolean bDouble) {
        if (botPosition == null || inFrontOfTheBot == null) {
            return;
        }
        Location inFront = inFrontOfTheBot.getLocation();
        ILocated bot = botPosition;
        Location direction = new Location(inFront.getLocation().x - bot.getLocation().x, inFront.getLocation().y - bot.getLocation().y, 0.0);
        direction = direction.getNormalized();
        double x = direction.getX();
        double y = direction.getY();
        direction.x = -y;
        direction.y = -x;
        direction.z = 0.0;
        direction = direction.scale(100.0);
        this.dodge(direction, bDouble);
    }

    public void dodgeBack(ILocated botPosition, ILocated inFrontOfTheBot) {
        if (botPosition == null || inFrontOfTheBot == null) {
            return;
        }
        Location inFront = inFrontOfTheBot.getLocation();
        ILocated bot = botPosition;
        Location direction = inFront.sub(bot.getLocation());
        direction.z = 0.0;
        direction = direction.getNormalized();
        double x = direction.getX();
        double y = direction.getY();
        direction.x = -x;
        direction.y = -y;
        direction.z = 0.0;
        direction = direction.scale(100.0);
        this.dodge(direction, false);
    }

    public void dodgeBack(ILocated botPosition, ILocated inFrontOfTheBot, boolean bDouble) {
        if (botPosition == null || inFrontOfTheBot == null) {
            return;
        }
        Location inFront = inFrontOfTheBot.getLocation();
        ILocated bot = botPosition;
        Location direction = inFront.sub(bot.getLocation());
        direction.z = 0.0;
        direction = direction.getNormalized();
        double x = direction.getX();
        double y = direction.getY();
        direction.x = -x;
        direction.y = -y;
        direction.z = 0.0;
        direction = direction.scale(100.0);
        this.dodge(direction, bDouble);
    }

    public void setSpeed(double speedMultiplier) {
        Configuration configure = new Configuration();
        configure.setSpeedMultiplier(speedMultiplier);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)configure);
    }

    public void setRotationSpeed(Rotation newRotationRate) {
        Configuration configure = new Configuration();
        configure.setRotationRate(newRotationRate);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)configure);
    }

    public AdvancedLocomotion(UT2004Bot agent, Logger log) {
        super(agent, log);
        this.selfListener = new SelfListener((IWorldView)agent.getWorldView());
    }

    @Override
    public void jump() {
        super.jump();
    }

    public void jump(double jumpZ) {
        Jump jump = new Jump();
        jump.setForce(jumpZ);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)jump);
    }

    public void jump(boolean doubleJump, double secondJumpDelay, double jumpZ) {
        Jump jump = new Jump();
        jump.setDoubleJump(doubleJump);
        jump.setDelay(secondJumpDelay);
        jump.setForce(jumpZ);
        ((UT2004Bot)this.agent).getAct().act((CommandMessage)jump);
    }

    @Override
    public void moveTo(ILocated location) {
        super.moveTo(location);
    }

    @Override
    public void setRun() {
        super.setRun();
    }

    @Override
    public void setWalk() {
        super.setWalk();
    }

    @Override
    public void stopMovement() {
        super.stopMovement();
    }

    @Override
    public void turnHorizontal(int amount) {
        super.turnHorizontal(amount);
    }

    @Override
    public void turnTo(ILocated location) {
        super.turnTo(location);
    }

    @Override
    public void turnTo(Player player) {
        super.turnTo(player);
    }

    @Override
    public void turnTo(Item item) {
        super.turnTo(item);
    }

    @Override
    public void turnVertical(int amount) {
        super.turnVertical(amount);
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            AdvancedLocomotion.this.self = (Self)event.getObject();
        }
    }
}

