/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.AbstractBatchAwareWorldViewTest;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.io.File;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public abstract class AbstractSyncWorldViewTest
extends AbstractBatchAwareWorldViewTest {
    private Thread asyncTestThread = null;
    private IWorldChangeEvent lastEvent = null;
    private CyclicBarrier barrier = new CyclicBarrier(2);
    private Flag<Boolean> consistentCriticalSection = new Flag((Object)false);
    private FlagListener<Boolean> runningListener = new FlagListener<Boolean>(){

        public void flagChanged(Boolean changedValue) {
        }
    };

    protected AbstractSyncWorldViewTest(File planFile) {
        super(planFile);
    }

    @Override
    protected void preNotifications() {
        this.asyncTestThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractSyncWorldViewTest.this.asyncDoTest();
            }
        });
        this.asyncTestThread.start();
    }

    @Override
    protected void postTest() {
        try {
            this.barrier.await(999999999L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.fail("Test thread interrupted at post-test barrier: " + e.toString());
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
            this.fail("Barrier broken in test thread at post-test barrier: " + e.toString());
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            this.fail("Failed to meetup with asyncDoTest thread at the end of test run.");
        }
        if (this.getContext().getLog().isLoggable(Level.INFO)) {
            this.getContext().getLog().info("leaving postTest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncDoTest() {
        while (((Boolean)this.getContext().getRunningFlag().getFlag()).booleanValue()) {
            try {
                if (this.getContext().getLog().isLoggable(Level.INFO)) {
                    this.getContext().getLog().info("locking worldview");
                }
                ((ILockableWorldView)this.getContext().getWorldView()).lock();
                if (this.getContext().getLog().isLoggable(Level.INFO)) {
                    this.getContext().getLog().info("locked");
                }
                this.getInnerRunning().setFlag((Object)true);
                try {
                    long currTime = System.currentTimeMillis();
                    int sleepTime = 100;
                    if (this.getContext().getLog().isLoggable(Level.INFO)) {
                        this.getContext().getLog().info("sleeping for " + sleepTime + " ms");
                    }
                    this.getInnerRunning().waitFor((long)sleepTime, (Object[])new Boolean[]{false});
                    this.getInnerRunning().setFlag((Object)false);
                }
                catch (PogamutInterruptedException e) {
                    e.printStackTrace();
                    if (this.getContext().getLog().isLoggable(Level.INFO)) {
                        this.getContext().getLog().info("Interrupted in asyncDoTest.");
                    }
                    this.fail("Interrupted in asyncDoTest while blocking notifications in worldview.");
                    break;
                }
                finally {
                    if (this.getContext().getLog().isLoggable(Level.INFO)) {
                        this.getContext().getLog().info("unlocking worldview");
                    }
                    ((ILockableWorldView)this.getContext().getWorldView()).unlock();
                    if (!this.getContext().getLog().isLoggable(Level.INFO)) continue;
                    this.getContext().getLog().info("unlocked");
                }
            }
            catch (ComponentNotRunningException e) {
                if (!this.getContext().getLog().isLoggable(Level.INFO)) break;
                this.getContext().getLog().info("WorldView has been stopped.");
                break;
            }
        }
        try {
            this.barrier.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.fail("Method asyncDoTest interrupted at post-test barrier: " + e.getMessage());
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
            this.fail("Barrier broken in method asyncDoTest at post-test barrier: " + e.getMessage());
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            this.fail("Failed to meetup with main thread at the end of test run.");
        }
    }

    private Flag<Boolean> getInnerRunning() {
        return this.consistentCriticalSection;
    }
}

