/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.factory.guice.remoteagent;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.base3d.agent.IAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.LocalWorldViewAdapter;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.translator.bot.BotFSM;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.UT2004BatchAwareSharedWorldView;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.UT2004LockableLocalWorldView;
import java.lang.annotation.Annotation;

public class UT2004MultiBotModule<PARAMS extends UT2004AgentParameters>
extends UT2004BotModule<PARAMS> {
    private Class<? extends IUT2004BotController> botControllerClass;
    protected AdaptableProvider<TeamedAgentId> teamedIdProvider = new AdaptableProvider();

    protected UT2004MultiBotModule() {
    }

    public UT2004MultiBotModule(Class<? extends IUT2004BotController> botControllerClass) {
        this.botControllerClass = botControllerClass;
    }

    @Override
    public void prepareNewAgent(PARAMS agentParameters) {
        super.prepareNewAgent(agentParameters);
        this.teamedIdProvider.set((Object)((TeamedAgentId)agentParameters.getAgentId()));
    }

    protected Provider<TeamedAgentId> getTeamedAgentIdProvider() {
        return this.teamedIdProvider;
    }

    @Override
    protected void configureModules() {
        super.configureModules();
        this.addModule(new AbstractModule(){

            public void configure() {
                this.bind(IWorldMessageTranslator.class).to(BotFSM.class);
                this.bind(IWorldView.class).to(IVisionWorldView.class);
                this.bind(IVisionWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableVisionWorldView.class).to(LocalWorldViewAdapter.class);
                this.bind(BatchAwareLocalWorldView.class).to(UT2004LockableLocalWorldView.class);
                this.bind(ISharedWorldView.class).to(UT2004BatchAwareSharedWorldView.class);
                this.bind(IComponentBus.class).to(ILifecycleBus.class);
                this.bind(ILifecycleBus.class).to(LifecycleBus.class);
                this.bind(ITeamedAgentId.class).to(TeamedAgentId.class);
                this.bind(TeamedAgentId.class).toProvider(UT2004MultiBotModule.this.getTeamedAgentIdProvider());
                this.bind(ComponentDependencies.class).annotatedWith((Annotation)Names.named((String)"EventDrivenWorldViewDependency")).toProvider((Provider)UT2004MultiBotModule.this.worldViewDependenciesProvider);
                this.bind(IAgent.class).to(IAgent3D.class);
                this.bind(IAgent3D.class).to(IUT2004Bot.class);
                this.bind(IUT2004Bot.class).to(UT2004Bot.class);
                if (UT2004MultiBotModule.this.botControllerClass != null) {
                    this.bind(IUT2004BotController.class).to(UT2004MultiBotModule.this.botControllerClass);
                }
            }
        });
    }
}

