/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import java.util.logging.Level;
import org.junit.Assert;

@XStreamAlias(value="EventWrapper")
public class EventWrapper
implements IWorldEventListener<IWorldEvent> {
    @XStreamAlias(value="ExpectedEvent")
    private final IWorldEvent expectedEvent;
    @XStreamOmitField
    private final String expectedEventString;
    @XStreamAlias(value="level")
    @XStreamAsAttribute
    private final ListenerLevel level;
    protected WorldViewTestContext ctx;

    public EventWrapper(WorldViewTestContext ctx, IWorldEvent expectedEvent) {
        this(ctx, expectedEvent, ListenerLevel.A);
    }

    protected EventWrapper(WorldViewTestContext ctx, IWorldEvent expectedEvent, ListenerLevel level) {
        this.expectedEvent = expectedEvent;
        this.expectedEventString = expectedEvent.toString();
        this.level = level;
        this.ctx = ctx;
    }

    public IWorldEvent getExpectedEvent() {
        return this.expectedEvent;
    }

    public String getExpectedEventString() {
        return this.expectedEventString;
    }

    public void notify(IWorldEvent event) {
        EventWrapperWithCallCount mock_wrapper_with_counts = this.ctx.getCurrentMockWrapper();
        if (this.ctx.getLog().isLoggable(Level.INFO)) {
            this.ctx.getLog().info("Expected event: " + mock_wrapper_with_counts.getEventWrapper().getExpectedEventString());
        }
        if (this.getClass() == EventWrapper.class) {
            if (this.ctx.getLog().isLoggable(Level.INFO)) {
                this.ctx.getLog().info("Received event: " + event.toString());
            }
            Assert.assertTrue((String)("Event types do not match.\nNotified with: " + event.toString() + "\nExpected: " + mock_wrapper_with_counts.getEventWrapper().getExpectedEventString() + "\nThis wrapper: " + this.getExpectedEventString()), (event.getClass().equals(this.getExpectedEvent().getClass()) && event.getClass().equals(mock_wrapper_with_counts.getEventWrapper().getExpectedEvent().getClass()) ? 1 : 0) != 0);
            Assert.assertTrue((String)("Event types do match, but not the events themselves.\nNotified with: " + event.toString() + " expected: " + this.getExpectedEventString()), (this.getClass() != EventWrapper.class || event.toString().equals(this.getExpectedEventString()) ? 1 : 0) != 0);
            if (this.ctx.getLog().isLoggable(Level.INFO)) {
                this.ctx.getLog().info("EventWrapper notify: " + this.getExpectedEventString() + " call#: " + (mock_wrapper_with_counts.getCalled() + 1));
            }
        }
        mock_wrapper_with_counts.incCalled();
    }

    public void registerToWorldView(IWorldView worldView) {
        if (!this.ctx.getWorldView().isListening(this.expectedEvent.getClass(), (IWorldEventListener)this)) {
            if (this.ctx.getLog().isLoggable(Level.INFO)) {
                this.ctx.getLog().info("Registering listener of: " + this.getExpectedEventString());
            }
            this.ctx.getWorldView().addEventListener(this.expectedEvent.getClass(), (IWorldEventListener)this);
        }
    }

    public ListenerLevel getListenerLevel() {
        return this.level;
    }
}

