/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;

public class EventWrapperConverter
implements Converter {
    protected WorldViewTestContext ctx;

    public EventWrapperConverter(WorldViewTestContext ctx) {
        this.ctx = ctx;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        EventWrapper wrapper = (EventWrapper)value;
        writer.addAttribute("level", wrapper.getListenerLevel().toString());
        IWorldEvent wrappers_expected_event = wrapper.getExpectedEvent();
        if (wrappers_expected_event != null) {
            writer.startNode("ExpectedEvent");
            context.convertAnother((Object)wrapper.getExpectedEvent());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        IWorldEvent expected_event = null;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("ExpectedEvent") && (!reader.getValue().isEmpty() || reader.getAttribute("reference") != null)) {
                expected_event = (IWorldEvent)context.convertAnother((Object)this, context.getRequiredType());
            }
            reader.moveUp();
        }
        EventWrapper wrapper = new EventWrapper(this.ctx, expected_event);
        return wrapper;
    }

    public boolean canConvert(Class clazz) {
        return clazz == EventWrapper.class;
    }

    protected class DeserializedWrapperData {
        public ListenerLevel level;
        public IWorldEvent expectedEvent;

        protected DeserializedWrapperData() {
        }
    }
}

