/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import cz.cuni.amis.pogamut.ut2004.communication.messages.GBObjectUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.IPerson;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLocal;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLocalImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerShared;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerSharedImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerStatic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerStaticImpl;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.IGBViewable;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.IGBWorldObjectEvent;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class Player
extends InfoMessage
implements IWorldEvent,
IWorldChangeEvent,
ICompositeWorldObject,
IPerson,
IPlayer,
IGBViewable {
    public static final String PROTOTYPE = "PLR {Id unreal_id}  {Jmx text}  {Name text}  {Action text}  {Visible False}  {Rotation 0,0,0}  {Location 0,0,0}  {Velocity 0,0,0}  {Team 0}  {Weapon text}  {Reachable False}  {Firing 0} ";
    protected long SimTime;

    public long getSimTime() {
        return this.SimTime;
    }

    protected void setSimTime(long SimTime) {
        this.SimTime = SimTime;
    }

    public abstract UnrealId getId();

    public abstract String getJmx();

    @Override
    public abstract String getName();

    public abstract String getAction();

    public abstract boolean isVisible();

    public abstract Rotation getRotation();

    public abstract Location getLocation();

    public abstract Velocity getVelocity();

    public abstract int getTeam();

    public abstract String getWeapon();

    public abstract boolean isReachable();

    public abstract int getFiring();

    @Override
    public IWorldObjectUpdatedEvent createDisappearEvent() {
        return new ObjectDisappeared(this, this.getSimTime());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Player)) {
            return false;
        }
        Player obj = (Player)other;
        if (!this.getId().equals((Object)obj.getId())) {
            return false;
        }
        if (!this.getJmx().equals(obj.getJmx())) {
            return false;
        }
        if (!this.getName().equals(obj.getName())) {
            return false;
        }
        if (!this.getAction().equals(obj.getAction())) {
            return false;
        }
        if (this.isVisible() != obj.isVisible()) {
            return false;
        }
        if (!this.getRotation().equals(obj.getRotation())) {
            return false;
        }
        if (!this.getLocation().equals(obj.getLocation())) {
            return false;
        }
        if (!this.getVelocity().equals(obj.getVelocity())) {
            return false;
        }
        if (this.getTeam() != obj.getTeam()) {
            return false;
        }
        if (!this.getWeapon().equals(obj.getWeapon())) {
            return false;
        }
        if (this.isReachable() != obj.isReachable()) {
            return false;
        }
        return this.getFiring() == obj.getFiring();
    }

    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Jmx = " + String.valueOf(this.getJmx()) + " | " + "Name = " + String.valueOf(this.getName()) + " | " + "Action = " + String.valueOf(this.getAction()) + " | " + "Visible = " + String.valueOf(this.isVisible()) + " | " + "Rotation = " + String.valueOf(this.getRotation()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Velocity = " + String.valueOf(this.getVelocity()) + " | " + "Team = " + String.valueOf(this.getTeam()) + " | " + "Weapon = " + String.valueOf(this.getWeapon()) + " | " + "Reachable = " + String.valueOf(this.isReachable()) + " | " + "Firing = " + String.valueOf(this.getFiring()) + " | " + "]";
    }

    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Jmx</b> = " + String.valueOf(this.getJmx()) + " <br/> " + "<b>Name</b> = " + String.valueOf(this.getName()) + " <br/> " + "<b>Action</b> = " + String.valueOf(this.getAction()) + " <br/> " + "<b>Visible</b> = " + String.valueOf(this.isVisible()) + " <br/> " + "<b>Rotation</b> = " + String.valueOf(this.getRotation()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> " + "<b>Team</b> = " + String.valueOf(this.getTeam()) + " <br/> " + "<b>Weapon</b> = " + String.valueOf(this.getWeapon()) + " <br/> " + "<b>Reachable</b> = " + String.valueOf(this.isReachable()) + " <br/> " + "<b>Firing</b> = " + String.valueOf(this.getFiring()) + " <br/> " + "<br/>]";
    }

    public static class PlayerUpdate
    extends GBObjectUpdate
    implements ICompositeWorldObjectUpdatedEvent,
    IGBWorldObjectEvent {
        private Player object;
        private long time;
        private ITeamId teamId;

        public PlayerUpdate(Player source, long eventTime, ITeamId teamId) {
            this.object = source;
            this.time = eventTime;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public IWorldObject getObject() {
            return this.object;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ILocalWorldObjectUpdatedEvent getLocalEvent() {
            return new PlayerLocalImpl.PlayerLocalUpdate((PlayerLocal)this.object.getLocal(), this.time);
        }

        public ISharedWorldObjectUpdatedEvent getSharedEvent() {
            return new PlayerSharedImpl.PlayerSharedUpdate((PlayerShared)this.object.getShared(), this.time, this.teamId);
        }

        public IStaticWorldObjectUpdatedEvent getStaticEvent() {
            return new PlayerStaticImpl.PlayerStaticUpdate((PlayerStatic)this.object.getStatic(), this.time);
        }
    }

    public static class ObjectDisappeared
    implements IWorldObjectUpdatedEvent {
        private Player obj;
        private long time;

        public ObjectDisappeared(Player obj, long time) {
            this.obj = obj;
            this.time = time;
        }

        public WorldObjectId getId() {
            return this.obj.getId();
        }

        public long getSimTime() {
            return this.time;
        }

        public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject obj) {
            if (obj == null) {
                throw new PogamutException("Can't 'disappear' null!", (Object)this);
            }
            if (!(obj instanceof PlayerMessage)) {
                throw new PogamutException("Can't update different class than PlayerMessage, got class " + obj.getClass().getSimpleName() + "!", (Object)this);
            }
            PlayerMessage toUpdate = (PlayerMessage)obj;
            if (toUpdate.Visible) {
                toUpdate.Visible = false;
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, obj);
            }
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, obj);
        }
    }
}

