/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.GBObjectUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemLocal;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemLocalImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemShared;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemSharedImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemStatic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemStaticImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTyped;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.IGBViewable;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.IGBWorldObjectEvent;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class Item
extends InfoMessage
implements IWorldEvent,
IWorldChangeEvent,
ICompositeWorldObject,
ILocated,
IGBViewable,
ItemTyped {
    public static final String PROTOTYPE = "INV {Id unreal_id}  {NavPointId unreal_id}  {Visible False}  {Location 0,0,0}  {Reachable False}  {Amount 0}  {Type xWeapons.FlakCannonPickup}  {Dropped False} ";
    protected long SimTime;

    public long getSimTime() {
        return this.SimTime;
    }

    protected void setSimTime(long SimTime) {
        this.SimTime = SimTime;
    }

    public abstract UnrealId getId();

    public abstract UnrealId getNavPointId();

    public abstract NavPoint getNavPoint();

    public abstract boolean isVisible();

    public abstract Location getLocation();

    public abstract boolean isReachable();

    public abstract int getAmount();

    @Override
    public abstract ItemType getType();

    public abstract ItemDescriptor getDescriptor();

    public abstract boolean isDropped();

    @Override
    public IWorldObjectUpdatedEvent createDisappearEvent() {
        return new ObjectDisappeared(this, this.getSimTime());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Item)) {
            return false;
        }
        Item obj = (Item)other;
        if (!this.getId().equals((Object)obj.getId())) {
            return false;
        }
        if (!this.getNavPointId().equals((Object)obj.getNavPointId())) {
            return false;
        }
        if (!this.getNavPoint().equals(obj.getNavPoint())) {
            return false;
        }
        if (this.isVisible() != obj.isVisible()) {
            return false;
        }
        if (!this.getLocation().equals(obj.getLocation())) {
            return false;
        }
        if (this.isReachable() != obj.isReachable()) {
            return false;
        }
        if (this.getAmount() != obj.getAmount()) {
            return false;
        }
        if (!this.getType().equals(obj.getType())) {
            return false;
        }
        if (!this.getDescriptor().equals(obj.getDescriptor())) {
            return false;
        }
        return this.isDropped() == obj.isDropped();
    }

    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "NavPointId = " + String.valueOf(this.getNavPointId()) + " | " + "Visible = " + String.valueOf(this.isVisible()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Reachable = " + String.valueOf(this.isReachable()) + " | " + "Amount = " + String.valueOf(this.getAmount()) + " | " + "Type = " + String.valueOf(this.getType()) + " | " + "Dropped = " + String.valueOf(this.isDropped()) + " | " + "]";
    }

    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>NavPointId</b> = " + String.valueOf(this.getNavPointId()) + " <br/> " + "<b>Visible</b> = " + String.valueOf(this.isVisible()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Reachable</b> = " + String.valueOf(this.isReachable()) + " <br/> " + "<b>Amount</b> = " + String.valueOf(this.getAmount()) + " <br/> " + "<b>Type</b> = " + String.valueOf(this.getType()) + " <br/> " + "<b>Dropped</b> = " + String.valueOf(this.isDropped()) + " <br/> " + "<br/>]";
    }

    public static class ItemUpdate
    extends GBObjectUpdate
    implements ICompositeWorldObjectUpdatedEvent,
    IGBWorldObjectEvent {
        private Item object;
        private long time;
        private ITeamId teamId;

        public ItemUpdate(Item source, long eventTime, ITeamId teamId) {
            this.object = source;
            this.time = eventTime;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public IWorldObject getObject() {
            return this.object;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ILocalWorldObjectUpdatedEvent getLocalEvent() {
            return new ItemLocalImpl.ItemLocalUpdate((ItemLocal)this.object.getLocal(), this.time);
        }

        public ISharedWorldObjectUpdatedEvent getSharedEvent() {
            return new ItemSharedImpl.ItemSharedUpdate((ItemShared)this.object.getShared(), this.time, this.teamId);
        }

        public IStaticWorldObjectUpdatedEvent getStaticEvent() {
            return new ItemStaticImpl.ItemStaticUpdate((ItemStatic)this.object.getStatic(), this.time);
        }
    }

    public static class ObjectDisappeared
    implements IWorldObjectUpdatedEvent {
        private Item obj;
        private long time;

        public ObjectDisappeared(Item obj, long time) {
            this.obj = obj;
            this.time = time;
        }

        public WorldObjectId getId() {
            return this.obj.getId();
        }

        public long getSimTime() {
            return this.time;
        }

        public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject obj) {
            if (obj == null) {
                throw new PogamutException("Can't 'disappear' null!", (Object)this);
            }
            if (!(obj instanceof ItemMessage)) {
                throw new PogamutException("Can't update different class than ItemMessage, got class " + obj.getClass().getSimpleName() + "!", (Object)this);
            }
            ItemMessage toUpdate = (ItemMessage)obj;
            if (toUpdate.Visible) {
                toUpdate.Visible = false;
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, obj);
            }
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, obj);
        }
    }
}

