/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.BooleanProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.DoubleProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.IntProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LongProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfoShared;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class GameInfoSharedImpl
extends GameInfoShared {
    private UnrealId Id = GameInfo.GameInfoId;
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(7);
    protected BooleanProperty myWeaponStay = null;
    protected DoubleProperty myTimeLimit = null;
    protected IntProperty myFragLimit = null;
    protected LongProperty myGoalTeamScore = null;
    protected IntProperty myMaxTeamSize = null;
    protected BooleanProperty myGamePaused = null;
    protected BooleanProperty myBotsPaused = null;

    public GameInfoSharedImpl(GameInfoSharedImpl source) {
        this.myWeaponStay = source.myWeaponStay;
        this.myTimeLimit = source.myTimeLimit;
        this.myFragLimit = source.myFragLimit;
        this.myGoalTeamScore = source.myGoalTeamScore;
        this.myMaxTeamSize = source.myMaxTeamSize;
        this.myGamePaused = source.myGamePaused;
        this.myBotsPaused = source.myBotsPaused;
    }

    public GameInfoSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
        this.Id = (UnrealId)objectId;
        NullCheck.check((Object)this.Id, (String)"objectId");
        if (properties.size() != 7) {
            throw new PogamutException("Not enough properties passed to the constructor.", GameInfoSharedImpl.class);
        }
        for (ISharedProperty property : properties) {
            PropertyId pId = property.getPropertyId();
            if (!objectId.equals((Object)property.getObjectId())) {
                throw new PogamutException("Trying to create a GameInfoSharedImpl with different WorldObjectId properties : " + this.Id.getStringId() + " / " + property.getObjectId().getStringId(), (Object)this);
            }
            if (!GameInfoShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
                throw new PogamutException("Trying to create a GameInfoSharedImpl with invalid property (invalid property token): " + this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken(), (Object)this);
            }
            this.propertyMap.put(property.getPropertyId(), property);
        }
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public void setSimTime(long SimTime) {
        super.setSimTime(SimTime);
    }

    @Override
    public GameInfoSharedImpl clone() {
        return new GameInfoSharedImpl(this);
    }

    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public boolean isWeaponStay() {
        return (Boolean)this.myWeaponStay.getValue();
    }

    @Override
    public double getTimeLimit() {
        return (Double)this.myTimeLimit.getValue();
    }

    @Override
    public int getFragLimit() {
        return (Integer)this.myFragLimit.getValue();
    }

    @Override
    public long getGoalTeamScore() {
        return (Long)this.myGoalTeamScore.getValue();
    }

    @Override
    public int getMaxTeamSize() {
        return (Integer)this.myMaxTeamSize.getValue();
    }

    @Override
    public boolean isGamePaused() {
        return (Boolean)this.myGamePaused.getValue();
    }

    @Override
    public boolean isBotsPaused() {
        return (Boolean)this.myBotsPaused.getValue();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GameInfoShared)) {
            return false;
        }
        GameInfoShared obj = (GameInfoShared)((Object)other);
        if (this.isWeaponStay() != obj.isWeaponStay()) {
            return false;
        }
        if (this.getTimeLimit() != obj.getTimeLimit()) {
            return false;
        }
        if (this.getFragLimit() != obj.getFragLimit()) {
            return false;
        }
        if (this.getGoalTeamScore() != obj.getGoalTeamScore()) {
            return false;
        }
        if (this.getMaxTeamSize() != obj.getMaxTeamSize()) {
            return false;
        }
        if (this.isGamePaused() != obj.isGamePaused()) {
            return false;
        }
        return this.isBotsPaused() == obj.isBotsPaused();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "WeaponStay = " + String.valueOf(this.isWeaponStay()) + " | " + "TimeLimit = " + String.valueOf(this.getTimeLimit()) + " | " + "FragLimit = " + String.valueOf(this.getFragLimit()) + " | " + "GoalTeamScore = " + String.valueOf(this.getGoalTeamScore()) + " | " + "MaxTeamSize = " + String.valueOf(this.getMaxTeamSize()) + " | " + "GamePaused = " + String.valueOf(this.isGamePaused()) + " | " + "BotsPaused = " + String.valueOf(this.isBotsPaused()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>WeaponStay</b> = " + String.valueOf(this.isWeaponStay()) + " <br/> " + "<b>TimeLimit</b> = " + String.valueOf(this.getTimeLimit()) + " <br/> " + "<b>FragLimit</b> = " + String.valueOf(this.getFragLimit()) + " <br/> " + "<b>GoalTeamScore</b> = " + String.valueOf(this.getGoalTeamScore()) + " <br/> " + "<b>MaxTeamSize</b> = " + String.valueOf(this.getMaxTeamSize()) + " <br/> " + "<b>GamePaused</b> = " + String.valueOf(this.isGamePaused()) + " <br/> " + "<b>BotsPaused</b> = " + String.valueOf(this.isBotsPaused()) + " <br/> " + "<br/>]";
    }

    public static class GameInfoSharedUpdate
    implements ISharedWorldObjectUpdatedEvent {
        private GameInfoShared object;
        private long time;
        private ITeamId teamId;

        public GameInfoSharedUpdate(GameInfoShared data, long time, ITeamId teamId) {
            this.object = data;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ITeamId getTeamId() {
            return this.teamId;
        }

        public Class getCompositeObjectClass() {
            return this.object.getCompositeClass();
        }

        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty property : this.object.getProperties().values()) {
                if (property == null) continue;
                events.push(property.createUpdateEvent(this.time, this.teamId));
            }
            return events;
        }
    }
}

