/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.MultipleAgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;
import java.util.logging.Level;

public class MultipleUT2004BotRunner<BOT extends UT2004Bot, PARAMS extends UT2004AgentParameters, MODULE extends UT2004BotModule>
extends MultipleAgentRunner<BOT, PARAMS, MODULE> {
    protected String host;
    protected int port;
    protected String name;

    public MultipleUT2004BotRunner(String name, String host, int port) {
        this.name = name;
        this.port = port;
        this.host = host;
    }

    public MultipleUT2004BotRunner(String name) {
        this(name, Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public String getName() {
        return this.name;
    }

    public MultipleUT2004BotRunner<BOT, PARAMS, MODULE> setName(String name) {
        if (name == null) {
            name = "UT2004Bot";
        }
        this.name = name;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public MultipleUT2004BotRunner<BOT, PARAMS, MODULE> setHost(String host) {
        this.host = host;
        NullCheck.check((Object)this.host, (String)"host");
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MultipleUT2004BotRunner<BOT, PARAMS, MODULE> setPort(int port) {
        this.port = port;
        return this;
    }

    protected void preStartHook(BOT agent) throws PogamutException {
        agent.getLogger().setLevel(Level.WARNING);
    }

    protected IAgentParameters newDefaultAgentParameters() {
        return new UT2004AgentParameters().setAgentId(this.newAgentId(this.name)).setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(this.host, this.port));
    }

    protected IAgentFactory newAgentFactory(MODULE agentModule) {
        return new UT2004BotFactory(agentModule);
    }

    public List<BOT> startAgents(IAgentDescriptor<PARAMS, MODULE> ... agentDescriptors) {
        return super.startAgents(agentDescriptors);
    }
}

