/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;

public class FloydWarshallMap
extends SensorModule<IGhostAgent>
implements IPathPlanner<NavPoint> {
    private IWorldEventListener<MapPointListObtained> mapListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            if (FloydWarshallMap.this.log.isLoggable(Level.INFO)) {
                FloydWarshallMap.this.log.info("Map point list obtained.");
            }
            FloydWarshallMap.this.performFloydWarshall(event);
        }
    };
    public static final int BAD_EDGE_FLAG = LinkFlag.FLY.get() | LinkFlag.LADDER.get() | LinkFlag.PROSCRIBED.get() | LinkFlag.SWIM.get() | LinkFlag.PLAYERONLY.get() | LinkFlag.FORCED.get();
    protected int badEdgeFlag = 0;
    protected Map<UnrealId, Integer> navPointIndices;
    protected Map<Integer, NavPoint> indicesNavPoints;
    protected PathMatrixNode[][] pathMatrix;

    public FloydWarshallMap(IGhostAgent bot) {
        this(bot, BAD_EDGE_FLAG, null);
    }

    public FloydWarshallMap(IGhostAgent bot, Logger log) {
        this(bot, BAD_EDGE_FLAG, log);
    }

    public FloydWarshallMap(IGhostAgent bot, int badEdgeFlag, Logger log) {
        super((IObservingAgent)bot, log);
        this.badEdgeFlag = badEdgeFlag;
        this.worldView.addEventListener(MapPointListObtained.class, this.mapListener);
    }

    public void refreshPathMatrix() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine((Object)((Object)this) + ": Refreshing path matrix...");
        }
        List navPoints = MyCollections.asList(((IGhostAgent)this.agent).getWorldView().getAll(NavPoint.class).values());
        this.performFloydWarshall(navPoints);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine((Object)((Object)this) + ": Path matrix refreshed!");
        }
    }

    protected void performFloydWarshall(MapPointListObtained map) {
        List navPoints = MyCollections.asList(map.getNavPoints().values());
        this.performFloydWarshall(navPoints);
    }

    protected void performFloydWarshall(List<NavPoint> navPoints) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine((Object)((Object)this) + ": Beginning Floyd-Warshall algorithm...");
        }
        long start = System.currentTimeMillis();
        int size = navPoints.size();
        this.navPointIndices = new HashMap<UnrealId, Integer>(size);
        this.indicesNavPoints = new HashMap<Integer, NavPoint>(size);
        this.pathMatrix = new PathMatrixNode[size][size];
        int i = 0;
        while (i < navPoints.size()) {
            this.navPointIndices.put(navPoints.get(i).getId(), i);
            this.indicesNavPoints.put(i, navPoints.get(i));
            ++i;
        }
        i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                this.pathMatrix[i][j] = new PathMatrixNode(i == j ? 0.0f : Float.POSITIVE_INFINITY);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            Point3d location = navPoints.get(i).getLocation().getPoint3d();
            for (NavPointNeighbourLink link : navPoints.get(i).getOutgoingEdges().values()) {
                if (!this.checkLink(link)) continue;
                this.pathMatrix[i][this.navPointIndices.get(link.getToNavPoint().getId())].setDistance((float)location.distance(link.getToNavPoint().getLocation().getPoint3d()));
            }
            ++i;
        }
        int k = 0;
        while (k < size) {
            int i2 = 0;
            while (i2 < size) {
                int j = 0;
                while (j < size) {
                    float newLen = this.pathMatrix[i2][k].getDistance() + this.pathMatrix[k][j].getDistance();
                    if (this.pathMatrix[i2][j].getDistance() > newLen) {
                        this.pathMatrix[i2][j].setDistance(newLen);
                        this.pathMatrix[i2][j].setViaNode(k);
                    }
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        int count = 0;
        int i3 = 0;
        while (i3 < size) {
            int j = 0;
            while (j < size) {
                if (this.pathMatrix[i3][j].getDistance() == Float.POSITIVE_INFINITY) {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.warning("Unreachable path from " + navPoints.get(i3).getId().getStringId() + " -> " + navPoints.get(j).getId().getStringId());
                    }
                    ++count;
                } else {
                    this.pathMatrix[i3][j].setPath(this.retrievePath(i3, j));
                }
                ++j;
            }
            ++i3;
        }
        if (count > 0 && this.log.isLoggable(Level.WARNING)) {
            this.log.warning((Object)((Object)this) + ": There are " + count + " unreachable nav point pairs (if you wish to see more, set logging to Level.FINER).");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info((Object)((Object)this) + ": computation for " + size + " navpoints took " + (System.currentTimeMillis() - start) + " millis");
        }
        this.indicesNavPoints = null;
    }

    public boolean checkLink(NavPointNeighbourLink edge) {
        if ((edge.getFlags() & this.badEdgeFlag) != 0) {
            return false;
        }
        if ((edge.getFlags() & LinkFlag.SPECIAL.get()) != 0) {
            return true;
        }
        return true;
    }

    private List<NavPoint> retrievePathInner(Integer from, Integer to) {
        PathMatrixNode node = this.pathMatrix[from][to];
        if (node.getDistance() == Float.POSITIVE_INFINITY) {
            return null;
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.addAll(this.retrievePathInner(from, node.getViaNode()));
        path.add(this.indicesNavPoints.get(node.getViaNode()));
        path.addAll(this.retrievePathInner(node.getViaNode(), to));
        return path;
    }

    private List<NavPoint> retrievePath(Integer from, Integer to) {
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.add(this.indicesNavPoints.get(from));
        path.addAll(this.retrievePathInner(from, to));
        path.add(this.indicesNavPoints.get(to));
        return path;
    }

    protected PathMatrixNode getPathMatrixNode(NavPoint np1, NavPoint np2) {
        return this.pathMatrix[this.navPointIndices.get(np1.getId())][this.navPointIndices.get(np2.getId())];
    }

    public boolean reachable(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return false;
        }
        return this.getPathMatrixNode(from, to).getDistance() != Float.POSITIVE_INFINITY;
    }

    public float getDistance(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return Float.POSITIVE_INFINITY;
        }
        return this.getPathMatrixNode(from, to).getDistance();
    }

    public List<NavPoint> getPath(NavPoint from, NavPoint to) {
        List<NavPoint> path;
        if (from == null || to == null) {
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Retrieving path: " + from.getId().getStringId() + "[" + from.getLocation() + "] -> " + to.getId().getStringId() + "[" + to.getLocation() + "]");
        }
        if ((path = this.getPathMatrixNode(from, to).getPath()) == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("PATH NOT EXIST: " + from.getId().getStringId() + "[" + from.getLocation() + "] -> " + to.getId().getStringId() + "[" + to.getLocation() + "]");
            }
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Path exists - " + path.size() + " navpoints.");
        }
        return path;
    }

    public String toString() {
        return "FloydWarshallMap";
    }

    public IPathFuture<NavPoint> computePath(NavPoint from, NavPoint to) {
        return new PrecomputedPathFuture((Object)from, (Object)to, this.getPath(from, to));
    }

    public static class PathMatrixNode {
        private float distance = Float.POSITIVE_INFINITY;
        private Integer viaNode = null;
        private List<NavPoint> path = null;

        public PathMatrixNode() {
        }

        public PathMatrixNode(float distance) {
            this.distance = distance;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public Integer getViaNode() {
            return this.viaNode;
        }

        public void setViaNode(Integer indice) {
            this.viaNode = indice;
        }

        public List<NavPoint> getPath() {
            return this.path;
        }

        public void setPath(List<NavPoint> path) {
            this.path = path;
        }
    }
}

