package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter;

import java.util.LinkedList;

import org.junit.Assert;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;

public class EventWrapperListConverter implements Converter {
	
	protected final LinkedList<? extends IWorldChangeEvent> inputEvents;
	protected final LinkedList<? extends IWorldEvent> expectedEvents;
	
	public EventWrapperListConverter(LinkedList<? extends IWorldChangeEvent> inputEvents,
			LinkedList<? extends IWorldEvent> expectedEvents) {
		this.inputEvents = inputEvents;
		this.expectedEvents = expectedEvents;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {

		LinkedList<EventWrapper> event_wrappers = (LinkedList<EventWrapper>)value;
		
		int i = 0;
		for (EventWrapper event_wrapper : event_wrappers) {			
			writer.startNode("EventWrapper");
			writer.addAttribute("type", event_wrapper.getClass().getName());
			context.convertAnother(event_wrapper);			
			writer.endNode();
			++i;
		}
	}

	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
		
		LinkedList<EventWrapper> event_wrappers = new LinkedList<EventWrapper>();
		
		while (reader.hasMoreChildren()) {			
	    	reader.moveDown();
	    		    		   
	    	String type = reader.getAttribute("type");
			try {
				EventWrapper wrapper = (EventWrapper) context.convertAnother(this, Class.forName(type));
				event_wrappers.add(wrapper);
			} catch (ClassNotFoundException e) {				
				e.printStackTrace();
				Assert.fail("Could not find class of this type: " + type);
			}
	    	reader.moveUp();
		}
    	
		return event_wrappers;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == LinkedList.class;
	}

}
