package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;
 		
 		// --- IMPORTS FROM /messages/settings/javasettings/javaimport BEGIN
			import java.util.*;import javax.vecmath.*;import cz.cuni.amis.pogamut.base.communication.messages.*;import cz.cuni.amis.pogamut.base.communication.worldview.*;import cz.cuni.amis.pogamut.base.communication.worldview.event.*;import cz.cuni.amis.pogamut.base.communication.worldview.object.*;import cz.cuni.amis.pogamut.multi.communication.worldview.object.*;import cz.cuni.amis.pogamut.base.communication.translator.event.*;import cz.cuni.amis.pogamut.multi.communication.translator.event.*;import cz.cuni.amis.pogamut.base3d.worldview.object.*;import cz.cuni.amis.pogamut.base3d.worldview.object.event.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.*;import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;import cz.cuni.amis.utils.exception.*;import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result;import cz.cuni.amis.utils.SafeEquals;import cz.cuni.amis.pogamut.base.agent.*;import cz.cuni.amis.pogamut.multi.agent.*;import cz.cuni.amis.pogamut.multi.communication.worldview.property.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.property.*;import cz.cuni.amis.utils.token.*;import cz.cuni.amis.utils.*;
		// --- IMPORTS FROM /messages/settings/javasettings/javaimport END
		
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] BEGIN
				
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] END
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=shared]+classtype[@name=impl] BEGIN
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=shared]+classtype[@name=impl] END
    
 		/**
         *  
            				Implementation of the shared part of the GameBots2004 message SLF.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		Synchronous message. Information about your bot's state.
	
         */
 	public class SelfSharedImpl 
  						extends
  						SelfShared
	    {
 	
    
    	
    	public SelfSharedImpl(SelfSharedImpl source) {
			
				this.Id = source.
					getId()
 	;
			
				this.myBotId = source.myBotId;
			
				this.myName = source.myName;
			
				this.myVehicle = source.myVehicle;
			
				this.myLocation = source.myLocation;
			
				this.myVelocity = source.myVelocity;
			
				this.myRotation = source.myRotation;
			
				this.myTeam = source.myTeam;
			
				this.myWeapon = source.myWeapon;
			
				this.myShooting = source.myShooting;
			
				this.myHealth = source.myHealth;
			
				this.myPrimaryAmmo = source.myPrimaryAmmo;
			
				this.mySecondaryAmmo = source.mySecondaryAmmo;
			
				this.myAdrenaline = source.myAdrenaline;
			
				this.myArmor = source.myArmor;
			
				this.mySmallArmor = source.mySmallArmor;
			
				this.myAltFiring = source.myAltFiring;
			
				this.myCrouched = source.myCrouched;
			
				this.myWalking = source.myWalking;
			
				this.myFloorLocation = source.myFloorLocation;
			
				this.myFloorNormal = source.myFloorNormal;
			
				this.myCombo = source.myCombo;
			
				this.myUDamageTime = source.myUDamageTime;
			
				this.myAction = source.myAction;
			
		}
		
		public SelfSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
			this.Id = (UnrealId)objectId;
			NullCheck.check(this.Id, "objectId");
		
			if (properties.size() != 23) {
				throw new PogamutException("Not enough properties passed to the constructor.", SelfSharedImpl.class);
			}
		
			//we have to do some checking in this one to know that we get all properties required
			for ( ISharedProperty property : properties ) {
				PropertyId pId = property.getPropertyId();
				if ( !objectId.equals( property.getObjectId() )) {
					//properties for different objects
					throw new PogamutException("Trying to create a SelfSharedImpl with different WorldObjectId properties : " + 
											    this.Id.getStringId() + " / " + property.getObjectId().getStringId() , this);
				}
				if (!SelfShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
				// property that does not belong here
				throw new PogamutException("Trying to create a SelfSharedImpl with invalid property (invalid property token): " + 
					this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken() , this);
				}
				propertyMap.put(property.getPropertyId(), property);
			}
		}
    
   				
   				@Override
   				public void setSimTime(long SimTime) {
					super.setSimTime(SimTime);
				}
   			
	    				@Override
	    				public 
	    				SelfSharedImpl clone() {
	    					return new 
	    					SelfSharedImpl(this);
	    				}
	    				
	    				
		
		
		
		protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap<PropertyId, ISharedProperty>(
			23
		);
		
		@Override
		public ISharedProperty getProperty(PropertyId id) {
			return propertyMap.get(id);
		}

		@Override
		public Map<PropertyId, ISharedProperty> getProperties() {
			return propertyMap;
		}
	
		
		
    	
	    /**
         * Unique Id of the bot. 
         */
        protected
         UnrealId Id =
       	null;
	
 		/**
         * Unique Id of the bot. 
         */
        public  UnrealId getId()
 	 {
  			return Id;
  		}
  		
    	
	    /**
         * Unique Id of the observed bot. Sent only for observers, note that observers has different Id in Self.Id than bots. 
         */
        protected
         UnrealIdProperty 
        myBotId
					= null;
					
					
 		/**
         * Unique Id of the observed bot. Sent only for observers, note that observers has different Id in Self.Id than bots. 
         */
        public  UnrealId getBotId()
 	 {
			  			return myBotId.getValue();
			  		}
				
    	
	    /**
         * Human readable bot name. 
         */
        protected
         StringProperty 
        myName
					= null;
					
					
 		/**
         * Human readable bot name. 
         */
        public  String getName()
 	 {
			  			return myName.getValue();
			  		}
				
    	
	    /**
         * If we are vehicle just these attr. are sent in SLF: "Id","Vehicle""Rotation", "Location","Velocity ","Name ","Team" ,"Health" 
	"Armor","Adrenaline", "FloorLocation", "FloorNormal". 
         */
        protected
         BooleanProperty 
        myVehicle
					= null;
					
					
 		/**
         * If we are vehicle just these attr. are sent in SLF: "Id","Vehicle""Rotation", "Location","Velocity ","Name ","Team" ,"Health" 
	"Armor","Adrenaline", "FloorLocation", "FloorNormal". 
         */
        public  boolean isVehicle()
 	 {
			  			return myVehicle.getValue();
			  		}
				
    	
	    /**
         * 
			An absolute location of the bot.
		 
         */
        protected
         LocationProperty 
        myLocation
					= null;
					
					
 		/**
         * 
			An absolute location of the bot.
		 
         */
        public  Location getLocation()
 	 {
			  			return myLocation.getValue();
			  		}
				
    	
	    /**
         * 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		 
         */
        protected
         VelocityProperty 
        myVelocity
					= null;
					
					
 		/**
         * 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		 
         */
        public  Velocity getVelocity()
 	 {
			  			return myVelocity.getValue();
			  		}
				
    	
	    /**
         * 
			Which direction the bot is facing in absolute terms.
		 
         */
        protected
         RotationProperty 
        myRotation
					= null;
					
					
 		/**
         * 
			Which direction the bot is facing in absolute terms.
		 
         */
        public  Rotation getRotation()
 	 {
			  			return myRotation.getValue();
			  		}
				
    	
	    /**
         * 
			What team the bot is on. 255 is no team. 0-3 are red,
			blue, green, gold in that order.
		 
         */
        protected
         IntProperty 
        myTeam
					= null;
					
					
 		/**
         * 
			What team the bot is on. 255 is no team. 0-3 are red,
			blue, green, gold in that order.
		 
         */
        public  int getTeam()
 	 {
			  			return myTeam.getValue();
			  		}
				
    	
	    /**
         * 
			Id of the weapon we are holding. This is unique Id of an
			item in our inventory and is different from the Id of the
			item we pick up from the ground! We can parse this string to
			look which weapon we hold. Weapon strings to look for
			include: "AssaultRifle", "ShieldGun", "FlakCannon",
			"BioRifle", "ShockRifle", "LinkGun", "SniperRifle",
			"RocketLauncher", "Minigun", "LightingGun", "Translocator".
			TODO: Look if this is all.
		 
         */
        protected
         StringProperty 
        myWeapon
					= null;
					
					
 		/**
         * 
			Id of the weapon we are holding. This is unique Id of an
			item in our inventory and is different from the Id of the
			item we pick up from the ground! We can parse this string to
			look which weapon we hold. Weapon strings to look for
			include: "AssaultRifle", "ShieldGun", "FlakCannon",
			"BioRifle", "ShockRifle", "LinkGun", "SniperRifle",
			"RocketLauncher", "Minigun", "LightingGun", "Translocator".
			TODO: Look if this is all.
		 
         */
        public  String getWeapon()
 	 {
			  			return myWeapon.getValue();
			  		}
				
    	
	    /**
         * If the bot is shooting or not. 
         */
        protected
         BooleanProperty 
        myShooting
					= null;
					
					
 		/**
         * If the bot is shooting or not. 
         */
        public  boolean isShooting()
 	 {
			  			return myShooting.getValue();
			  		}
				
    	
	    /**
         * 
			How much health the bot has left. Starts at 100, ranges from
			0 to 200.
		 
         */
        protected
         IntProperty 
        myHealth
					= null;
					
					
 		/**
         * 
			How much health the bot has left. Starts at 100, ranges from
			0 to 200.
		 
         */
        public  int getHealth()
 	 {
			  			return myHealth.getValue();
			  		}
				
    	
	    /**
         * 
			How much ammo the bot has left for current weapon primary
			mode.
		 
         */
        protected
         IntProperty 
        myPrimaryAmmo
					= null;
					
					
 		/**
         * 
			How much ammo the bot has left for current weapon primary
			mode.
		 
         */
        public  int getPrimaryAmmo()
 	 {
			  			return myPrimaryAmmo.getValue();
			  		}
				
    	
	    /**
         * 
			How much ammo the bot has left for current weapon secondary
			mode. Weapon does not have to support sec. fire mode.
		 
         */
        protected
         IntProperty 
        mySecondaryAmmo
					= null;
					
					
 		/**
         * 
			How much ammo the bot has left for current weapon secondary
			mode. Weapon does not have to support sec. fire mode.
		 
         */
        public  int getSecondaryAmmo()
 	 {
			  			return mySecondaryAmmo.getValue();
			  		}
				
    	
	    /**
         * How much adrenaline the bot has. 
         */
        protected
         IntProperty 
        myAdrenaline
					= null;
					
					
 		/**
         * How much adrenaline the bot has. 
         */
        public  int getAdrenaline()
 	 {
			  			return myAdrenaline.getValue();
			  		}
				
    	
	    /**
         * 
			Combined size of high armor and low armor (or small armor). The high and low armor are tracked
                        separately. Low armor is limited to 50 points, while the
                        high armor can have up to 150 points. Both stacks can have a combined size of 150 points as well,
                        so if low armor is already at 50 points, high armor can have
                        100 points at max.
		 
         */
        protected
         IntProperty 
        myArmor
					= null;
					
					
 		/**
         * 
			Combined size of high armor and low armor (or small armor). The high and low armor are tracked
                        separately. Low armor is limited to 50 points, while the
                        high armor can have up to 150 points. Both stacks can have a combined size of 150 points as well,
                        so if low armor is already at 50 points, high armor can have
                        100 points at max.
		 
         */
        public  int getArmor()
 	 {
			  			return myArmor.getValue();
			  		}
				
    	
	    /**
         * 
			Also refered to as a "low armor". Ranges from 0 to 50 points.
		 
         */
        protected
         IntProperty 
        mySmallArmor
					= null;
					
					
 		/**
         * 
			Also refered to as a "low armor". Ranges from 0 to 50 points.
		 
         */
        public  int getSmallArmor()
 	 {
			  			return mySmallArmor.getValue();
			  		}
				
    	
	    /**
         * 
			If we are firing in secondary firing mode. 
		 
         */
        protected
         BooleanProperty 
        myAltFiring
					= null;
					
					
 		/**
         * 
			If we are firing in secondary firing mode. 
		 
         */
        public  boolean isAltFiring()
 	 {
			  			return myAltFiring.getValue();
			  		}
				
    	
	    /**
         * 
			If we are currently crouched.
		 
         */
        protected
         BooleanProperty 
        myCrouched
					= null;
					
					
 		/**
         * 
			If we are currently crouched.
		 
         */
        public  boolean isCrouched()
 	 {
			  			return myCrouched.getValue();
			  		}
				
    	
	    /**
         * 
			If we are currently in walking mode.
		 
         */
        protected
         BooleanProperty 
        myWalking
					= null;
					
					
 		/**
         * 
			If we are currently in walking mode.
		 
         */
        public  boolean isWalking()
 	 {
			  			return myWalking.getValue();
			  		}
				
    	
	    /**
         * 
			Holds current floor location under the bot.
		 
         */
        protected
         LocationProperty 
        myFloorLocation
					= null;
					
					
 		/**
         * 
			Holds current floor location under the bot.
		 
         */
        public  Location getFloorLocation()
 	 {
			  			return myFloorLocation.getValue();
			  		}
				
    	
	    /**
         * 
			Holds current floor normal under the bot.
		 
         */
        protected
         LocationProperty 
        myFloorNormal
					= null;
					
					
 		/**
         * 
			Holds current floor normal under the bot.
		 
         */
        public  Location getFloorNormal()
 	 {
			  			return myFloorNormal.getValue();
			  		}
				
    	
	    /**
         * 
			Name of the current combo (None if no combo active).
			Can be xGame.ComboBerserk, xGame.ComboDefensive, xGame.ComboInvis or xGame.ComboSpeed.
			To trigger combo adrenaline needs to be at 100 (maximum) and no other combo can be active.
		 
         */
        protected
         StringProperty 
        myCombo
					= null;
					
					
 		/**
         * 
			Name of the current combo (None if no combo active).
			Can be xGame.ComboBerserk, xGame.ComboDefensive, xGame.ComboInvis or xGame.ComboSpeed.
			To trigger combo adrenaline needs to be at 100 (maximum) and no other combo can be active.
		 
         */
        public  String getCombo()
 	 {
			  			return myCombo.getValue();
			  		}
				
    	
	    /**
         * 
			Time when the UDamage effect expires. If the number is higher then the current
			time, it means the bot has UDamage effect active right now.
		 
         */
        protected
         DoubleProperty 
        myUDamageTime
					= null;
					
					
 		/**
         * 
			Time when the UDamage effect expires. If the number is higher then the current
			time, it means the bot has UDamage effect active right now.
		 
         */
        public  double getUDamageTime()
 	 {
			  			return myUDamageTime.getValue();
			  		}
				
    	
	    /**
         * 
			Name of the current BDI action.
		 
         */
        protected
         StringProperty 
        myAction
					= null;
					
					
 		/**
         * 
			Name of the current BDI action.
		 
         */
        public  String getAction()
 	 {
			  			return myAction.getValue();
			  		}
				
    	
    	
    	public static class SelfSharedUpdate
     implements ISharedWorldObjectUpdatedEvent
		{
	
			private SelfShared object;
			private long time;
			private ITeamId teamId;
			
			public SelfSharedUpdate
    (SelfShared data, long time, ITeamId teamId)
			{
				this.object = data;
				this.time = time;
				this.teamId = teamId;
			}
			
			@Override
			public long getSimTime() {
				return this.time;
			}
	
			@Override
			public WorldObjectId getId() {
				return object.getId();
			}
	
			@Override
			public ITeamId getTeamId() {
				return teamId;
			}
			
			@Override
			public Class getCompositeObjectClass()
			{
				return object.getCompositeClass();
			}
	
			@Override
			public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
				LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
				
				for ( ISharedProperty property : object.getProperties().values() )
				{
					if ( property != null)
					{
						events.push( property.createUpdateEvent(time, teamId) );
					}
				}
				return events;
			}
			
		}
	
    
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
		              			"BotId = " + String.valueOf(getBotId()
 	) + " | " + 
		              		
		              			"Name = " + String.valueOf(getName()
 	) + " | " + 
		              		
		              			"Vehicle = " + String.valueOf(isVehicle()
 	) + " | " + 
		              		
		              			"Location = " + String.valueOf(getLocation()
 	) + " | " + 
		              		
		              			"Velocity = " + String.valueOf(getVelocity()
 	) + " | " + 
		              		
		              			"Rotation = " + String.valueOf(getRotation()
 	) + " | " + 
		              		
		              			"Team = " + String.valueOf(getTeam()
 	) + " | " + 
		              		
		              			"Weapon = " + String.valueOf(getWeapon()
 	) + " | " + 
		              		
		              			"Shooting = " + String.valueOf(isShooting()
 	) + " | " + 
		              		
		              			"Health = " + String.valueOf(getHealth()
 	) + " | " + 
		              		
		              			"PrimaryAmmo = " + String.valueOf(getPrimaryAmmo()
 	) + " | " + 
		              		
		              			"SecondaryAmmo = " + String.valueOf(getSecondaryAmmo()
 	) + " | " + 
		              		
		              			"Adrenaline = " + String.valueOf(getAdrenaline()
 	) + " | " + 
		              		
		              			"Armor = " + String.valueOf(getArmor()
 	) + " | " + 
		              		
		              			"SmallArmor = " + String.valueOf(getSmallArmor()
 	) + " | " + 
		              		
		              			"AltFiring = " + String.valueOf(isAltFiring()
 	) + " | " + 
		              		
		              			"Crouched = " + String.valueOf(isCrouched()
 	) + " | " + 
		              		
		              			"Walking = " + String.valueOf(isWalking()
 	) + " | " + 
		              		
		              			"FloorLocation = " + String.valueOf(getFloorLocation()
 	) + " | " + 
		              		
		              			"FloorNormal = " + String.valueOf(getFloorNormal()
 	) + " | " + 
		              		
		              			"Combo = " + String.valueOf(getCombo()
 	) + " | " + 
		              		
		              			"UDamageTime = " + String.valueOf(getUDamageTime()
 	) + " | " + 
		              		
		              			"Action = " + String.valueOf(getAction()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
		              			"<b>BotId</b> = " + String.valueOf(getBotId()
 	) + " <br/> " + 
		              		
		              			"<b>Name</b> = " + String.valueOf(getName()
 	) + " <br/> " + 
		              		
		              			"<b>Vehicle</b> = " + String.valueOf(isVehicle()
 	) + " <br/> " + 
		              		
		              			"<b>Location</b> = " + String.valueOf(getLocation()
 	) + " <br/> " + 
		              		
		              			"<b>Velocity</b> = " + String.valueOf(getVelocity()
 	) + " <br/> " + 
		              		
		              			"<b>Rotation</b> = " + String.valueOf(getRotation()
 	) + " <br/> " + 
		              		
		              			"<b>Team</b> = " + String.valueOf(getTeam()
 	) + " <br/> " + 
		              		
		              			"<b>Weapon</b> = " + String.valueOf(getWeapon()
 	) + " <br/> " + 
		              		
		              			"<b>Shooting</b> = " + String.valueOf(isShooting()
 	) + " <br/> " + 
		              		
		              			"<b>Health</b> = " + String.valueOf(getHealth()
 	) + " <br/> " + 
		              		
		              			"<b>PrimaryAmmo</b> = " + String.valueOf(getPrimaryAmmo()
 	) + " <br/> " + 
		              		
		              			"<b>SecondaryAmmo</b> = " + String.valueOf(getSecondaryAmmo()
 	) + " <br/> " + 
		              		
		              			"<b>Adrenaline</b> = " + String.valueOf(getAdrenaline()
 	) + " <br/> " + 
		              		
		              			"<b>Armor</b> = " + String.valueOf(getArmor()
 	) + " <br/> " + 
		              		
		              			"<b>SmallArmor</b> = " + String.valueOf(getSmallArmor()
 	) + " <br/> " + 
		              		
		              			"<b>AltFiring</b> = " + String.valueOf(isAltFiring()
 	) + " <br/> " + 
		              		
		              			"<b>Crouched</b> = " + String.valueOf(isCrouched()
 	) + " <br/> " + 
		              		
		              			"<b>Walking</b> = " + String.valueOf(isWalking()
 	) + " <br/> " + 
		              		
		              			"<b>FloorLocation</b> = " + String.valueOf(getFloorLocation()
 	) + " <br/> " + 
		              		
		              			"<b>FloorNormal</b> = " + String.valueOf(getFloorNormal()
 	) + " <br/> " + 
		              		
		              			"<b>Combo</b> = " + String.valueOf(getCombo()
 	) + " <br/> " + 
		              		
		              			"<b>UDamageTime</b> = " + String.valueOf(getUDamageTime()
 	) + " <br/> " + 
		              		
		              			"<b>Action</b> = " + String.valueOf(getAction()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=shared+classtype[@name=impl]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=shared+classtype[@name=impl]) ---        	            	
 	
		}
 	