package cz.cuni.amis.pogamut.ut2004multi.communication.worldview;

import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.VisionLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.UT2004CompositeObjectCreator;

public class TestUTLocalWV extends VisionLocalWorldView{

	public TestUTLocalWV(ComponentDependencies dependencies, ILifecycleBus bus,
			IAgentLogger logger, ISharedWorldView parentWorldView,
			ITeamedAgentId agentId) {
		super(dependencies, bus, logger, parentWorldView, agentId);
	}
	
	@Override
	protected ICompositeWorldObject createCompositeObject(ILocalWorldObject localObject, ISharedWorldObject sharedObject, IStaticWorldObject staticObject)
	{
		if ( (localObject == null) || ( sharedObject == null ) || (staticObject == null) )
		{
			return null;
		}
		//System.out.println("Correct method.");
		return UT2004CompositeObjectCreator.createObject(localObject, sharedObject, staticObject);
	}

}
