/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.samples;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.module.logic.USAR2004BotLogicController;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ConfigMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.GeometryMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.ResponseModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.SensorSpecificModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.StateMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.nfo.NfoStartPoses;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorHelper;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SensorLaser;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.TraceColor;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.MissionPackage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Multidrive;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.SetCamera;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Trace;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.utils.USAR2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;

@AgentScoped
public class LeggedLogicSampleRobot
extends USAR2004BotLogicController<USAR2004Bot> {
    private final double descendingLatch = 0.05f;
    private final double descendingRate = 0.5;
    private final double steerRate = 0.4f;
    private final int submarineLevel = 4;
    private boolean parametersObtained = false;
    private double maxRudderAngle = 0.0;
    private double maxSternPlaneAngle = 0.0;
    private double maxPropellerSpeed = 0.0;
    private double cameraMaxFov = 0.0;
    private double cameraMinFov = 0.0;
    private double cameraActFov = 0.0;
    private double cameraInc = 0.01f;
    private String cameraName = "";
    private String cameraType = "";
    private double laserRange = 0.0;
    private double laserTime = 0.0;
    private double previousLaserRange = 0.0;
    private double previousLaserTime = 0.0;
    private double cameraRotationSpeed = 0.0;
    private double cameraTilt = 0.0;
    private double cameraTiltInc = this.cameraInc;
    private double cameraMaxTilt = 0.0;
    private double cameraMinTilt = 0.0;
    private String mispkgName = "";
    private double time = 0.0;
    private double headTilt = 0.0;
    private int runCount = 0;
    private int turnCount = 0;
    private int walkCount = 0;
    private NfoStartPoses startPoses;
    private SensorLaser laserSensor;
    private GeometryMasterModule geoModule;
    private ConfigMasterModule confModule;
    private ResponseModule resModule;
    private StateMasterModule staModule;
    private SensorSpecificModule<SensorHelper> helperSensor;

    @Override
    public void robotInitialized(NfoMessage nfom) {
        super.robotInitialized(nfom);
        this.logicInitialize(this.logicModule);
        this.bot.getAct().act((CommandMessage)new Initialize("USARBot.ERS", "ERS - legged sample robot", "PlayerStart", "RED", null));
        this.bot.getAct().act((CommandMessage)new Trace(true, 2.0, TraceColor.YELLOW));
        System.out.println(this.logicModule.isRunning());
    }

    @Override
    public void initializeController(USAR2004Bot bot) {
        super.initializeController(bot);
    }

    @Override
    public void logic() throws PogamutException {
        super.logic();
        if (!this.helperSensor.isReady().booleanValue()) {
            return;
        }
        if (this.helperSensor.getModule().isVisible()) {
            this.turnHead(this.helperSensor.getModule().getPos2D().y);
        } else {
            this.headTilt = 0.0;
            this.turnHead(0.0);
        }
        if (this.helperSensor.getModule().getPos2D().x > 100.0) {
            this.turn(0);
        } else {
            this.turn(1);
        }
    }

    private void turnHead(double value) {
        this.headTilt = value < 100.0 ? (this.headTilt += (double)0.05f) : (this.headTilt -= (double)0.05f);
        this.bot.getAct().act((CommandMessage)new Multidrive("HA", String.valueOf(this.headTilt)));
    }

    private void run() {
        String[] values;
        String[] names;
        ++this.runCount;
        switch (this.runCount) {
            case 1: {
                names = new String[]{"LRA", "LRB", "LRC", "RRA", "RRB", "RRC", "LFA", "LFB", "LFC", "RFA", "RFB", "RFC"};
                values = new String[]{"0.1", "0.1", "0.5", "0.1", "0.1", "0.5", "0.1", "0.1", "0.4", "0.1", "0.1", "0.4"};
                break;
            }
            case 2: {
                names = new String[]{"LRA", "LRB", "LRC", "RRA", "RRB", "RRC", "LFA", "LFB", "LFC", "RFA", "RFB", "RFC"};
                values = new String[]{"-0.2", "0.3", "-0.6", "-0.2", "0.3", "-0.6", "-0.4", "0.2", "-0.3", "-0.4", "0.2", "-0.3"};
                break;
            }
            default: {
                names = new String[]{"LFA"};
                values = new String[]{"0"};
            }
        }
        this.bot.getAct().act((CommandMessage)new Multidrive(names, values));
        if (this.runCount > 1) {
            this.runCount = 0;
        }
    }

    private void turn(int dir) {
        String[] values;
        String[] names;
        String[] lv = new String[]{"-0.1", "0.1", "-0.3", "-0.6"};
        String[] rv = new String[]{"0.1", "-0.1", "-0.6", "-0.3"};
        String[] sv = new String[]{"-0.1", "-0.1", "-0.3", "-0.3"};
        String[] av = dir == 0 ? lv : (dir == 1 ? rv : sv);
        ++this.turnCount;
        switch (this.turnCount) {
            case 1: 
            case 2: {
                names = new String[]{"LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "RRB"};
                values = new String[]{"0.1", av[0], "0.5", "-0.4", "0.2", av[3], "-0.1"};
                break;
            }
            case 5: 
            case 6: {
                names = new String[]{"LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "LRB"};
                values = new String[]{"-0.4", "0.2", av[2], "0.1", av[1], "0.5", "-0.1"};
                break;
            }
            case 3: 
            case 4: {
                names = new String[]{"LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "LFA", "LFB", "LFC"};
                values = new String[]{"-0.2", "0.3", "-0.6", "0.1", "0.1", "0.4", "0", "0", "0"};
                break;
            }
            case 7: 
            case 8: {
                names = new String[]{"LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "RFA", "RFB", "RFC"};
                values = new String[]{"0.1", "0.1", "0.4", "-0.2", "0.3", "-0.6", "0", "0", "0"};
                break;
            }
            default: {
                names = new String[]{"LFA"};
                values = new String[]{"0"};
            }
        }
        this.bot.getAct().act((CommandMessage)new Multidrive(names, values));
        if (this.turnCount > 7) {
            this.turnCount = 0;
        }
    }

    private void walk() {
        String[] values;
        String[] names;
        ++this.walkCount;
        switch (this.walkCount) {
            case 1: 
            case 2: {
                names = new String[]{"LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "RRB"};
                values = new String[]{"0.1", "0.1", "0.5", "-0.4", "0.2", "-0.3", "-0.1"};
                break;
            }
            case 5: 
            case 6: {
                names = new String[]{"LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "LRB"};
                values = new String[]{"-0.4", "0.2", "-0.3", "0.1", "0.1", "0.5", "-0.1"};
                break;
            }
            case 3: 
            case 4: {
                names = new String[]{"LRA", "LRB", "LRC", "RFA", "RFB", "RFC", "LFA", "LFB", "LFC"};
                values = new String[]{"-0.2", "0.3", "-0.6", "0.1", "0.1", "0.4", "0", "0", "0"};
                break;
            }
            case 7: 
            case 8: {
                names = new String[]{"LFA", "LFB", "LFC", "RRA", "RRB", "RRC", "RFA", "RFB", "RFC"};
                values = new String[]{"0.1", "0.1", "0.4", "-0.2", "0.3", "-0.6", "0", "0", "0"};
                break;
            }
            default: {
                names = new String[]{"LFA"};
                values = new String[]{"0"};
            }
        }
        this.bot.getAct().act((CommandMessage)new Multidrive(names, values));
        if (this.walkCount > 7) {
            this.walkCount = 0;
        }
    }

    private void rotateCamera() {
        if (this.cameraTilt >= this.cameraMaxTilt || this.cameraTilt <= this.cameraMinTilt) {
            this.cameraTiltInc *= -1.0;
        }
        this.cameraTilt += this.cameraTiltInc;
        int[] links = new int[]{1, 2};
        double[] values = new double[]{this.cameraRotationSpeed, this.cameraTilt};
        int[] orders = new int[]{1, 0};
        this.bot.getAct().act((CommandMessage)new MissionPackage(this.mispkgName, links, values, orders));
    }

    private void zoomCamera() {
        if (this.cameraActFov >= this.cameraMaxFov || this.cameraActFov <= this.cameraMinFov) {
            this.cameraInc *= -1.0;
        }
        this.cameraActFov += this.cameraInc;
        this.bot.getAct().act((CommandMessage)new SetCamera(this.cameraType, this.cameraName, this.cameraActFov));
    }

    @Override
    public void prepareBot(USAR2004Bot bot) {
        super.prepareBot(bot);
        this.geoModule = GeometryMasterModule.getModuleInstance(bot);
        this.confModule = ConfigMasterModule.getModuleInstance(bot);
        this.resModule = ResponseModule.getModuleInstance(bot);
        this.staModule = StateMasterModule.getModuleInstance(bot);
        this.helperSensor = new SensorSpecificModule<SensorHelper>(bot, SensorHelper.class);
    }

    public static void main(String[] args) {
        new USAR2004BotRunner(LeggedLogicSampleRobot.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.OFF).startAgent();
    }
}

