package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

import cz.cuni.amis.pogamut.base3d.worldview.object.*;
import java.awt.*;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;

public class ScanPreview extends javax.swing.JFrame
{
    public void runScanPreview()
    {
        setTitle("Scan Preview");
        setVisible(true);
    }

    /**
     * Creates new form ScanPreview
     */
    public ScanPreview()
    {
        initComponents();
        data = ToolBox.initArray(startSize, startSize);
        initBlackImage(tmp);
    }
    private int dataArrayXLimit;
    private int dataArrayYLimit;
    private int offsetX = 0;
    private int offsetY = 0;
    private final int extension = 400;
    private final int extLimit = 100;

    /**
     * This wathes over the preview bitmap and array of heights during
     * simulation to prevent writing outside the structures. If it wants to
     * write outside this will resize the image and the array.
     *
     * @param x X coordinate.
     * @param y Y coordinate.
     * @return Reutrns true if the data is in limit.
     */
    private boolean keepDataArrayGreat(int x, int y)
    {
        if(x > dataArrayXLimit)
        {
            tmp = ToolBox.resizeImage(tmp, extension, 0, 0, 0);
            tmpG = tmp.createGraphics();
            data = ToolBox.resizeArray(data, extension, 0, 0, 0);
            dataArrayXLimit = tmp.getWidth() - extLimit;
            return true;
        }
        else if(x < tmp.getWidth() - dataArrayXLimit)
        {
            tmp = ToolBox.resizeImage(tmp, extension, 0, extension, 0);
            tmpG = tmp.createGraphics();
            data = ToolBox.resizeArray(data, extension, 0, extension, 0);
            dataArrayXLimit = tmp.getWidth() - extLimit;
            offsetX += extension;
            translate.x -= extension;
            return true;
        }
        if(y > dataArrayYLimit)
        {
            tmp = ToolBox.resizeImage(tmp, 0, extension, 0, 0);
            tmpG = tmp.createGraphics();
            data = ToolBox.resizeArray(data, 0, extension, 0, 0);
            dataArrayYLimit = tmp.getHeight() - extLimit;
            return true;
        }
        else if(y < tmp.getHeight() - dataArrayYLimit)
        {
            tmp = ToolBox.resizeImage(tmp, 0, extension, 0, extension);
            tmpG = tmp.createGraphics();
            data = ToolBox.resizeArray(data, 0, extension, 0, extension);
            dataArrayYLimit = tmp.getHeight() - extLimit;
            offsetY += extension;
            translate.y -= extension;
            return true;
        }
        return false;
    }

    private void initBlackImage(BufferedImage tmp)
    {
        tmpG.setColor(Color.BLACK);
        tmpG.fillRect(0, 0, tmp.getWidth(), tmp.getHeight());

        offsetX = tmp.getWidth() / 2;
        offsetY = tmp.getHeight() / 2;
        dataArrayXLimit = tmp.getWidth() - extLimit;
        dataArrayYLimit = tmp.getHeight() - extLimit;
        this.translate = new Point(this.getWidth() / 2 - offsetX, this.getHeight() / 2 - offsetY);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Scan viewer");
        setBackground(new java.awt.Color(51, 51, 51));
        setForeground(java.awt.Color.white);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                formKeyPressed(evt);
            }
        });

        jLabel1.setBackground(new java.awt.Color(255, 255, 255));
        jLabel1.setText("jLabel1");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(796, Short.MAX_VALUE)
                .addComponent(jLabel1)
                .addGap(227, 227, 227))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addContainerGap(717, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formKeyPressed(java.awt.event.KeyEvent evt)//GEN-FIRST:event_formKeyPressed
    {//GEN-HEADEREND:event_formKeyPressed
        switch(evt.getKeyCode())
        {
            case 37:
                translate.x += 10;
                break;
            case 39:
                translate.x -= 10;
                break;
            case 40:
                translate.y -= 10;
                break;
            case 38:
                translate.y += 10;
                break;
        }
    }//GEN-LAST:event_formKeyPressed

    /**
     * On closing we save the image to file and we generate text output as well.
     *
     * @param evt
     */
    private void formWindowClosing(java.awt.event.WindowEvent evt)//GEN-FIRST:event_formWindowClosing
    {//GEN-HEADEREND:event_formWindowClosing
        int counter = 0;
        File directory = new File(System.getProperty("user.home") + "\\Desktop\\USAR_Scans\\");
        File file;
        do
        {
            if(!directory.exists())
            {
                directory.mkdir();
            }
            file = new File(System.getProperty("user.home") + "\\Desktop\\USAR_Scans\\img" + ((counter < 10)?"0" + counter:counter) + ".png");
            counter++;
        }
        while(file.exists());
        saveImage(createImage(file.getAbsolutePath()), file);
    }//GEN-LAST:event_formWindowClosing
    private final int border = 20;

    /**
     * Estimates the left bound of valid data.
     *
     * @return Returns left edge of recorded data.
     */
    private int getDataLeftMargin()
    {
        for(int i = border; i < data.length; i++)
        {
            for(int j = 0; j < data[i].length; j++)
            {
                if(data[i][j] != Double.MIN_VALUE)
                {
                    return i - border;
                }
            }
        }
        return data.length / 2;
    }

    /**
     * Estimates the right bound of valid data.
     *
     * @return Returns right edge of recorded data.
     */
    private int getDataRightMargin()
    {
        for(int i = data.length - border - 1; i >= 0; i--)
        {
            for(int j = 0; j < data[i].length; j++)
            {
                if(data[i][j] != Double.MIN_VALUE)
                {
                    return i + border;
                }
            }
        }
        return data[0].length / 2;
    }

    /**
     * Estimates the top bound of valid data.
     *
     * @return Returns top edge of recorded data.
     */
    private int getDataTopMargin()
    {
        for(int i = border; i < data[0].length; i++)
        {
            for(int j = 0; j < data.length; j++)
            {
                if(data[j][i] != Double.MIN_VALUE)//data[i][j] > Double.MIN_VALUE)
                {
                    return i - border;
                }
            }
        }
        return data.length / 2;
    }

    /**
     * Estimates the bottom bound of valid data.
     *
     * @return Returns lower edge of recorded data.
     */
    private int getDataBottomMargin()
    {
        for(int i = data[0].length - border - 1; i >= 0; i--)
        {
            for(int j = 0; j < data.length; j++)
            {
                if(data[j][i] != Double.MIN_VALUE)
                {
                    return i + border;
                }
            }
        }
        return data.length / 2;
    }
    private final int infoPanelWidth = 280;
//    private int getImportantPartIndex(int importance)
//    {
//        for(int i = histogram.length - 1; i >= histogram.length / 2; i--)
//        {
//            if(histogram[i] > importance)
//            {
//                return i;
//            }
//        }
//        return histogram.length / 2;
//    }
    private boolean datFile = false;

    /**
     * Creates a final output image from collected data.
     *
     * @param path Specifies the location of the output.
     */
    private BufferedImage createImage(String path)
    {
        int left = getDataLeftMargin();
        int top = getDataTopMargin();
        int width = Math.max(getDataRightMargin() - left + 1, minWidth);
        int height = Math.max(getDataBottomMargin() - top + 1, minHeight);
        tmpG.drawRect(left, top, width - 1, height - 1);

        BufferedImage img = new BufferedImage(width + infoPanelWidth, height, BufferedImage.TYPE_INT_ARGB);//257 = histogram
        Graphics2D g = img.createGraphics();
        Graphics gr = g.create();

        gr.setColor(Color.BLACK);
        gr.fillRect(0, 0, img.getWidth(), img.getHeight());



        ByteBuffer buf = ByteBuffer.allocate((width + 1) * (height + 1) * 8);

        //offset and scale match 255 shades according to max and min value obtained while scanning
        double shift = 0 - dMin;
        double scale = 255 / (shift + dMax / 2);//*7/4;//posunutí spektra o polovinu-zvýrazní se malé změnu u země(pahorkatina)->zmizí extrémní odchylky, které tvoří stromy.
        for(int i = left; i < width + left; i++)
        {
            for(int j = top; j < height + top; j++)
            {
                //Double.MIN_VALUE means no value was scanned at that point. We represent this situation by BLACK color
                if(data[i][j] == Double.MIN_VALUE)
                {
                    img.setRGB(i - left + infoPanelWidth, j - top, Color.BLACK.getRGB());
                }
                else
                {
                    img.setRGB(i - left + infoPanelWidth, j - top, convertToGray(data[i][j], shift, scale).getRGB());
                }

                if(datFile)
                {
                    buf.putDouble(data[i][j]);
                    //buf.putFloat((float)data[i][j]);
                }
            }
            if(datFile)
            {
                buf.putDouble(Double.MAX_VALUE);//end of line
                //buf.putFloat(Float.MAX_VALUE);
            }
        }
        drawHistogram(g);
        //drawObstacles(g.create(), (offsetX - left) + infoPanelWidth, offsetY - top);
        drawRobotPath(g.create(), (offsetX - left) + infoPanelWidth, offsetY - top);
        drawControlPoints(g.create(), (offsetX - left) + infoPanelWidth, offsetY - top);
        drawLegend(g.create());

        if(datFile)
        {
            try
            {
                FileOutputStream ostream = new FileOutputStream(path.substring(0, path.length() - 3).concat("dat"), false);
                GZIPOutputStream str = new GZIPOutputStream(ostream);
                str.write(buf.array(), 0, buf.array().length);
                str.finish();
                str.close();
                ostream.close();
            }
            catch(IOException ex)
            {
                Logger.getLogger(ScanPreview.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        return img;
    }

    /**
     * Draws a histogram of used colors(shades of gray) at [10,10] 255px wide,
     * 100px tall.
     *
     * @param g Graphics to draw histogram to.
     */
    private void drawHistogram(Graphics2D g)
    {
        int max = ToolBox.getMax(histogram);

        g.setPaint(Color.GREEN);
        Shape rect = new Rectangle2D.Double(9, 9, 257, 102);
        g.fill(rect);
        for(int i = 0; i < histogram.length; i++)
        {
            int count = histogram[i];
            drawImageLine(i + 10, 10, i + 10, (double) count * 100 / (double) max + 10, new Color(i, i, i), g);
        }
    }

    /**
     * Draws points and meaning of it to the final ouptput map.
     *
     * @param g Graphics to draw data to.
     */
    private void drawLegend(Graphics g)
    {
        Location corner = new Location(20, 140);
        int spacing = 20;
        int yOffset = 0;
        drawStartPose(g, Location.ZERO, (int) corner.x, (int) corner.y + yOffset);
        drawString(g, "Landing/Recharging Point", (int) corner.x + spacing, (int) corner.y + yOffset);
        yOffset += 25;
        drawRechargePoint(g, Location.ZERO, (int) corner.x, (int) corner.y + yOffset);
        drawString(g, "Recharge Needed Location", (int) corner.x + spacing, (int) corner.y + yOffset);
        yOffset += 25;
        drawDiversion(g, Location.ZERO, (int) corner.x, (int) corner.y + yOffset);
        drawString(g, "Diversion Point", (int) corner.x + spacing, (int) corner.y + yOffset);
        yOffset += 25;
        drawHighRisk(g, Location.ZERO, (int) corner.x, (int) corner.y + yOffset);
        drawString(g, "HighRisk Situation", (int) corner.x + spacing, (int) corner.y + yOffset);
        yOffset += 25;
        drawLowRisk(g, Location.ZERO, (int) corner.x, (int) corner.y + yOffset);
        drawString(g, "LowRisk Situation", (int) corner.x + spacing, (int) corner.y + yOffset);
        yOffset += 25;
        drawPathDot(g, Location.ZERO, (int) corner.x, (int) corner.y + yOffset);
        drawString(g, "Robot Path Point", (int) corner.x + spacing, (int) corner.y + yOffset);
        yOffset += 25;
        g.setColor(Color.WHITE);
        drawData(g, (int) corner.x + spacing, (int) corner.y + yOffset);

    }

    /**
     * Final information about the scanning is written by this method.
     *
     * @param g Graphics to draw data to.
     * @param x X offset.
     * @param y Y offset.
     */
    private void drawData(Graphics g, int x, int y)
    {
        g.setColor(Color.WHITE);
        for(String line : postInfo.split("\n"))
        {
            g.drawString(line, x, y += g.getFontMetrics().getHeight());
        }
    }

//    private void drawObstacles(Graphics g, int offsetX, int offsetY)
//    {
//        g.setColor(Color.PINK);
//        for(Iterator<Obstacle1> it = obstacles.iterator(); it.hasNext();)
//        {
//            Obstacle1 obstacle = it.next();
//            g.drawRect((int) (obstacle.getCorner().x * drawScale) + offsetX, (int) (obstacle.getCorner().y * drawScale) + offsetY, (int) (obstacle.getWidth() * drawScale), (int) (obstacle.getHeight() * drawScale));
//        }
//    }
    /**
     * Drawing of points that testify the robot situations.
     *
     * @param g Graphics to draw to.
     * @param offsetX X offset.
     * @param offsetY Y offset.
     */
    private void drawControlPoints(Graphics g, int offsetX, int offsetY)
    {
        for(Location location : robotRechargePoints)
        {
            drawRechargePoint(g, location, offsetX, offsetY);
        }
        for(Location location : robotDiversions)
        {
            drawDiversion(g, location, offsetX, offsetY);
        }
        for(Location location : robotStartPoints)
        {
            drawStartPose(g, location, offsetX, offsetY);
        }
        for(Location location : robotLowRiskPoints)
        {
            drawLowRisk(g, location, offsetX, offsetY);
        }
        for(Location location : robotHighRiskPoints)
        {
            drawHighRisk(g, location, offsetX, offsetY);
        }
    }

    /**
     * Every recorded point is drawn to show where the robot was moving
     *
     * @param g Graphics to draw to.
     * @param offsetX X offset.
     * @param offsetY Y offset.
     */
    private void drawRobotPath(Graphics g, int offsetX, int offsetY)
    {
        for(Location location : robotPath)
        {
            drawPathDot(g, location, offsetX, offsetY);
        }
    }

    /**
     * Saves an image to file system at specified path.
     *
     * @param img Image to save.
     * @param path Path to save image to.
     */
    public void saveImage(BufferedImage img, File outputfile)
    {
        try
        {
            if(outputfile.createNewFile())
            {
                ImageIO.write(img, "png", outputfile);
            }
            else
            {
                System.out.println("Couldnt creaate file");
            }
        }
        catch(IOException e)
        {
            System.out.println(e.getCause());
        }
    }
    private final int minWidth = 200;
    private final int minHeight = 350;
    int[] histogram = new int[256];
    double dMax = Double.MIN_VALUE;
    double dMin = Double.MAX_VALUE;
    public Point translate;
    public Record record;
    public Record recordPrev;
    Rotation rot;// = new Rotation(0,0,0);
    Rotation rotPrev;// = new Rotation(0,0,0);
    Location loc;// = new Location(0,0,0);
    Location locPrev;// = new Location(0,0,0);
    int offset = 0;
    List<Obstacle1> obstacles = new ArrayList<Obstacle1>();
    List<Location> robotPath = new ArrayList<Location>();
    List<Location> robotDiversions = new ArrayList<Location>();
    List<Location> robotRechargePoints = new ArrayList<Location>();
    List<Location> robotStartPoints = new ArrayList<Location>();
    List<Location> robotHighRiskPoints = new ArrayList<Location>();
    List<Location> robotLowRiskPoints = new ArrayList<Location>();
    Collection<Double> sonars;
    private String actInfo = "";
    private String postInfo = "";
    private final double rangeLimit = 19.9;
    private final int drawScale = 6;
    private final int panelWidth = 45 * drawScale;
    //private final int panelHeight = 70 * drawScale;
    private final Point2D pos = new Point((int) (panelWidth / 2), 50);
    private final List<Double> highRisk = new ArrayList<Double>()
    {
        
        {
            add(0.47d);
            add(0.61d);
            add(0.86d);
            add(1.22d);
            add(1.5d);
            add(1.22d);
            add(0.86d);
            add(0.61d);
            add(0.47d);
        }
    };
    private final List<Double> lowRisk = new ArrayList<Double>()
    {
        
        {
            add(1.57d);
            add(1.91d);
            add(2.72d);
            add(3.5d);
            add(4.5d);
            add(3.5d);
            add(2.72d);
            add(1.91d);
            add(1.57d);
        }
    };
    private final int startSize = 500;
    BufferedImage tmp = new BufferedImage(startSize, startSize, BufferedImage.TYPE_INT_ARGB);
    Graphics2D tmpG = tmp.createGraphics();
    double[][] data;

    /**
     * Red is for invalid range, Blue is for valid range and magenta is for the
     * rays from which the altitude of the robot is estimated.
     *
     * @param range Range of a ray to draw.
     * @param index Index of a ray to draw.
     * @return Returns either one of Magenta, Blue and Red according to input
     * properties.
     */
    private Color getScanColor(double range, int index)
    {
        if(index >= offset + 85 && index <= offset + 95)
        {
            return Color.MAGENTA;
        }
        else if(range <= rangeLimit)
        {
            return Color.BLUE;
        }
        else
        {
            return Color.RED;
        }
    }
    Image backBuffer;

    /**
     * Checking the second buffer for resizing and that it exists.
     */
    private void checkOffscreenImage()
    {
        Dimension d = getSize();
        if(backBuffer == null || backBuffer.getWidth(null) != d.width
                || backBuffer.getHeight(null) != d.height)
        {
            backBuffer = createImage(d.width, d.height);
        }
    }

    /**
     * Double buffered system of repainting takes place here.
     *
     * @param sharpGraphics Graphics to show.
     */
    @Override
    public void paint(Graphics sharpGraphics)
    {
        //super.paint(g);
        Dimension d = getSize();
        checkOffscreenImage();
        Graphics backGraphics = backBuffer.getGraphics();
        backGraphics.setColor(getBackground());
        backGraphics.fillRect(0, 0, d.width, d.height);
        // Draw into the offscreen image.
        paintSituation(backGraphics);
        // Put the offscreen image on the screen.
        sharpGraphics.drawImage(backBuffer, 0, 0, null);
    }

    /**
     * For each ray from the Range scanner range list there is a height computed
     * and recorded. For more coherent data between each ray there is one
     * aproximated and between every two records there is one aproximated as
     * well. So we have artificially doubled the resolution of the scanner and
     * doubeled the sample rate. All auxiliary data are drawn also here.
     *
     * @param g Graphics to draw to.
     */
    private void paintSituation(Graphics g)
    {
        if(recordPrev == null)
        {
            return;
        }
        g.drawImage(tmp, translate.x, translate.y, null);


        g.setColor(Color.white);
        g.fillRect(0, 0, panelWidth, getSize().height);//(int) pos.getX() - panelWidth/2 * drawScale, (int) pos.getY() - panelWidth/2 * drawScale, (int) (2*panelWidth * drawScale), (int) (panelHeight * drawScale));

        drawSonars(g);
        drawInfo(g, 20, 450);


        double angle = 90 + ((record.getFOV() / 2 - rot.roll) * 180 / Math.PI);//angle of the first ray(90°=straight down+FOV/2, but we have to count the robot pitch!)
        double anglePrev = 90 + ((record.getFOV() / 2 - rotPrev.roll) * 180 / Math.PI);//angle of the first ray(90°=straight down+FOV/2, but we have to count the robot pitch!)

        if(Math.abs(angle - anglePrev) > 180) //abychom mohli udělat aritmetickej průměr, jinak mám -178.9 a 178.8 třeba a výjde mi nesmysl. A to díky rotaci, která je napravo >0 a nalevo <6.28
        {
            anglePrev *= -1;
        }
        //Point2D pos=record.getPosition();
        for(int i = 0; i < record.getRanges().size(); i++)
        {
            double range = record.getRanges().get(i);
            double rangePrev = recordPrev.getRanges().get(i);
            double value;
            if(range < rangeLimit && rangePrev < rangeLimit)
            {
                value = (range + rangePrev) / 2;
            }
            else if(range < rangeLimit)
            {
                value = range;
            }
            else
            {
                value = rangePrev;
            }

            issueRay(g, i, range, angle, loc, rot);
            issueRay(g, i, value, (anglePrev + angle) / 2, getMidPoint(loc, locPrev), getMidTurn(rot, rotPrev));
            angle -= (record.getFOV() / Math.PI * 180 / record.getRanges().size()) / 2;
            anglePrev -= (recordPrev.getFOV() / Math.PI * 180 / recordPrev.getRanges().size()) / 2;

            if(i == 0)
            {
                continue;
            }

            angle -= (record.getFOV() / Math.PI * 180 / record.getRanges().size()) / 2;
            anglePrev -= (recordPrev.getFOV() / Math.PI * 180 / recordPrev.getRanges().size()) / 2;

            range = (record.getRanges().get(i) + record.getRanges().get(i - 1)) / 2;
            rangePrev = (recordPrev.getRanges().get(i) + recordPrev.getRanges().get(i)) / 2;
            value = (range + rangePrev) / 2;
            issueRay(g, i - 1, range, angle, loc, rot);
            issueRay(g, i - 1, value, (anglePrev + angle) / 2, getMidPoint(loc, locPrev), getMidTurn(rot, rotPrev));



            //angle -= record.getFOV() / Math.PI * 180 / record.getRanges().size();
            //anglePrev -= recordPrev.getFOV() / Math.PI * 180 / recordPrev.getRanges().size();

        }

        //tmpG.setColor(Color.RED);
        //tmpG.drawOval((int) (drawScale * loc.x) + tmp.getWidth() / 2, (int) (drawScale * loc.y) + tmp.getHeight() / 2, 2, 2);
        g.setColor(Color.GREEN);
        //g.drawLine(0, 0, (int) (range * 10), (int) (range * 10));

        //drawObstacles(g, this.getWidth() / 2, this.getHeight() / 2);

        //this.drawLine(g, loc.x * 10 + Math.sin(rot.yaw) * 10 + 100, loc.y * 10 - Math.cos(rot.yaw) * 10 + 100, loc.x * 10 - Math.sin(rot.yaw) * 10 + 100, loc.y * 10 + Math.cos(rot.yaw) * 10 + 100);

    }

    /**
     * Utilizes all possible information from one ray. Draws a situtaion in the
     * left white stripe and records data to scanning preview. Ranges longer
     * than 19.5 are ignoret for the range scanner has range of 20-noise.
     *
     * @param g Graphics to write to.
     * @param index Index of the ray.
     * @param range Range measured.
     * @param angle Angle of the ray.
     * @param loc Robot's location.
     * @param rot Robot's orientation.
     */
    public void issueRay(Graphics g, int index, double range, double angle, Location loc, Rotation rot)
    {
        //TODO:mezi každýma dvěma body v lajně udělat jeden průměrovanej
        double x = Math.cos(angle * Math.PI / 180) * range * drawScale;//distance from the center
        double y = Math.sin(angle * Math.PI / 180) * range * drawScale;//distance from the aircraft
        double xOffset = Math.sin(rot.pitch) * y;//offset due to yaw of an aircraft
        double z = Math.cos(rot.pitch) * y;//real range            
        int height = (int) (loc.z * drawScale - z + 10 * drawScale) * 255 / 20 / (int) drawScale; //we have to be aware of the fact, that the aircraft can pitch, therefore we can get a height value greater than the maxRange of the laser scanner(which is the twenty)
        //angle -= record.getFOV() / Math.PI * 180 / record.getRanges().size();

        Color c = getScanColor(range, index);
        this.drawLine(g, c, pos.getX(), pos.getY(), (pos.getX() - x), (pos.getY() + y));


//        if(loc.z * drawScale - z > 5.8 * drawScale && range < rangeLimit)
//        {
//            addObstacle(loc.x - Math.sin(rot.yaw) * (x / drawScale) - Math.cos(rot.yaw) * xOffset / drawScale,
//                        loc.y + Math.cos(rot.yaw) * (x / drawScale) - Math.sin(rot.yaw) * xOffset / drawScale);
////                g.drawRect((int) ((loc.x-0.5) * drawScale - Math.sin(rot.yaw) * (x) - Math.cos(rot.yaw) * xOffset + this.getWidth() / 2),
////                        (int) ((loc.y-0.5) * drawScale + Math.cos(rot.yaw) * (x) - Math.sin(rot.yaw) * xOffset + this.getHeight() / 2), drawScale, drawScale);
////                g.drawOval((int) (loc.x * drawScale - Math.sin(rot.yaw) * (x) - Math.cos(rot.yaw) * xOffset + this.getWidth() / 2),
////                           (int) (loc.y * drawScale + Math.cos(rot.yaw) * (x) - Math.sin(rot.yaw) * xOffset + this.getHeight() / 2), 5, 5);
//        }
        height = Math.max(height, 0);
        height = Math.min(height, 255);

        if(range <= rangeLimit)
        {
            this.drawLine(g, new Color(height, height, height), pos.getX() - x, 40 * drawScale, pos.getX() - x, 40 * drawScale - (loc.z * drawScale - z));
            this.drawPoint(tmpG, new Color(height, height, height),
                           loc.x * drawScale - Math.sin(rot.yaw) * (x) - Math.cos(rot.yaw) * xOffset + offsetX,
                           loc.y * drawScale + Math.cos(rot.yaw) * (x) - Math.sin(rot.yaw) * xOffset + offsetY);


            //actual location + rotation coeficient of the point - yaw coeficient -which is xOffset
//                g.setColor(new Color(height2, height2, height2));
//                this.drawLine(tmpG, (loc.x+locPrev.x)/2 * drawScale - Math.sin((rotPrev.yaw+rot.yaw)/2) * (x+x2)/2 - Math.cos((rot.yaw+rotPrev.yaw)/2) *(xOffset+xOffset2)/2 + tmpG.getWidth()/2,
//                                 (locPrev.y+loc.y)/2 * drawScale + Math.cos((rotPrev.yaw+rot.yaw)/2) * (x+x2)/2 - Math.sin((rot.yaw+rotPrev.yaw)/2) *(xOffset+xOffset2)/2+ tmpG.getHeight()/2,
//                                 (locPrev.x+loc.x)/2 * drawScale - Math.sin((rot.yaw+rotPrev.yaw)/2) * (x+x2)/2 - Math.cos((rot.yaw+rotPrev.yaw)/2) *(xOffset+xOffset2)/2+ tmpG.getWidth()/2,
//                                 (locPrev.y+loc.y)/2 * drawScale + Math.cos((rot.yaw+rotPrev.yaw)/2) * (x+x2)/2 - Math.sin((rot.yaw+rotPrev.yaw)/2) *(xOffset+xOffset2)/2+ tmpG.getHeight()/2);
            setDataAt(loc.x * drawScale - Math.sin(rot.yaw) * (x) - Math.cos(rot.yaw) * xOffset + offsetX,
                      loc.y * drawScale + Math.cos(rot.yaw) * (x) - Math.sin(rot.yaw) * xOffset + offsetY, loc.z * drawScale - z);

        }
    }

    /**
     * Computes a location that is between two input ones.
     *
     * @param locA First Location.
     * @param locB Second Location.
     * @return Returns location that is between locA and locB.
     */
    private Location getMidPoint(Location locA, Location locB)
    {
        double x = locA.x + locB.x;
        double y = locA.y + locB.y;
        double z = locA.z + locB.z;
        return new Location(x / 2, y / 2, z / 2);
    }

    /**
     * The angle is 0-2PI and this takes into account the closest angle possible
     * from a circle.
     *
     * @param value1 First angle.
     * @param value2 Second angle.
     * @return Returns angle between value1 and value2
     */
    private double getMidAngle(double value1, double value2)
    {
        double val;
        if(value1 > 6 && value2 < 0.28)
        {
            val = (value1 - 2 * Math.PI + value2) / 2;
        }
        else if(value2 > 6 && value1 < 0.28)
        {
            val = (value2 - 2 * Math.PI + value1) / 2;
        }
        else
        {
            val = (value1 + value2) / 2;
        }

        if(val < 0)
        {
            val += 2 * Math.PI;
        }
        return val;
    }

    /**
     * Returns a rotation that is between the specified input ones.
     *
     * @param rotA First rotation.
     * @param rotB Second rotation.
     * @return Returns rotation between rotA and rotB.
     */
    private Rotation getMidTurn(Rotation rotA, Rotation rotB)
    {
        double pitch = getMidAngle(rotA.pitch, rotB.pitch);
        double yaw = getMidAngle(rotA.yaw, rotB.yaw);
        double roll = getMidAngle(rotA.roll, rotB.roll);
        return new Rotation(pitch, yaw, roll);
    }

    /**
     * Draws information string to a grahpics.
     *
     * @param g Graphics to use.
     * @param x X coordinate.
     * @param y Y coordinate.
     */
    private void drawInfo(Graphics g, int x, int y)
    {
        g.setColor(Color.BLACK);
        for(String line : actInfo.split("\n"))
        {
            g.drawString(line, x, y += g.getFontMetrics().getHeight());
        }
    }

    /**
     * Converts Height to corresponding shade of gray.
     *
     * @param data Height data to convert.
     * @param offset Offset of data(can be negative).
     * @param scale Difference between max and min height.
     * @return
     */
    private Color convertToGray(double data, double offset, double scale)
    {
        int height = (int) ((offset + data) * scale);
        height = Math.max(0, height);
        height = Math.min(255, height);
        histogram[height]++;
        return new Color(height, height, height);
    }

    /**
     * Sets a height to the array of heights. When overwriting existing value it
     * approximates both values.
     *
     * @param x X coordinate.
     * @param y Y coordinate.
     * @param data Recorded height - double number to write.
     */
    private void setDataAt(double x, double y, double data)
    {
        if(data > dMax)
        {
            dMax = data;
        }
        if(data < dMin)
        {
            dMin = data;
        }
        //pokud tam nic neni, tak zapiš, jinak udělej průměr z obou hodnot.
        //double prev = this.data[(int) x][(int) y];
        if(this.data[(int) x][(int) y] == Double.MIN_VALUE)
        {
            this.data[(int) x][(int) y] = data;
        }
        else
        {
            this.data[(int) x][(int) y] = (this.data[(int) x][(int) y] + data) / 2;
        }
    }

    /**
     * Specifies the style of writing that appears on the preview form and on
     * the final output image.
     *
     * @param g Graphics to use.
     * @param text String to write.
     * @param x X offset.
     * @param y Y offset.
     */
    private void drawString(Graphics g, String text, int x, int y)
    {
        g.drawChars(text.toCharArray(), 0, text.length(), x, y + g.getFontMetrics().getHeight() / 4);
    }

    /**
     * Specifies style of point to represent a point that is computed when
     * evading obstacles.
     *
     * @param g Graphics to use
     * @param diversion Center of the point to draw
     * @param offsetX Offset on x axis.
     * @param offsetY Offset on y axis.
     */
    private void drawDiversion(Graphics g, Location diversion, int offsetX, int offsetY)
    {
        g.setColor(Color.BLUE);
        g.fillRect((int) (diversion.x * drawScale + offsetX) - 2, (int) (diversion.y * drawScale + offsetY) - 2, 5, 5);
    }

    /**
     * Specifies style of point to represent a start position of the robot.
     *
     * @param g Graphics to use
     * @param startPose Center of the point to draw
     * @param offsetX Offset on x axis.
     * @param offsetY Offset on y axis.
     */
    private void drawStartPose(Graphics g, Location startPose, int offsetX, int offsetY)
    {
        g.setColor(Color.MAGENTA);
        g.drawOval(offsetX + (int) (startPose.x * drawScale) - 10, offsetY + (int) (startPose.y * drawScale) - 10, 20, 20);
//        g.drawOval(offsetX + (int) (startPose.x * drawScale) - 10, offsetY + (int) (startPose.y * drawScale) - 10, 20, 20);
//        g.drawOval(offsetX + (int) (startPose.x * drawScale) - 9, offsetY + (int) (startPose.y * drawScale) - 9, 18, 18);
//        g.drawOval(offsetX + (int) (startPose.x * drawScale) - 8, offsetY + (int) (startPose.y * drawScale) - 8, 16, 16);
    }

    /**
     * Specifies style of point to represent a point where the robot was
     * interrupted by low battery and a need to recharge.
     *
     * @param g Graphics to use
     * @param rechargePoint Center of the point to draw
     * @param offsetX Offset on x axis.
     * @param offsetY Offset on y axis.
     */
    private void drawRechargePoint(Graphics g, Location rechargePoint, int offsetX, int offsetY)
    {
        g.setColor(Color.YELLOW);
        g.fillRect(offsetX + (int) (rechargePoint.x * drawScale) - 3, offsetY + (int) (rechargePoint.y * drawScale) - 3, 6, 6);
        //g.fillRect(offsetX + (int) (rechargePoint.x * drawScale) - 5, offsetY + (int) (rechargePoint.y * drawScale) - 5, 10, 10);
    }

    /**
     * Specifies style of point to represent a low situation location of the
     * robot.
     *
     * @param g Graphics to use
     * @param lowRisk Center of the point to draw
     * @param offsetX Offset on x axis.
     * @param offsetY Offset on y axis.
     */
    private void drawLowRisk(Graphics g, Location lowRisk, int offsetX, int offsetY)
    {
        g.setColor(Color.orange);
        g.drawOval(offsetX + (int) (lowRisk.x * drawScale) - 1, offsetY + (int) (lowRisk.y * drawScale) - 1, 3, 3);
        //g.fillOval(offsetX + (int) (lowRisk.x * drawScale) - 3, offsetY + (int) (lowRisk.y * drawScale) - 3, 6, 6);
    }

    /**
     * Specifies style of point to represent a high situation location of the
     * robot.
     *
     * @param g Graphics to use
     * @param highRisk Center of the point to draw
     * @param offsetX Offset on x axis.
     * @param offsetY Offset on y axis.
     */
    private void drawHighRisk(Graphics g, Location highRisk, int offsetX, int offsetY)
    {
        g.setColor(Color.red);
        g.drawOval(offsetX + (int) (highRisk.x * drawScale) - 2, offsetY + (int) (highRisk.y * drawScale) - 2, 4, 4);
        //g.fillOval(offsetX + (int) (highRisk.x * drawScale) - 4, offsetY + (int) (highRisk.y * drawScale) - 4, 8, 8);
    }

    /**
     * Specifies style of point to represent a path of the robot.
     *
     * @param g Graphics to use
     * @param dot Center of the point to draw
     * @param offsetX Offset on x axis.
     * @param offsetY Offset on y axis.
     */
    private void drawPathDot(Graphics g, Location dot, int offsetX, int offsetY)
    {
        g.setColor(Color.GREEN);
        g.fillOval(offsetX + (int) (dot.x * drawScale) - 1, offsetY + (int) (dot.y * drawScale) - 1, 3, 3);
        //g.fillOval(offsetX + (int) (dot.x * drawScale) - 3, offsetY + (int) (dot.y * drawScale) - 3, 6, 6);
    }

    /**
     * Draws state of Sonar sensors somewhere in the middle of the white stripe.
     * Blue column means NORISK, Green column means LOWRISK and Red means
     * HIGHRISK threat.
     *
     * @param g Graphics to use.
     */
    private void drawSonars(Graphics g)
    {
        if(sonars == null)
        {
            return;
        }
        int count = 0;
        int scale = (panelWidth - 2 * drawScale) / (sonars.size());
        for(Double sonar : sonars)
        {
            if(sonar < highRisk.get(count))
            {
                g.setColor(Color.red);
            }
            else if(sonar < lowRisk.get(count))
            {
                g.setColor(Color.green);
            }
            else
            {
                g.setColor(Color.BLUE);
            }
            g.fillRect(drawScale * 2 + count * scale, 350, scale - 1, (int) (sonar.doubleValue() * drawScale * 2));
            count++;
        }
    }

    /**
     * Draws a line into the preview bitmap.
     *
     * @param x1 Start X coordinate.
     * @param y1 Start Y coordinate
     * @param x2 End X coordinate.
     * @param y2 End Y coordinate.
     * @param c Color of the line
     * @param g Graphics to use.
     */
    private void drawImageLine(double x1, double y1, double x2, double y2, Color c, Graphics2D g)
    {
        Line2D line = new Line2D.Double(x1, y1, x2, y2);
        g.setColor(c);
        g.draw(line);
    }

    /**
     * Draws a line to input graphics with specified color.
     *
     * @param g Graphics to use.
     * @param c Color of the line.
     * @param x1 Start X coordinate.
     * @param y1 Start Y coordinate
     * @param x2 End X coordinate.
     * @param y2 End Y coordinate.
     */
    private void drawLine(Graphics g, Color c, double x1, double y1, double x2, double y2)
    {
        g.setColor(c);
        g.drawLine((int) x1, (int) y1, (int) x2, (int) y2);
    }

    /**
     * Draws point to input graphics with sepcified color.
     *
     * @param g Graphics to use.
     * @param c Color of the point.
     * @param x X coordinate.
     * @param y Y coordinate.
     */
    private void drawPoint(Graphics g, Color c, double x, double y)
    {
        g.setColor(c);
        int xn = (int) x - offsetX;
        int yn = (int) y - offsetY;
        if(keepDataArrayGreat((int) x, (int) y))
        {//old raw values plus new fresh offsets
            g.drawLine(xn + offsetX, yn + offsetY, xn + offsetX, yn + offsetY);
        }
        else
        {
            g.drawLine((int) x, (int) y, (int) x, (int) y);
        }
    }

    /**
     * [x,y] is inside some obstacle -> return obstacle can not be extended ->
     * take another obstacle that can try to extend it, if extended obstacle !=
     * null return(succesfully extended)
     *
     * @param x X coordinate.
     * @param y Y coordinate.
     */
    private void addObstacle(double x, double y)
    {
        for(Obstacle1 obstacle : obstacles)
        {
            if(obstacle.isWithin(x, y))
            {
                return;
            }
            if(!obstacle.canExtend())
            {
                continue;
            }
            Obstacle1 newObstacle = obstacle.tryExtend(x, y);
            if(newObstacle != null)
            {
                return;
            }
        }
        obstacles.add(new Obstacle1(x, y));
    }
    //<editor-fold defaultstate="collapsed" desc="Setters - methods used to fill Collections and variables used to display current and past situation">

    /**
     * The Robot keeps its altitude based on an avarage value of ten rays below
     * the robot. The <B>offset</B> is computed based on Robots roll, so if the
     * Robot gets itself to a tilt position it needs to be able to correctly
     * estimate the rays heading straight towards the ground.
     *
     * @param offset Index of the first ray of the bunch which are used to
     * estimate an altitude of the Robot
     */
    public void setOffset(int offset)
    {
        this.offset = offset;
    }

    /**
     * Sets the sonar data that bear an information about what is going on in
     * front of the Robot.
     *
     * @param sonars Collection of double values sorted from left to right.
     */
    public void setSonars(Collection<Double> sonars)
    {
        this.sonars = sonars;
    }

    /**
     * Adds a diversion point to local collection of Diversion Point.
     *
     * @param diversion Location of a point that pulls the Robot out of crisis
     * sitation.
     */
    public void setDivPoint(Location diversion)
    {
        robotDiversions.add(diversion);
        drawDiversion(tmpG, diversion, offsetX, offsetY);
    }

    /**
     * Assd a start location point to local collection of Start Locations.
     *
     * @param start A location that signifies where the robot started from.
     */
    public void setStartLocation(Location start)
    {
        robotStartPoints.add(start);
        drawStartPose(tmpG, start, offsetX, offsetY);
    }

    /**
     * Adds a point to local collection of Battery_needed Points.
     *
     * @param breakPoint Location of a point when the scanning process was
     * interrupted by low battery level.
     *
     */
    public void setRechargeBreakPoint(Location breakPoint)
    {
        robotRechargePoints.add(breakPoint);
        drawRechargePoint(tmpG, breakPoint, offsetX, offsetY);
    }

    /**
     * Adds a point to local collection of High risk situation points.
     *
     * @param highRisk Location of a point where the robot was in high risk
     * situation.
     */
    public void setHighRiskPoint(Location highRisk)
    {
        robotHighRiskPoints.add(highRisk);
        drawHighRisk(tmpG, highRisk, offsetX, offsetY);
    }

    /**
     * Adds a point to local collection of Low risk situation points.
     *
     * @param lowRisk Location of a point where the robot was in low risk
     * situation.
     */
    public void setLowRiskPoint(Location lowRisk)
    {
        robotLowRiskPoints.add(lowRisk);
        drawLowRisk(tmpG, lowRisk, offsetX, offsetY);
    }

    /**
     * Adds a record of location and list of ranges from Range scanner.
     *
     * @param rec Object from the robot's sensor estimating location and ranges
     * of Range scanner.
     */
    public void setRecord(Record rec)///*objekt kterej má v sobě 2D pozici[x,y] a hodnoty laserscanneru*/)
    {
        recordPrev = record;
        record = rec;
    }

    /**
     * Actualizes an info set that will be inserted to the output image.
     *
     * @param info Set of name/value pairs to write to the output image.
     */
    public void setPostInfo(String info)
    {
        this.postInfo = info;
    }

    /**
     * Flag for saving the dat fila along with the output image
     *
     * @param write True to save a *.dat file, false to not.
     */
    public void setDatFile(boolean write)
    {
        this.datFile = write;
    }

    /**
     * Invalidates the form.
     */
    public void refreshGraphics()
    {
        this.update(this.getGraphics());
    }

    /**
     * Actualizes an info set that will be inserted to the white stripe on the
     * preview form.
     *
     * @param text Set of name/value pairs to write to the white stripe on the
     * preview form.
     */
    public void setInfo(String text)
    {
        this.actInfo = text;
    }

    /**
     * Sets the estimated rotation of the robot.
     *
     * @param rot Orientation of the robot
     */
    public void setOrientation(Rotation rot)
    {
        rotPrev = this.rot;
        this.rot = rot;
    }
    private int everyOther = 0;

    /**
     * Sets the estimated locatio nof the robot.
     *
     * @param loc Location of the robot.
     */
    public void setLocation(Location loc)
    {
        locPrev = this.loc;
        this.loc = loc;
        drawPathDot(tmpG, loc, offsetX, offsetY);
        if(everyOther > 10)
        {
            everyOther = 0;
            robotPath.add(loc);
        }
        else
        {
            everyOther++;
        }
    }
    //</editor-fold>
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
}
