/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.StateMessage;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.token.IToken;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class USAR2004BotLogic<BOT extends USAR2004Bot>
extends LogicModule<BOT> {
    private static final int DEFAULT_USAR_LOGIC_FREQUENCY = 5;
    private EventReactOnce<NfoMessage> gameInfoReaction;
    private EventReactOnce<StateMessage> stateMessageReaction;
    private BusAwareCountDownLatch latch;
    private Flag<Boolean> gameInfoCame = new Flag((Object)false);
    private Flag<Boolean> stateMessageCame = new Flag((Object)false);

    @Inject
    public USAR2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent.getWorldView()));
    }

    public USAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent.getWorldView()));
    }

    public USAR2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.gameInfoReaction = new EventReactOnce<NfoMessage>(NfoMessage.class, agent.getWorldView()){

            protected void react(NfoMessage event) {
                USAR2004BotLogic.this.gameInfoCame.setFlag((Object)true);
            }
        };
        this.stateMessageReaction = new EventReactOnce<StateMessage>(StateMessage.class, agent.getWorldView()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void react(StateMessage event) {
                Flag flag = USAR2004BotLogic.this.stateMessageCame;
                synchronized (flag) {
                    USAR2004BotLogic.this.stateMessageCame.setFlag((Object)true);
                    USAR2004BotLogic.this.latch.countDown();
                }
            }
        };
        this.cleanUp();
    }

    protected void logicLatch(String threadName) {
        super.logicLatch(threadName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(threadName + ": Waiting for the first State message.");
        }
        if (!this.latch.await(120L, TimeUnit.SECONDS)) {
            throw new ComponentCantStartException("State message was not received in 120secs.", (IComponent)this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(threadName + ": First STATE message received, starting logic cycles.");
        }
        if (!((Boolean)this.gameInfoCame.getFlag()).booleanValue() && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(threadName + ": GAMEINFO (NFO) message DID NOT COME! Even though State message has been received. Was it disabled in USARSim2004.ini? Or is it a bug... ?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(boolean startPaused) throws AgentException {
        super.start(startPaused);
        this.setLogicFrequency(5.0);
        Flag<Boolean> flag = this.stateMessageCame;
        synchronized (flag) {
            this.latch = new BusAwareCountDownLatch(1, ((USAR2004Bot)this.agent).getEventBus(), new IToken[]{((USAR2004Bot)this.agent).getWorldView().getComponentId()});
            if (((Boolean)this.stateMessageCame.getFlag()).booleanValue()) {
                this.latch.countDown();
            }
        }
    }

    protected void cleanUp() throws AgentException {
        super.cleanUp();
        this.gameInfoCame.setFlag((Object)false);
        this.gameInfoReaction.enable();
        this.stateMessageReaction.enable();
        this.stateMessageCame.setFlag((Object)false);
    }
}

