/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

import math.geom2d.Point2D;

/**
 *
 * @author vejmanm
 */
public class Obstacle
{
    public static final double obstacleSize = 1;
    public static final double joinDistance = 1.5d;
    public static final double maxExtendRatio = 1d / 4;
    public static final double maxEdgeSize = 10;
    private Point2D corner;
    private double width;
    private double height;

    public Obstacle(Point2D corner, double width, double height)
    {
        this.corner = corner;
    }

    /**
     * Initial constructor, center is the center of an obstacle, width and
     * height is given by robot dimension(0.5). From the center point it is
     * computed the corner Point also.
     *
     * @param center Center of a new obstacle.
     */
    public Obstacle(Point2D center)
    {
        this(center.x, center.y);
    }

    public Obstacle(double centerX, double centerY)
    {
        this.corner = new Point2D(centerX - obstacleSize / 2, centerY - obstacleSize / 2);
        this.width = obstacleSize;
        this.height = obstacleSize;
    }

    /**
     * Extends obstacle bounds when new obstacle found near existing one.
     *
     * @param x X coordinate of the centre of a new obstacle
     * @param y Y coordinate of the centre of a new obstacle
     * @return Returns true if obstacle was extended, false otherwise
     */
    private boolean extend(double x, double y)
    {
        boolean extended = false;
        if(corner.x > x - obstacleSize)
        {
            width += corner.x - (x - obstacleSize);
            corner.x = x - obstacleSize;
            extended = true;
        }
        if(corner.x + width < x + obstacleSize)
        {
            width = x + obstacleSize - corner.x;
            extended = true;
        }
        if(corner.y > y - obstacleSize)
        {
            height += corner.y - (y - obstacleSize);
            corner.y = y - obstacleSize;
            extended = true;
        }
        if(corner.y + height < y + obstacleSize)
        {
            height = y + obstacleSize - corner.y;
            extended = true;
        }
        return extended;
    }

    // <editor-fold desc="Getters" defaultstatestate="collapsed"> 
    public double getWidth()
    {
        return width;
    }

    public double getHeight()
    {
        return height;
    }

    public Point2D getCorner()
    {
        return corner;
    }
    // </editor-fold>

    /**
     * If new Obstacle [x,y] is within the distance of joinDistance, i will
     * extend this Obstacle boundbox by this point [x,y] plus its own boundbox
     * of obstacleSize. If a small square is within the absorb region of this
     * rectangle, it will enlarge itself to absorb this square so we don't need
     * to create a new obstacle object.
     *
     * @param x x coordinate of new obstacle (Obstacle of a minimum size)
     * @param y y coordinate of new obstacle (Obstacle of a minimum size)
     * @return Returns Can = 1, Can not = -1 and is already inside = 0
     */
    public Obstacle tryExtend(double x, double y)
    {
        if(x > this.corner.x - joinDistance
                && x < this.corner.x + this.width + joinDistance
                && y > this.corner.y - joinDistance
                && y < this.corner.y + this.height + joinDistance)
        {
            extend(x, y);
            return this;
        }
        return null;
    }

    /**
     * If Obstacle grows only one dimension enough we don't want to extend it
     * nomore. It is good to have more smaller more accurate than fewer larger
     * and sitorted obstacle boundboxes.
     *
     * @return Returns if obstacle is able to grow
     */
    public boolean canExtend()
    {
        if((maxExtendRatio * width < height) && (maxExtendRatio * height < width))
        {
            if(width > maxEdgeSize || height > maxEdgeSize)
            {
                return false;
            }
        }
        return true;
    }

    public boolean isInside(double x, double y)
    {
        if(x > this.corner.x
                && x < this.corner.x + this.width
                && y > this.corner.y
                && y < this.corner.y + this.height)
        {
            return true;
        }
        return false;
    }

    public static Obstacle MergeObstacles(Obstacle blockA, Obstacle blockB)
    {
        //shorter terms
        double xA = blockA.corner.x;
        double xB = blockB.corner.x;
        double yA = blockA.corner.y;
        double yB = blockB.corner.y;
        //C = right lower corner of block A
        //D = right lower corner of block B
        double xC = xA + blockA.width;
        double yC = yA + blockA.height;
        double xD = xB + blockB.width;
        double yD = yB + blockB.height;
        //leftest and highest Point
        Point2D newCorner = new Point2D(Math.min(xA, xB), Math.min(yA, yB));
        double newWidth = Math.max(xC, xD) - newCorner.x;
        double newHeight = Math.max(yC, yD) - newCorner.y;
        return new Obstacle(newCorner, newWidth, newHeight);
    }
}
