package cz.cuni.amis.pogamut.udk.agent.navigation.martinnavigator;

import java.util.logging.Level;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.udk.agent.navigation.IUDKPathRunner;
import cz.cuni.amis.pogamut.udk.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.NullCheck;

public class MartinRunner implements IUDKPathRunner {
  
    /*========================================================================*/

    /**
     * Initializes direct running to the given destination.
     */
    public void reset()
    {
    }

    /*========================================================================*/
    
    public boolean runToLocation (Location firstLocation, Location secondLocation, Location focus, NavPointNeighbourLink navPointsLink, boolean reachable)
    {

    	// just keep running to location
        bot.getAct().act(new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));        
        return true;
    }

    /*========================================================================*/

    /** Agent's bot. */
    protected UDKBot bot;
    /** Loque memory. */
    protected AgentInfo memory;
    /** Agent's body. */
    protected AdvancedLocomotion body;
    /** Agent's log. */
    protected Logger log;
    /** Base agent's senses. */
	protected Senses senses;

    /*========================================================================*/

    /**
     * Constructor.
     * @param bot Agent's bot.
     * @param memory Loque memory.
     */
    public MartinRunner (UDKBot bot, AgentInfo agentInfo, AdvancedLocomotion locomotion, Logger log) {
        // setup reference to agent
    	NullCheck.check(bot, "bot");
    	this.bot = bot;
        NullCheck.check(agentInfo, "agentInfo");
        this.memory = agentInfo;
        NullCheck.check(locomotion, "locomotion");
        this.body = new AdvancedLocomotion(bot, log);
        this.senses = new Senses(bot, memory, new Players(bot), log);
        this.log = log;
    }
    
}
