/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.bot.command;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.bot.command.SimpleShooting;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import java.util.logging.Logger;

public class AdvancedShooting
extends SimpleShooting {
    private double currentTime = 0.0;
    private double lastChargeShootCommandTime = -1.0;
    private double lastChargeShootCommandDelay = 0.0;
    private IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage bm) {
            AdvancedShooting.this.currentTime = bm.getTime();
            if (AdvancedShooting.this.lastChargeShootCommandTime >= 0.0 && AdvancedShooting.this.currentTime - AdvancedShooting.this.lastChargeShootCommandTime > AdvancedShooting.this.lastChargeShootCommandDelay) {
                ((UDKBot)AdvancedShooting.this.agent).getAct().act((CommandMessage)new StopShooting());
                AdvancedShooting.this.lastChargeShootCommandTime = -1.0;
                AdvancedShooting.this.lastChargeShootCommandDelay = 0.0;
            }
        }
    };

    public void stopShooting() {
        ((UDKBot)this.agent).getAct().act((CommandMessage)new StopShooting());
    }

    public void shootWithMode(boolean secondaryMode) {
        Shoot shoot = new Shoot();
        shoot.setAlt(secondaryMode);
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootPrimary(ILocated location) {
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootPrimary(UnrealId target) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootPrimary(Player target) {
        this.shootPrimary(target.getId());
    }

    public void shootSecondary(ILocated location) {
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        shoot.setAlt(true);
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootSecondary(UnrealId target) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        shoot.setAlt(true);
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
    }

    public void shootSecondary(Player target) {
        this.shootSecondary(target.getId());
    }

    public void shootPrimaryCharged(ILocated location, double chargeTime) {
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootPrimaryCharged(UnrealId target, double chargeTime) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootPrimaryCharged(Player target, double chargeTime) {
        this.shootPrimaryCharged(target.getId(), chargeTime);
    }

    public void shootSecondaryCharged(ILocated location, double chargeTime) {
        Shoot shoot = new Shoot();
        shoot.setLocation(location.getLocation());
        shoot.setAlt(true);
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootSecondaryCharged(UnrealId target, double chargeTime) {
        Shoot shoot = new Shoot();
        shoot.setTarget(target);
        shoot.setAlt(true);
        ((UDKBot)this.agent).getAct().act((CommandMessage)shoot);
        this.lastChargeShootCommandTime = this.currentTime;
        this.lastChargeShootCommandDelay = chargeTime;
    }

    public void shootSecondaryCharged(Player target, double chargeTime) {
        this.shootSecondaryCharged(target.getId(), chargeTime);
    }

    protected void reset() {
        this.lastChargeShootCommandTime = -1.0;
        this.lastChargeShootCommandDelay = 0.0;
    }

    public AdvancedShooting(UDKBot agent, Logger log) {
        super(agent, log);
        agent.getWorldView().addEventListener(BeginMessage.class, this.myBegListener);
    }

    @Override
    public void shoot() {
        super.shoot();
    }

    @Override
    public void shoot(UnrealId target) {
        super.shoot(target);
    }

    @Override
    public void shoot(Player target) {
        super.shoot(target);
    }

    @Override
    public void stopShoot() {
        super.stopShoot();
    }
}

