/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.server.impl;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentState;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarting;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.server.AbstractWorldServer;
import cz.cuni.amis.pogamut.base.utils.collections.adapters.WVVisibleObjectsSetAdapter;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.udk.bot.IUDKBot;
import cz.cuni.amis.pogamut.udk.bot.impl.NativeUDKBotAdapter;
import cz.cuni.amis.pogamut.udk.bot.jmx.BotJMXProxy;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.AddBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.GetMaps;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.PlayerListObtained;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.ReadyCommandRequest;
import cz.cuni.amis.pogamut.udk.communication.worldview.map.UDKMap;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.TranslatedObservableCollection;
import cz.cuni.amis.utils.flag.Flag;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public abstract class AbstractUDKServer<WORLD_VIEW extends IWorldView, ACT extends IAct>
extends AbstractWorldServer<WORLD_VIEW, ACT, IUDKBot>
implements IUDKServer {
    ObservableCollection<Player> players = null;
    List<Mutator> mutators = null;
    Flag<Double> gameSpeed = new Flag();
    List<MapList> maps = null;
    Flag<String> mapName = new Flag();
    private UDKMap map;
    ObservableCollection<? extends NativeUDKBotAdapter> nativeAgents = null;
    ObservableCollection<IUDKBot> agents = null;
    private String desiredPassword = null;
    private IWorldEventListener<PlayerListObtained> playerListObtainedListener = new IWorldEventListener<PlayerListObtained>(){

        public void notify(PlayerListObtained event) {
            AbstractUDKServer.this.players.addAll(event.getPlayers());
        }
    };
    private IWorldEventListener<MapPointListObtained> mapPointListObtainedListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            AbstractUDKServer.this.getAct().act((CommandMessage)new GetMaps());
        }
    };
    private SocketConnection connection;
    private IWorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new IWorldEventListener<ReadyCommandRequest>(){

        public void notify(ReadyCommandRequest event) {
            AbstractUDKServer.this.setState((AgentState)new AgentStateStarting("GameBots2004 greeted us, sending READY."));
            AbstractUDKServer.this.readyCommandRequested();
            AbstractUDKServer.this.setState((AgentState)new AgentStateStarting("READY sent."));
        }
    };
    private PasswordReply passwordReply = null;
    private IWorldEventListener<Password> passwordRequestedListener = new IWorldEventListener<Password>(){

        public void notify(Password event) {
            AbstractUDKServer.this.setState((AgentState)new AgentStateStarting("Password requested by the world."));
            AbstractUDKServer.this.passwordReply = AbstractUDKServer.this.createPasswordReply();
            if (AbstractUDKServer.this.passwordReply == null) {
                AbstractUDKServer.this.passwordReply = new PasswordReply("");
            }
            if (AbstractUDKServer.this.log.isLoggable(Level.INFO)) {
                AbstractUDKServer.this.log.info("Password required for the world, replying with '" + AbstractUDKServer.this.passwordReply.getPassword() + "'.");
            }
            AbstractUDKServer.this.getAct().act((CommandMessage)AbstractUDKServer.this.passwordReply);
        }
    };
    private GameInfo gameInfo = null;

    @Inject
    public AbstractUDKServer(IAgentId agentId, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, WORLD_VIEW worldView, ACT act) {
        super(agentId, agentLogger, bus, worldView, act);
        this.connection = connection;
        this.getWorldView().addEventListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addEventListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addEventListener(PlayerListObtained.class, this.playerListObtainedListener);
        this.getWorldView().addEventListener(MapPointListObtained.class, this.mapPointListObtainedListener);
        this.players = new WVVisibleObjectsSetAdapter(Player.class, this.getWorldView());
    }

    @Override
    public void setAddress(String host, int port) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Setting address to: " + host + ":" + port);
        }
        this.connection.setAddress((IWorldConnectionAddress)new SocketConnectionAddress(host, port));
    }

    public void setPassword(String password) {
        this.desiredPassword = password;
    }

    protected void readyCommandRequested() {
        this.getAct().act((CommandMessage)new Ready());
    }

    public PasswordReply getPasswordReply() {
        return this.passwordReply;
    }

    protected PasswordReply createPasswordReply() {
        return this.desiredPassword != null ? new PasswordReply(this.desiredPassword) : null;
    }

    public GameInfo getGameInfo() {
        if (this.gameInfo == null) {
            this.gameInfo = (GameInfo)this.getWorldView().getSingle(GameInfo.class);
        }
        return this.gameInfo;
    }

    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)super.getWorldView();
    }

    @Override
    public Collection<MapList> getAvailableMaps() {
        return this.maps;
    }

    @Override
    public Flag<Double> getGameSpeedFlag() {
        return this.gameSpeed;
    }

    @Override
    public String getMapName() {
        if (this.getGameInfo() == null) {
            return null;
        }
        return this.getGameInfo().getLevel();
    }

    @Override
    public ObservableCollection<Player> getPlayers() {
        return this.players;
    }

    @Override
    public List<Mutator> getMutators() {
        return this.mutators;
    }

    public ObservableCollection<IUDKBot> getAgents() {
        if (this.agents != null) {
            return this.agents;
        }
        if (this.getPlayers() == null) {
            return null;
        }
        this.agents = new TranslatedObservableCollection<IUDKBot, Player>(this.getPlayers()){

            protected IUDKBot translate(Player obj) {
                if (obj.getJmx() != null) {
                    try {
                        return new BotJMXProxy(obj.getJmx());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AbstractUDKServer.class.getName()).log(Level.SEVERE, "JMX error", ex);
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            }

            protected Object getKeyForObj(Player elem) {
                return elem.getId();
            }
        };
        return this.agents;
    }

    @Override
    public ObservableCollection<? extends NativeUDKBotAdapter> getNativeAgents() {
        if (this.nativeAgents != null) {
            return this.nativeAgents;
        }
        if (this.getPlayers() == null) {
            return null;
        }
        this.nativeAgents = new TranslatedObservableCollection<NativeUDKBotAdapter, Player>(this.getPlayers()){

            protected NativeUDKBotAdapter translate(Player obj) {
                if (obj.getJmx() == null) {
                    try {
                        return new NativeUDKBotAdapter(obj, AbstractUDKServer.this, AbstractUDKServer.this.getAct(), (IWorldView)AbstractUDKServer.this.getWorldView());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AbstractUDKServer.class.getName()).log(Level.SEVERE, "JMX error", ex);
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            }

            protected Object getKeyForObj(Player elem) {
                return elem.getId();
            }
        };
        return this.nativeAgents;
    }

    @Override
    public void connectNativeBot(String botName, String botType) {
        this.getAct().act((CommandMessage)new AddBot(botName, null, null, 3, botType));
    }

    @Override
    public UDKMap getMap() {
        if (this.map == null) {
            this.map = new UDKMap((IWorldView)this.getWorldView());
        }
        return this.map;
    }

    protected void reset() {
        this.map = null;
        this.gameInfo = null;
        if (this.players != null) {
            this.players.clear();
        }
        if (this.mutators != null) {
            this.mutators.clear();
        }
        if (this.maps != null) {
            this.maps.clear();
        }
        if (this.nativeAgents != null) {
            this.nativeAgents.clear();
        }
        if (this.agents != null) {
            this.agents.clear();
        }
    }

    protected void resetAgent() {
        super.resetAgent();
        this.reset();
    }

    protected void stopAgent() {
        super.stopAgent();
        this.reset();
    }

    protected void killAgent() {
        super.killAgent();
        this.reset();
    }

    protected void startAgent() {
        super.startAgent();
    }
}

