/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.observer.impl;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractGhostAgent;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentState;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarting;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReactOnce;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.ReadyCommandRequest;
import cz.cuni.amis.pogamut.udk.observer.IUDKObserver;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@AgentScoped
public abstract class AbstractUDKObserver<WORLD_VIEW extends IVisionWorldView, ACT extends IAct>
extends AbstractGhostAgent<WORLD_VIEW, ACT>
implements IUDKObserver {
    private String desiredPassword = null;
    private ObjectEventReactOnce<GameInfo, IWorldObjectEvent<GameInfo>> latchRaiseReact;
    private BusAwareCountDownLatch latch;
    private IWorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new IWorldEventListener<ReadyCommandRequest>(){

        public void notify(ReadyCommandRequest event) {
            AbstractUDKObserver.this.setState((AgentState)new AgentStateStarting("GameBots2004 greeted us, sending READY."));
            AbstractUDKObserver.this.readyCommandRequested();
            AbstractUDKObserver.this.setState((AgentState)new AgentStateStarting("READY sent."));
        }
    };
    private PasswordReply passwordReply = null;
    private IWorldEventListener<Password> passwordRequestedListener = new IWorldEventListener<Password>(){

        public void notify(Password event) {
            AbstractUDKObserver.this.setState((AgentState)new AgentStateStarting("Password requested by the world."));
            AbstractUDKObserver.this.passwordReply = AbstractUDKObserver.this.createPasswordReply();
            if (AbstractUDKObserver.this.passwordReply == null) {
                AbstractUDKObserver.this.passwordReply = new PasswordReply("");
            }
            if (AbstractUDKObserver.this.log.isLoggable(Level.INFO)) {
                AbstractUDKObserver.this.log.info("Password required for the world, replying with '" + AbstractUDKObserver.this.passwordReply.getPassword() + "'.");
            }
            AbstractUDKObserver.this.getAct().act((CommandMessage)AbstractUDKObserver.this.passwordReply);
        }
    };

    @Inject
    public AbstractUDKObserver(IAgentId agentId, IComponentBus bus, IAgentLogger agentLogger, WORLD_VIEW worldView, ACT act) {
        super(agentId, bus, agentLogger, worldView, act);
        this.getWorldView().addEventListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addEventListener(Password.class, this.passwordRequestedListener);
        this.latch = new BusAwareCountDownLatch(1, bus, new IComponent[]{this.getWorldView()});
        this.latchRaiseReact = new ObjectEventReactOnce<GameInfo, IWorldObjectEvent<GameInfo>>(GameInfo.class, this.getWorldView()){

            protected void react(IWorldObjectEvent<GameInfo> event) {
                AbstractUDKObserver.this.latch.countDown();
            }
        };
    }

    public void setPassword(String password) {
        this.desiredPassword = password;
    }

    protected void readyCommandRequested() {
        this.getAct().act((CommandMessage)new Ready());
    }

    public PasswordReply getPasswordReply() {
        return this.passwordReply;
    }

    protected PasswordReply createPasswordReply() {
        return this.desiredPassword != null ? new PasswordReply(this.desiredPassword) : null;
    }

    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)((IVisionWorldView)super.getWorldView());
    }

    protected void reset() {
        this.latch.countDown();
        this.latch = new BusAwareCountDownLatch(1, this.getEventBus(), new IComponent[]{this.getWorldView()});
        this.latchRaiseReact.enable();
    }

    protected void startAgent() {
        super.startAgent();
        if (!this.latch.await(60000L, TimeUnit.MILLISECONDS)) {
            throw new ComponentCantStartException("GameInfo message was not received in 60 secs.", (IComponent)this);
        }
    }

    protected void resetAgent() {
        super.resetAgent();
        this.reset();
    }

    protected void stopAgent() {
        super.stopAgent();
        this.reset();
    }

    protected void killAgent() {
        super.killAgent();
        this.reset();
    }
}

