package cz.cuni.amis.pogamut.udk.logging.jmx;

import java.util.Set;

import junit.framework.Assert;

import org.junit.Test;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.udk.factory.direct.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.test.BaseUDKTest;

/**
 * @author ik
 */
public class UDKTest01_AgentJmxLogging extends BaseUDKTest {

    /**
     * Tests that log categories are exported through the JMX.
     */
    @Test
    public void testJmxLoggingCategory() {
        final String LOG_CAT_NAME = "testCategory";
        IAgent localBot = startUTBot(BotBaseTest.class);
        // add the cathegory
        localBot.getLogger().getCategory(LOG_CAT_NAME);
        Set<String> catNames = localBot.getLogger().getCategories().keySet();

        IUDKServer server = startUTServer(new UDKServerFactory());

        IAgent jmxBot = null;
        // find our agent
        for (IAgent bot : server.getAgents()) {
            if (bot.getComponentId().getToken().equals(localBot.getComponentId().getToken())) {
                jmxBot = bot;
                break;
            }
        }
        Assert.assertTrue("Bot wasn't found through JMX.", jmxBot != null);

        Assert.assertTrue("Some category wasn't present in the JMX proxy.",
                jmxBot.getLogger().getCategories().keySet().containsAll(catNames));
    }
}
