package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.converter;

import java.util.LinkedList;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.udk.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.WorldViewTestPlanContainer;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;

public class WorldViewTestPlanContainerConverter implements Converter {
	
	protected final XStream owner;
	private WorldViewTestContext ctx;
	
	public WorldViewTestPlanContainerConverter(WorldViewTestContext ctx,
			XStream owner) {
		this.owner = owner;
		this.ctx = ctx;
	}
	
	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {
		
		WorldViewTestPlanContainer plan = (WorldViewTestPlanContainer)value;
		writer.startNode("InputEvents");
		context.convertAnother(plan.getInputEvents());
		writer.endNode();
		
		writer.startNode("ExpectedEvents");
		context.convertAnother(plan.getExpectedEvents());
		writer.endNode();		
				
		writer.startNode("EventWrappers");
		context.convertAnother(plan.getEventWrappers(),
				new EventWrapperListConverter(plan.getInputEvents(),
						plan.getExpectedEvents()));
		writer.endNode();
		
		writer.startNode("Plan");
		context.convertAnother(plan.getExpectedEventsPlan(),
				new ExpectedEventsPlanSequenceConverter(ctx, plan.getEventWrappers()));
		writer.endNode();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
			
        WorldViewTestPlanContainer container = new WorldViewTestPlanContainer();                                
        
		reader.moveDown();
		container.assignInputEvents(
				(LinkedList<? extends IWorldChangeEvent>) context.convertAnother(container,
						LinkedList.class));
		reader.moveUp();
		
		reader.moveDown();
		container.assignExpectedEvents(
				(LinkedList<? extends IWorldEvent>) context.convertAnother(container,
						LinkedList.class));
        reader.moveUp();
		
        owner.registerConverter(new EventWrapperConverter(
        		ctx));
        owner.registerConverter(new ObjectClassEventWrapperConverter(
        		ctx));
        owner.registerConverter(new ObjectInstanceEventWrapperConverter(
        		ctx));
        
        reader.moveDown();
        container.assignEventWrappers((LinkedList) context.convertAnother(container, LinkedList.class,
        		new EventWrapperListConverter(container.getInputEvents(), container.getExpectedEvents())));
        reader.moveUp();
        
        reader.moveDown();
        container.assignExpectedEventsPlan(
        		(LinkedList<EventWrapperWithCallCount>) context.convertAnother(container, LinkedList.class,
        		new ExpectedEventsPlanSequenceConverter(ctx, container.getEventWrappers())));
        reader.moveUp();
                
        return container;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == WorldViewTestPlanContainer.class;
	}
	
	
}
