package cz.cuni.amis.pogamut.udk.factory.guice.remoteagent;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.params.IRemoteAgentParameters;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;

/**
 * Guice-base {@link IUDKServer} factory. It needs {@link UDKServerModule} to work correctly and the module is required
 * to bound {@link IAgent} to the {@link IUDKServer}, otherwise the method {@link UDKServerFactory#newAgent(IRemoteAgentParameters)}
 * will throw {@link ClassCastException}.
 * <p><p>
 * For more info about the factory, see {@link GuiceAgentFactory}.
 *
 * @author Jimmy
 *
 * @param <BOT>
 * @param <PARAMS>
 */
public class UDKServerFactory<SERVER extends IUDKServer, PARAMS extends UDKAgentParameters> extends GuiceAgentFactory<SERVER, PARAMS> {

	public UDKServerFactory(UDKServerModule agentModule) {
		super(agentModule);
	}
	
	@Override
	protected UDKServerModule getAgentModule() {
		return (UDKServerModule) super.getAgentModule();
	}

}
