package cz.cuni.amis.pogamut.udk.communication.translator.shared.events;

import java.util.List;

import cz.cuni.amis.pogamut.base.communication.translator.event.WorldEventIdentityWrapper;

/**
 * Event notifying that list of some objects/events was received.
 * @author ik
 */
public class ListObtained<T> extends WorldEventIdentityWrapper {

	private List<T> list;

	public ListObtained(List<T> list) {
		this.list = list;
	}

    /**
     * Returns list of received objects.
     * @return
     */
	public List<T> getList() {
		return list;
	}
	
	public long getSimTime() {
    	return 0;
    }

	@Override
	public String toString() {
		return "ListObtained[items = " + list.size() + "]";
	}

}
