package cz.cuni.amis.pogamut.udk.agent.module.logic;

import java.util.logging.Logger;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;

import java.util.logging.Level;

public class SyncUDKBotLogic<BOT extends UDKBot<? extends ILockableVisionWorldView, ?, ?>> extends UDKBotLogic<BOT> {

	private EventReact<EndMessage>        endReactionAfterRespawn;
	private int						      shouldExecuteLogicLatch = 0;
	
	private ICommandListener<Respawn> respawnListener = new ICommandListener<Respawn>() {		

		@Override
		public void notify(Respawn event) {			
			synchronized(respawnListener) {
				endReactionAfterRespawn.enable();
				shouldExecuteLogicLatch = 2;
			}
		}
		
	};
	
	@Inject
	public SyncUDKBotLogic(BOT agent, IAgentLogic logic) {
		this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(agent.getWorldView()));
	}
	
	public SyncUDKBotLogic(BOT agent, IAgentLogic logic, Logger log) {
		this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(agent.getWorldView()));
	}
	
	public SyncUDKBotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
		super(agent, logic, log, dependencies);
		endReactionAfterRespawn = new EventReact<EndMessage>(EndMessage.class, agent.getWorldView()) {
			@Override
			protected void react(EndMessage event) {
				synchronized(respawnListener) {
					if (shouldExecuteLogicLatch > 0) {
						--shouldExecuteLogicLatch;
					}
				}
			}
		};
		agent.getAct().addCommandListener(Respawn.class, respawnListener);
	}
	
	@Override
	protected void beforeLogic(String threadName) {
		super.beforeLogic(threadName);
		if (log.isLoggable(Level.FINEST)) log.finest(threadName + ": Locking world view.");
		agent.getWorldView().lock();
		if (log.isLoggable(Level.FINER)) log.finer(threadName + ": World view locked.");
	}
	
	@Override
	protected void afterLogic(String threadName) {
		super.afterLogic(threadName);
		if (log.isLoggable(Level.FINEST)) log.finest(threadName + ": Unlocking world view.");
		agent.getWorldView().unlock();
		if (log.isLoggable(Level.FINER)) log.finer(threadName + ": World view unlocked.");
	}
	
	@Override
	protected void afterLogicException(String threadName, Throwable e) {
		super.afterLogicException(threadName, e);
		if (agent.getWorldView().isLocked()) {
			if (log.isLoggable(Level.FINEST)) log.finest("Unlocking world view.");
			agent.getWorldView().unlock();
			if (log.isLoggable(Level.FINER)) log.finer("World view unlocked.");
		}
	}
	
	@Override
	protected boolean shouldExecuteLogic() {
		synchronized(respawnListener) {
			if (shouldExecuteLogicLatch != 0) {
				if (log.isLoggable(Level.INFO)) log.info("Respawn command sensed - waiting for the bot respawn to execute logic with correct world view state.");
				return false;
			} else {
				return true;
			}
		}			
	}
	
}
