/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.test;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IRemoteAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotController;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotFactory;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotModule;
import cz.cuni.amis.pogamut.udk.observer.IUDKObserver;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.udk.utils.PogamutUDKProperty;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.pogamut.udk.utils.UDKBotRunner;
import cz.cuni.amis.pogamut.udk.utils.UDKObserverRunner;
import cz.cuni.amis.pogamut.udk.utils.UDKServerRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Before;

public class BaseUDKTest {
    protected IAgentId testId;
    protected LogCategory log;
    protected UCCWrapper ucc = null;
    protected boolean useInternalUcc = !Pogamut.getPlatform().getBooleanProperty(PogamutUDKProperty.POGAMUT_UNREAL_TEST_EXT_SERVER.getKey());

    public BaseUDKTest() {
        this.testId = new AgentId("Test");
        this.log = new LogCategory("UDKTest");
        this.log.addHandler((ILogPublisher)new LogPublisher.ConsolePublisher(this.testId));
    }

    public void startUCC(UCCWrapper.UCCWrapperConf uccConf) throws UCCStartException {
        if (this.useInternalUcc) {
            this.ucc = new UCCWrapper(uccConf);
        }
    }

    public void endUcc() {
        if (this.useInternalUcc) {
            this.ucc.stop();
        }
    }

    @Before
    public void startTest() throws UCCStartException {
        this.startUCC(new UCCWrapper.UCCWrapperConf());
    }

    @After
    public void endTest() {
        this.endUcc();
        Pogamut.getPlatform().close();
    }

    protected boolean awaitAgentUp(AbstractAgent agent) {
        System.out.println("Awaiting server UP(timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag)agent.getState(), IAgentStateUp.class).await(60000L, TimeUnit.MILLISECONDS);
        return state != null && state instanceof IAgentStateUp;
    }

    protected boolean awaitAgentDown(AbstractAgent agent) {
        System.out.println("Awaiting server DOWN (timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag)agent.getState(), IAgentStateDown.class).await(120000L, TimeUnit.MILLISECONDS);
        return state != null && state instanceof IAgentStateDown;
    }

    protected <T extends IUDKBotController> UDKBot startUTBot(Class<T> controller) {
        UDKBotFactory factory = new UDKBotFactory(new UDKBotModule(controller));
        String host = Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getBotPort();
        }
        UDKBotRunner botRunner = new UDKBotRunner((IAgentFactory)factory, "TEST factory", host, port);
        UDKBot bot = (UDKBot)botRunner.startAgent();
        return bot;
    }

    protected IUDKServer startUTServer(IAgentFactory<IUDKServer, IRemoteAgentParameters> factory) {
        String host = Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UDK_SERVER_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutUDKProperty.POGAMUT_UDK_SERVER_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getControlPort();
        }
        UDKServerRunner runner = new UDKServerRunner(factory, "TEST server", host, port){

            protected void preStartHook(IAgent agent) throws PogamutException {
                super.preStartHook(agent);
                agent.getLogger().setLevel(Level.ALL);
            }
        };
        return runner.startAgent();
    }

    protected IUDKObserver startUTObserver(IAgentFactory<IUDKObserver, IRemoteAgentParameters> factory) {
        String host = Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UDK_SERVER_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutUDKProperty.POGAMUT_UDK_SERVER_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getObserverPort();
        }
        UDKObserverRunner runner = new UDKObserverRunner(factory, "TEST observer", host, port){

            protected void preStartHook(IAgent agent) throws PogamutException {
                super.preStartHook(agent);
                agent.getLogger().setLevel(Level.ALL);
            }
        };
        return runner.startAgent();
    }
}

