package cz.cuni.amis.pogamut.udk.observer.impl;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.communication.worldview.UDKWorldView;

public class UDKObserver extends AbstractUDKObserver<UDKWorldView, IAct> {
	
	/**
	 * Parameters passed into the constructor/factory/runner (by whatever means the agent has been started).
	 */
    private UDKAgentParameters params;

	@Inject
    public UDKObserver(UDKAgentParameters params, IComponentBus bus, IAgentLogger agentLogger, UDKWorldView worldView, IAct act) {
        super(params.getAgentId(), bus, agentLogger, worldView, act);
        this.params = params;
    }
    
    /**
     * Returns parameters that were passed into the agent during the construction. 
     * <p><p>
     * This is a great place to parametrize your agent. Note that you may pass arbitrary subclass of {@link UDKAgentParameters}
     * to the constructor/factory/runner and pick them up here.
     * 
     * @return parameters
     */
    public UDKAgentParameters getParams() {
		return params;
	}

    
}
