package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.converter;


import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.udk.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.EventWrapper;

public class EventWrapperConverter implements Converter {
	
	
	protected class DeserializedWrapperData {
		public ListenerLevel level;
		public IWorldEvent expectedEvent;
	}

	protected WorldViewTestContext ctx;	
	
	public EventWrapperConverter(WorldViewTestContext ctx) {		
		this.ctx = ctx;
	}
	
	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {

		EventWrapper wrapper = (EventWrapper)value;
				
		writer.addAttribute("level", wrapper.getListenerLevel().toString());
			
		IWorldEvent wrappers_expected_event = wrapper.getExpectedEvent();
		
		if (wrappers_expected_event != null) {
			writer.startNode("ExpectedEvent");
			//writer.addAttribute("type", wrapper.getExpectedEvent().getClass().getName());
			context.convertAnother(wrapper.getExpectedEvent());
			writer.endNode();
		}
	}

	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
				
		// ListenerLevel level = ListenerLevel.valueOf(reader.getAttribute("level"));
		// if level != A then throw the fuck up stylishly
			
		IWorldEvent expected_event = null;
		
		if (reader.hasMoreChildren()) {
			reader.moveDown();			
			if (reader.getNodeName().equals("ExpectedEvent") &&
					(!reader.getValue().isEmpty() || reader.getAttribute("reference") != null)) {
				expected_event =
					(IWorldEvent) context.convertAnother(this, context.getRequiredType());
			}	
			reader.moveUp();
		}

		EventWrapper wrapper = new EventWrapper(ctx, expected_event);
		
		return wrapper;	
	}
	
	@SuppressWarnings("unchecked")
	@Override	
	public boolean canConvert(Class clazz) {
		return clazz == EventWrapper.class;
	}
}
