package cz.cuni.amis.pogamut.udk.communication.worldview;

import com.google.inject.Inject;
import com.google.inject.name.Named;

import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.impl.BatchAwareWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.worldview.objects.IGBViewable;
import cz.cuni.amis.pogamut.udk.communication.worldview.objects.IGBWorldObjectDisappeared;

/**
 * WorldView understanding some UDK semantics.
 * @author ik
 */
@AgentScoped
public class UDKWorldView extends BatchAwareWorldView {
	
	public static final String WORLDVIEW_DEPENDENCY = "UDKWorldViewDependency";
	
    @Inject
    public UDKWorldView(@Named(WORLDVIEW_DEPENDENCY) ComponentDependencies dependencies, IMediator mediator, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
        mediator.setConsumer(this);
    }

    @Override
    protected boolean isBatchEndEvent(IWorldChangeEvent evt) {
        return evt instanceof EndMessage;
    }
    
	@Override
	protected boolean isBatchBeginEvent(IWorldChangeEvent evt) {
		return evt instanceof BeginMessage;
	}    

    @Override
    protected void setDisappearedFlag(IViewable obj) {
        IGBViewable gbView = (IGBViewable) obj;
        IGBWorldObjectDisappeared dis = gbView.createDisappearEvent();        
        dis.update(obj);
    }
}
