package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.converter;


import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.udk.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.ObjectClassEventWrapper;

public class ObjectClassEventWrapperConverter extends ObjectEventWrapperConverter {
	
	public ObjectClassEventWrapperConverter(WorldViewTestContext ctx) {		
		super(ctx);
	}
	
	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {

		ObjectClassEventWrapper<?> wrapper = (ObjectClassEventWrapper<?>)value;
				
		super.marshal(value, writer, context);
		
		writer.startNode("Class");
		context.convertAnother(wrapper.getObjectClass());
		writer.endNode();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {

		DeserializedWrapperData dataForWrapper =
			(DeserializedWrapperData)super.unmarshal(reader, context);
		
		reader.moveDown();
		Class<IWorldObject> objectClass =
			(Class<IWorldObject>)context.convertAnother(dataForWrapper, Class.class);
		reader.moveUp();
		
		ObjectClassEventWrapper<?> wrapper =
			new ObjectClassEventWrapper<IWorldObject>(
					ctx,
					(IWorldObjectEvent<IWorldObject>) dataForWrapper.expectedEvent,
					objectClass,
					dataForWrapper.level);				
		
		return wrapper;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == ObjectClassEventWrapper.class;
	}

}
