/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.ClearBotsDirty;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.impl.AbstractExperimentRunner;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;

public class ReuseServerExperimentRunner<RESULT, PARAMETERS>
extends AbstractExperimentRunner<RESULT, PARAMETERS> {
    public static long DEFAULT_MAP_CHANGE_TIMEOUT = 100000L;
    private long mapChangeTimeout;
    private long botDieTimeout = 1000L;
    private UCCWrapper uccWrapper;

    public ReuseServerExperimentRunner(LogCategory log, long timeout, UCCWrapper.UCCWrapperConf configuration) {
        this(log, timeout, configuration, 120000L);
    }

    public ReuseServerExperimentRunner(LogCategory log, long timeout, UCCWrapper.UCCWrapperConf configuration, long serverStartTimeout) {
        this(log, timeout, configuration, serverStartTimeout, DEFAULT_MAP_CHANGE_TIMEOUT);
    }

    public ReuseServerExperimentRunner(LogCategory log, long timeout, UCCWrapper.UCCWrapperConf configuration, long serverStartTimeout, long mapChangeTimeout) {
        super(log, configuration, timeout, serverStartTimeout);
        this.mapChangeTimeout = mapChangeTimeout;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.uccWrapper = this.configureAndStartUCCWrapper(this.uccConfiguration);
    }

    @Override
    public void cleanup() {
        if (this.uccWrapper != null) {
            try {
                this.uccWrapper.stop();
            }
            catch (Exception ex) {
                this.log.severe("Failed to stop UCC.");
                this.log.severe(ExceptionToString.process((Throwable)ex));
            }
        }
        super.cleanup();
    }

    @Override
    protected UCCWrapper getUCCWrapper() {
        return this.uccWrapper;
    }

    @Override
    protected void prepareServerForExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
        String mapName = experiment.getMapName();
        this.uccWrapper.changeMap(mapName, false, this.mapChangeTimeout);
    }

    @Override
    protected void cleanupServerAfterExperiment() {
        this.uccWrapper.getUTServer().getAct().act((CommandMessage)new ClearBotsDirty());
        this.log.info("Sending ClearBotsDirty. Waiting a while to let it settle");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

