/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.impl.AbstractExperimentRunner;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;

public class FreshServerExperimentRunner<RESULT, PARAMETERS>
extends AbstractExperimentRunner<RESULT, PARAMETERS> {
    private UCCWrapper currentUCCWrapper;

    public FreshServerExperimentRunner(LogCategory log, long timeout, UCCWrapper.UCCWrapperConf configuration) {
        this(log, timeout, configuration, 120000L);
    }

    public FreshServerExperimentRunner(LogCategory log, long timeout, UCCWrapper.UCCWrapperConf configuration, long serverStartupTimeout) {
        super(log, configuration, timeout, serverStartupTimeout);
    }

    @Override
    protected UCCWrapper getUCCWrapper() {
        return this.currentUCCWrapper;
    }

    @Override
    protected void prepareServerForExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
        this.log.info("ExperimentRunner: Starting server.");
        this.currentUCCWrapper = null;
        UCCWrapper.UCCWrapperConf experimentConfiguration = new UCCWrapper.UCCWrapperConf();
        experimentConfiguration.applyDefaults(this.uccConfiguration);
        experimentConfiguration.setMapName(experiment.getMapName());
        this.currentUCCWrapper = this.configureAndStartUCCWrapper(experimentConfiguration);
        this.log.info("ExperimentRunner: Waiting for 2 sec to give UDKServer some time to catch up...");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.info("ExperimentRunner: Server started.");
    }

    @Override
    protected void cleanupServerAfterExperiment() {
        if (this.currentUCCWrapper != null) {
            try {
                this.currentUCCWrapper.stop();
            }
            catch (Exception ex) {
                this.log.severe("Failed to stop UCC.");
                this.log.severe(ExceptionToString.process((Throwable)ex));
            }
        }
    }
}

